/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.AbstractIterator;
import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class SequentialAccessSparseVector
extends AbstractVector {
    private OrderedIntDoubleMapping values;

    public SequentialAccessSparseVector() {
        super(0);
    }

    public SequentialAccessSparseVector(int cardinality) {
        this(cardinality, cardinality / 8);
    }

    public SequentialAccessSparseVector(int cardinality, int size) {
        super(cardinality);
        this.values = new OrderedIntDoubleMapping(size);
    }

    public SequentialAccessSparseVector(Vector other) {
        this(other.size(), other.getNumNondefaultElements());
        if (other.isSequentialAccess()) {
            Vector.Element e;
            Iterator<Vector.Element> it = other.iterateNonZero();
            while (it.hasNext() && (e = it.next()) != null) {
                this.set(e.index(), e.get());
            }
        } else {
            this.copySortedRandomAccessSparseVector(other);
        }
    }

    private int copySortedRandomAccessSparseVector(Vector other) {
        Vector.Element e;
        int elementCount = other.getNumNondefaultElements();
        Object[] sortableElements = new OrderedElement[elementCount];
        Iterator<Vector.Element> it = other.iterateNonZero();
        int s = 0;
        while (it.hasNext() && (e = it.next()) != null) {
            sortableElements[s++] = new OrderedElement(e.index(), e.get());
        }
        Arrays.sort(sortableElements);
        for (int i = 0; i < sortableElements.length; ++i) {
            this.values.getIndices()[i] = ((OrderedElement)sortableElements[i]).index;
            this.values.getValues()[i] = ((OrderedElement)sortableElements[i]).value;
        }
        this.values = new OrderedIntDoubleMapping(this.values.getIndices(), this.values.getValues(), elementCount);
        return elementCount;
    }

    public SequentialAccessSparseVector(SequentialAccessSparseVector other, boolean shallowCopy) {
        super(other.size());
        this.values = shallowCopy ? other.values : other.values.clone();
    }

    public SequentialAccessSparseVector(SequentialAccessSparseVector other) {
        this(other.size(), other.getNumNondefaultElements());
        this.values = other.values.clone();
    }

    private SequentialAccessSparseVector(int cardinality, OrderedIntDoubleMapping values) {
        super(cardinality);
        this.values = values;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return new SparseRowMatrix(rows, columns);
    }

    @Override
    public SequentialAccessSparseVector clone() {
        return new SequentialAccessSparseVector(this.size(), this.values.clone());
    }

    @Override
    public Vector assign(Vector other) {
        int size = this.size();
        if (size != other.size()) {
            throw new CardinalityException(size, other.size());
        }
        if (other instanceof SequentialAccessSparseVector) {
            this.values = ((SequentialAccessSparseVector)other).values.clone();
        } else {
            this.values = new OrderedIntDoubleMapping();
            Iterator<Vector.Element> othersElems = other.iterateNonZero();
            while (othersElems.hasNext()) {
                Vector.Element elem = othersElems.next();
                this.setQuick(elem.index(), elem.get());
            }
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        Iterator<Vector.Element> it = this.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            result.append(e.index());
            result.append(':');
            result.append(e.get());
            result.append(',');
        }
        if (result.length() > 1) {
            result.setCharAt(result.length() - 1, '}');
        }
        return result.toString();
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        this.values.set(index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.getNumMappings();
    }

    @Override
    public SequentialAccessSparseVector like() {
        return new SequentialAccessSparseVector(this.size(), this.values.getNumMappings());
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    @Override
    public Vector minus(Vector that) {
        if (this.size() != that.size()) {
            throw new CardinalityException(this.size(), that.size());
        }
        Vector result = that.clone();
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element thisElement = iter.next();
            int index = thisElement.index();
            result.setQuick(index, that.getQuick(index) - thisElement.get());
        }
        result.assign(Functions.NEGATE);
        return result;
    }

    private static final class OrderedElement
    implements Comparable<OrderedElement> {
        private final int index;
        private final double value;

        OrderedElement(int index, double value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(OrderedElement that) {
            return this.index - that.index;
        }

        public int hashCode() {
            return this.index ^ Doubles.hashCode((double)this.value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof OrderedElement)) {
                return false;
            }
            OrderedElement other = (OrderedElement)o;
            return this.index == other.index && this.value == other.value;
        }
    }

    private final class AllElement
    implements Vector.Element {
        private int index = -1;
        private int nextOffset;

        private AllElement() {
        }

        void advanceIndex() {
            ++this.index;
            if (this.index > SequentialAccessSparseVector.this.values.getIndices()[this.nextOffset]) {
                ++this.nextOffset;
            }
        }

        int getNextIndex() {
            return this.index + 1;
        }

        @Override
        public double get() {
            if (this.index == SequentialAccessSparseVector.this.values.getIndices()[this.nextOffset]) {
                return SequentialAccessSparseVector.this.values.getValues()[this.nextOffset];
            }
            return 0.0;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            SequentialAccessSparseVector.this.lengthSquared = -1.0;
            if (this.index == SequentialAccessSparseVector.this.values.getIndices()[this.nextOffset]) {
                ((SequentialAccessSparseVector)SequentialAccessSparseVector.this).values.getValues()[this.nextOffset] = value;
            } else {
                SequentialAccessSparseVector.this.values.set(this.index, value);
            }
        }
    }

    private final class NonDefaultElement
    implements Vector.Element {
        private int offset = -1;

        private NonDefaultElement() {
        }

        void advanceOffset() {
            ++this.offset;
        }

        int getNextOffset() {
            return this.offset + 1;
        }

        @Override
        public double get() {
            return SequentialAccessSparseVector.this.values.getValues()[this.offset];
        }

        @Override
        public int index() {
            return SequentialAccessSparseVector.this.values.getIndices()[this.offset];
        }

        @Override
        public void set(double value) {
            SequentialAccessSparseVector.this.lengthSquared = -1.0;
            ((SequentialAccessSparseVector)SequentialAccessSparseVector.this).values.getValues()[this.offset] = value;
        }
    }

    private final class AllIterator
    extends AbstractIterator<Vector.Element> {
        private final AllElement element;

        private AllIterator() {
            this.element = new AllElement();
        }

        protected Vector.Element computeNext() {
            int numMappings = SequentialAccessSparseVector.this.values.getNumMappings();
            if (numMappings <= 0 || this.element.getNextIndex() > SequentialAccessSparseVector.this.values.getIndices()[numMappings - 1]) {
                return (Vector.Element)this.endOfData();
            }
            this.element.advanceIndex();
            return this.element;
        }
    }

    private final class NonDefaultIterator
    extends AbstractIterator<Vector.Element> {
        private final NonDefaultElement element;

        private NonDefaultIterator() {
            this.element = new NonDefaultElement();
        }

        protected Vector.Element computeNext() {
            int numMappings = SequentialAccessSparseVector.this.values.getNumMappings();
            if (numMappings <= 0 || this.element.getNextOffset() >= numMappings) {
                return (Vector.Element)this.endOfData();
            }
            this.element.advanceOffset();
            return this.element;
        }
    }
}

