/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Arrays;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.Vector;

public class DenseMatrix
extends AbstractMatrix {
    private double[][] values;

    public DenseMatrix(double[][] values) {
        super(values.length, values[0].length);
        this.values = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = (double[])values[i].clone();
        }
    }

    public DenseMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new double[rows][columns];
    }

    @Override
    public Matrix clone() {
        DenseMatrix clone = (DenseMatrix)super.clone();
        clone.values = new double[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            clone.values[i] = (double[])this.values[i].clone();
        }
        return clone;
    }

    @Override
    public double getQuick(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public Matrix like() {
        return this.like(this.rowSize(), this.columnSize());
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.values[row][column] = value;
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        int rowOffset = offset[0];
        int rowsRequested = size[0];
        int columnOffset = offset[1];
        int columnsRequested = size[1];
        return this.viewPart(rowOffset, rowsRequested, columnOffset, columnsRequested);
    }

    @Override
    public Matrix viewPart(int rowOffset, int rowsRequested, int columnOffset, int columnsRequested) {
        if (rowOffset < 0) {
            throw new IndexException(rowOffset, this.rowSize());
        }
        if (rowOffset + rowsRequested > this.rowSize()) {
            throw new IndexException(rowOffset + rowsRequested, this.rowSize());
        }
        if (columnOffset < 0) {
            throw new IndexException(columnOffset, this.columnSize());
        }
        if (columnOffset + columnsRequested > this.columnSize()) {
            throw new IndexException(columnOffset + columnsRequested, this.columnSize());
        }
        return new MatrixView(this, new int[]{rowOffset, columnOffset}, new int[]{rowsRequested, columnsRequested});
    }

    @Override
    public Matrix assign(double value) {
        for (int row = 0; row < this.rowSize(); ++row) {
            Arrays.fill(this.values[row], value);
        }
        return this;
    }

    public Matrix assign(DenseMatrix matrix) {
        if (matrix.values[0].length != this.values[0].length || matrix.values.length != this.values.length) {
            this.values = new double[matrix.values.length][matrix.values[0].length];
        }
        for (int i = 0; i < this.values.length; ++i) {
            System.arraycopy(matrix.values[i], 0, this.values[i], 0, this.values[0].length);
        }
        return this;
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (this.rowSize() != other.size()) {
            throw new CardinalityException(this.rowSize(), other.size());
        }
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        for (int row = 0; row < this.rowSize(); ++row) {
            this.values[row][column] = other.getQuick(row);
        }
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        if (this.columnSize() != other.size()) {
            throw new CardinalityException(this.columnSize(), other.size());
        }
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        for (int col = 0; col < this.columnSize(); ++col) {
            this.values[row][col] = other.getQuick(col);
        }
        return this;
    }

    @Override
    public Vector viewRow(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        return new DenseVector(this.values[row], true);
    }
}

