/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.Arrays;
import org.apache.mahout.math.function.FloatFloatProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.AbstractFloatFloatMap;
import org.apache.mahout.math.map.HashFunctions;

public class OpenFloatFloatHashMap
extends AbstractFloatFloatMap {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final float NO_KEY_VALUE = Float.NaN;
    protected float[] table;
    protected float[] values;
    protected byte[] state;
    protected int freeEntries;

    public OpenFloatFloatHashMap() {
        this(277);
    }

    public OpenFloatFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenFloatFloatHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public void clear() {
        Arrays.fill(this.state, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenFloatFloatHashMap copy = (OpenFloatFloatHashMap)super.clone();
        copy.table = (float[])copy.table.clone();
        copy.values = (float[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    public boolean containsKey(float key) {
        return this.indexOfKey(key) >= 0;
    }

    public boolean containsValue(float value) {
        return this.indexOfValue(value) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    public boolean forEachKey(FloatProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(FloatFloatProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    public float get(float key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return 0.0f;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(float key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] == 1 && this.table[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 2) {
            int j = i;
            while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (this.state[i] == 0) {
                i = j;
            }
        }
        if (this.state[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(float key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(float value) {
        float[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void keys(FloatArrayList list) {
        list.setSize(this.distinct);
        float[] elements = list.elements();
        int j = 0;
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.table[i];
        }
    }

    public void pairsMatching(FloatFloatProcedure condition, FloatArrayList keyList, FloatArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    public boolean put(float key, float value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    public float adjustOrPutValue(float key, float newValue, float incrValue) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            int n = i = -i - 1;
            this.values[n] = this.values[n] + incrValue;
            return this.values[i];
        }
        this.put(key, newValue);
        return newValue;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        float[] oldTable = this.table;
        float[] oldValues = this.values;
        byte[] oldState = this.state;
        this.table = new float[newCapacity];
        this.values = new float[newCapacity];
        this.state = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            float element = oldTable[i];
            int index = this.indexOfInsertion(element);
            this.table[index] = element;
            this.values[index] = oldValues[i];
            this.state[index] = 1;
        }
    }

    public boolean removeKey(float key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new float[capacity];
        this.values = new float[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    public void values(FloatArrayList list) {
        list.setSize(this.distinct);
        float[] elements = list.elements();
        int j = 0;
        int i = this.state.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.values[i];
        }
    }

    protected void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }
}

