/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.xmlparser.builders;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermsFilter;
import org.apache.lucene.xmlparser.DOMUtils;
import org.apache.lucene.xmlparser.FilterBuilder;
import org.apache.lucene.xmlparser.ParserException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TermsFilterBuilder
implements FilterBuilder {
    Analyzer analyzer;

    public TermsFilterBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Filter getFilter(Element e) throws ParserException {
        TermsFilter tf = new TermsFilter();
        NodeList nl = e.getElementsByTagName("Field");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element fieldElem = (Element)nl.item(i);
            String fieldName = DOMUtils.getAttributeWithInheritance(fieldElem, "fieldName");
            if (fieldName == null) {
                throw new ParserException("TermsFilter missing \"fieldName\" element");
            }
            String text = DOMUtils.getText(fieldElem).trim();
            TokenStream ts = this.analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
            try {
                Token token = ts.next();
                Term term = null;
                while (token != null) {
                    term = term == null ? new Term(fieldName, token.termText()) : term.createTerm(token.termText());
                    tf.addTerm(term);
                    token = ts.next();
                }
                continue;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error constructing terms from index:" + ioe);
            }
        }
        return tf;
    }
}

