/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.xmlparser.builders;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similar.MoreLikeThisQuery;
import org.apache.lucene.xmlparser.DOMUtils;
import org.apache.lucene.xmlparser.ParserException;
import org.apache.lucene.xmlparser.QueryBuilder;
import org.w3c.dom.Element;

public class LikeThisQueryBuilder
implements QueryBuilder {
    private Analyzer analyzer;
    String[] defaultFieldNames;
    int defaultMaxQueryTerms = 20;
    int defaultMinTermFrequency = 1;
    float defaultPercentTermsToMatch = 30.0f;

    public LikeThisQueryBuilder(Analyzer analyzer, String[] defaultFieldNames) {
        this.analyzer = analyzer;
        this.defaultFieldNames = defaultFieldNames;
    }

    public Query getQuery(Element e) throws ParserException {
        String fieldsList = e.getAttribute("fieldNames");
        String[] fields = this.defaultFieldNames;
        if (fieldsList != null && fieldsList.trim().length() > 0) {
            fields = fieldsList.trim().split(",");
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = fields[i].trim();
            }
        }
        MoreLikeThisQuery mlt = new MoreLikeThisQuery(DOMUtils.getText(e), fields, this.analyzer);
        mlt.setMaxQueryTerms(DOMUtils.getAttribute(e, "maxQueryTerms", this.defaultMaxQueryTerms));
        mlt.setMinTermFrequency(DOMUtils.getAttribute(e, "minTermFrequency", this.defaultMinTermFrequency));
        mlt.setPercentTermsToMatch(DOMUtils.getAttribute(e, "percentTermsToMatch", this.defaultPercentTermsToMatch) / 100.0f);
        mlt.setBoost(DOMUtils.getAttribute(e, "boost", 1.0f));
        return mlt;
    }
}

