/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.tests.search.CheckHits;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;
import org.junit.Assert;

public class QueryUtils {
    public static void check(Query q) {
        QueryUtils.checkHashEquals(q);
    }

    public static void checkHashEquals(Query q) {
        QueryUtils.checkEqual(q, q);
        Query whacky = new Query(){

            public String toString(String field) {
                return "My Whacky Query";
            }

            public void visit(QueryVisitor visitor) {
            }

            public boolean equals(Object o) {
                return o == this;
            }

            public int hashCode() {
                return System.identityHashCode((Object)this);
            }
        };
        QueryUtils.checkUnequal(q, whacky);
        Assert.assertFalse((boolean)q.equals(null));
    }

    public static void checkEqual(Query q1, Query q2) {
        Assert.assertEquals((Object)q1, (Object)q2);
        Assert.assertEquals((long)q1.hashCode(), (long)q2.hashCode());
    }

    public static void checkUnequal(Query q1, Query q2) {
        Assert.assertFalse((String)(q1 + " equal to " + q2), (boolean)q1.equals((Object)q2));
        Assert.assertFalse((String)(q2 + " equal to " + q1), (boolean)q2.equals((Object)q1));
    }

    public static void checkExplanations(Query q, IndexSearcher s) throws IOException {
        CheckHits.checkExplanations(q, null, s, true);
    }

    public static void check(Random random, Query q1, IndexSearcher s) {
        QueryUtils.check(random, q1, s, true);
    }

    public static void check(Random random, Query q1, IndexSearcher s, boolean wrap) {
        try {
            QueryUtils.check(q1);
            if (s != null) {
                QueryUtils.checkFirstSkipTo(q1, s);
                QueryUtils.checkSkipTo(q1, s);
                QueryUtils.checkBulkScorerSkipTo(random, q1, s);
                QueryUtils.checkCount(q1, s);
                if (wrap) {
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, -1), false);
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, 0), false);
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, 1), false);
                }
                QueryUtils.checkExplanations(q1, s);
                CheckHits.checkMatches(q1, s);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSearcher wrapUnderlyingReader(Random random, IndexSearcher s, int edge) throws IOException {
        IndexReader r = s.getIndexReader();
        IndexReader[] readers = new IndexReader[]{edge < 0 ? r : new MultiReader(new IndexReader[0]), new MultiReader(new IndexReader[0]), new MultiReader(new IndexReader[]{edge < 0 ? QueryUtils.emptyReader(4) : new MultiReader(new IndexReader[0]), new MultiReader(new IndexReader[0]), 0 == edge ? r : new MultiReader(new IndexReader[0])}), 0 < edge ? new MultiReader(new IndexReader[0]) : QueryUtils.emptyReader(7), new MultiReader(new IndexReader[0]), new MultiReader(new IndexReader[]{0 < edge ? new MultiReader(new IndexReader[0]) : QueryUtils.emptyReader(5), new MultiReader(new IndexReader[0]), 0 < edge ? r : new MultiReader(new IndexReader[0])})};
        IndexSearcher out = LuceneTestCase.newSearcher((IndexReader)new MultiReader(readers));
        out.setSimilarity(s.getSimilarity());
        return out;
    }

    private static IndexReader emptyReader(final int maxDoc) {
        return new LeafReader(){
            final Bits liveDocs;
            {
                this.liveDocs = new Bits.MatchNoBits(maxDoc);
            }

            public Terms terms(String field) throws IOException {
                return null;
            }

            public NumericDocValues getNumericDocValues(String field) throws IOException {
                return null;
            }

            public BinaryDocValues getBinaryDocValues(String field) throws IOException {
                return null;
            }

            public SortedDocValues getSortedDocValues(String field) throws IOException {
                return null;
            }

            public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
                return null;
            }

            public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
                return null;
            }

            public NumericDocValues getNormValues(String field) throws IOException {
                return null;
            }

            public FloatVectorValues getFloatVectorValues(String field) throws IOException {
                return null;
            }

            public ByteVectorValues getByteVectorValues(String field) throws IOException {
                return null;
            }

            public void searchNearestVectors(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) {
            }

            public void searchNearestVectors(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) {
            }

            public FieldInfos getFieldInfos() {
                return FieldInfos.EMPTY;
            }

            public Bits getLiveDocs() {
                return this.liveDocs;
            }

            public PointValues getPointValues(String fieldName) {
                return null;
            }

            public void checkIntegrity() throws IOException {
            }

            public Fields getTermVectors(int docID) throws IOException {
                return null;
            }

            public TermVectors termVectors() {
                return TermVectors.EMPTY;
            }

            public int numDocs() {
                return 0;
            }

            public int maxDoc() {
                return maxDoc;
            }

            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            }

            public StoredFields storedFields() {
                return new StoredFields(){

                    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                    }
                };
            }

            protected void doClose() throws IOException {
            }

            public LeafMetaData getMetaData() {
                return new LeafMetaData(Version.LATEST.major, Version.LATEST, null);
            }

            public IndexReader.CacheHelper getCoreCacheHelper() {
                return null;
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    public static void checkSkipTo(final Query q, final IndexSearcher s) throws IOException {
        final List readerContextArray = s.getTopReaderContext().leaves();
        boolean skip_op = false;
        boolean next_op = true;
        int[][] orders = new int[][]{{1}, {0}, {0, 1}, {1, 0}, {0, 0, 1, 1}, {1, 1, 0, 0}, {0, 0, 0, 1, 1}};
        for (int k = 0; k < orders.length; ++k) {
            final int[] order = orders[k];
            final int[] opidx = new int[]{0};
            final int[] lastDoc = new int[]{-1};
            float maxDiff = 1.0E-5f;
            final LeafReader[] lastReader = new LeafReader[]{null};
            s.search(q, (Collector)new SimpleCollector(){
                private Scorable sc;
                private Scorer scorer;
                private DocIdSetIterator iterator;
                private int leafPtr;

                public void setScorer(Scorable scorer) {
                    this.sc = scorer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void collect(int doc) throws IOException {
                    block8: {
                        float score = this.sc.score();
                        lastDoc[0] = doc;
                        try {
                            StringBuilder sbord;
                            if (this.scorer == null) {
                                Query rewritten = s.rewrite(q);
                                Weight w = s.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                                LeafReaderContext context = (LeafReaderContext)readerContextArray.get(this.leafPtr);
                                this.scorer = w.scorer(context);
                                this.iterator = this.scorer.iterator();
                            }
                            int n = opidx[0];
                            opidx[0] = n + 1;
                            int op = order[n % order.length];
                            boolean more = op == 0 ? this.iterator.advance(this.scorer.docID() + 1) != Integer.MAX_VALUE : this.iterator.nextDoc() != Integer.MAX_VALUE;
                            int scorerDoc = this.scorer.docID();
                            float scorerScore = this.scorer.score();
                            float scorerScore2 = this.scorer.score();
                            float scoreDiff = Math.abs(score - scorerScore);
                            float scorerDiff = Math.abs(scorerScore2 - scorerScore);
                            boolean success = false;
                            try {
                                Assert.assertTrue((boolean)more);
                                Assert.assertEquals((String)("scorerDoc=" + scorerDoc + ",doc=" + doc), (long)scorerDoc, (long)doc);
                                Assert.assertTrue((String)("score=" + score + ", scorerScore=" + scorerScore), (scoreDiff <= 1.0E-5f ? 1 : 0) != 0);
                                Assert.assertTrue((String)("scorerScorer=" + scorerScore + ", scorerScore2=" + scorerScore2), (scorerDiff <= 1.0E-5f ? 1 : 0) != 0);
                                success = true;
                                if (success || !LuceneTestCase.VERBOSE) break block8;
                                sbord = new StringBuilder();
                            }
                            catch (Throwable throwable) {
                                if (!success && LuceneTestCase.VERBOSE) {
                                    StringBuilder sbord2 = new StringBuilder();
                                    for (int i = 0; i < order.length; ++i) {
                                        sbord2.append(order[i] == 0 ? " skip()" : " next()");
                                    }
                                    System.out.println("ERROR matching docs:\n\t" + (doc != scorerDoc ? "--> " : "") + "doc=" + doc + ", scorerDoc=" + scorerDoc + "\n\t" + (!more ? "--> " : "") + "tscorer.more=" + more + "\n\t" + (scoreDiff > 1.0E-5f ? "--> " : "") + "scorerScore=" + scorerScore + " scoreDiff=" + scoreDiff + " maxDiff=1.0E-5\n\t" + (scorerDiff > 1.0E-5f ? "--> " : "") + "scorerScore2=" + scorerScore2 + " scorerDiff=" + scorerDiff + "\n\thitCollector.doc=" + doc + " score=" + score + "\n\t Scorer=" + this.scorer + "\n\t Query=" + q + "  " + q.getClass().getName() + "\n\t Searcher=" + s + "\n\t Order=" + sbord2 + "\n\t Op=" + (op == 0 ? " skip()" : " next()"));
                                }
                                throw throwable;
                            }
                            for (int i = 0; i < order.length; ++i) {
                                sbord.append(order[i] == 0 ? " skip()" : " next()");
                            }
                            System.out.println("ERROR matching docs:\n\t" + (doc != scorerDoc ? "--> " : "") + "doc=" + doc + ", scorerDoc=" + scorerDoc + "\n\t" + (!more ? "--> " : "") + "tscorer.more=" + more + "\n\t" + (scoreDiff > 1.0E-5f ? "--> " : "") + "scorerScore=" + scorerScore + " scoreDiff=" + scoreDiff + " maxDiff=1.0E-5\n\t" + (scorerDiff > 1.0E-5f ? "--> " : "") + "scorerScore2=" + scorerScore2 + " scorerDiff=" + scorerDiff + "\n\thitCollector.doc=" + doc + " score=" + score + "\n\t Scorer=" + this.scorer + "\n\t Query=" + q + "  " + q.getClass().getName() + "\n\t Searcher=" + s + "\n\t Order=" + sbord + "\n\t Op=" + (op == 0 ? " skip()" : " next()"));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public ScoreMode scoreMode() {
                    return ScoreMode.COMPLETE;
                }

                protected void doSetNextReader(LeafReaderContext context) throws IOException {
                    if (lastReader[0] != null) {
                        LeafReader previousReader = lastReader[0];
                        IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader, false);
                        indexSearcher.setSimilarity(s.getSimilarity());
                        Query rewritten = indexSearcher.rewrite(q);
                        Weight w = indexSearcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                        LeafReaderContext ctx = (LeafReaderContext)indexSearcher.getTopReaderContext();
                        Scorer scorer = w.scorer(ctx);
                        if (scorer != null) {
                            DocIdSetIterator iterator = scorer.iterator();
                            boolean more = false;
                            Bits liveDocs = context.reader().getLiveDocs();
                            int d = iterator.advance(lastDoc[0] + 1);
                            while (d != Integer.MAX_VALUE) {
                                if (liveDocs == null || liveDocs.get(d)) {
                                    more = true;
                                    break;
                                }
                                d = iterator.nextDoc();
                            }
                            Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but advance(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
                        }
                        ++this.leafPtr;
                    }
                    lastReader[0] = context.reader();
                    assert (((LeafReaderContext)readerContextArray.get(this.leafPtr)).reader() == context.reader());
                    this.scorer = null;
                    lastDoc[0] = -1;
                }
            });
            if (lastReader[0] == null) continue;
            LeafReader previousReader = lastReader[0];
            IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader, false);
            indexSearcher.setSimilarity(s.getSimilarity());
            Query rewritten = indexSearcher.rewrite(q);
            Weight w = indexSearcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
            LeafReaderContext ctx = previousReader.getContext();
            Scorer scorer = w.scorer(ctx);
            if (scorer == null) continue;
            DocIdSetIterator iterator = scorer.iterator();
            boolean more = false;
            Bits liveDocs = lastReader[0].getLiveDocs();
            int d = iterator.advance(lastDoc[0] + 1);
            while (d != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(d)) {
                    more = true;
                    break;
                }
                d = iterator.nextDoc();
            }
            Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but advance(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
        }
    }

    public static void checkFirstSkipTo(Query q, final IndexSearcher s) throws IOException {
        float maxDiff = 0.001f;
        final int[] lastDoc = new int[]{-1};
        final LeafReader[] lastReader = new LeafReader[]{null};
        final List context = s.getTopReaderContext().leaves();
        final Query rewritten = s.rewrite(q);
        s.search(q, (Collector)new SimpleCollector(){
            private Scorable scorer;
            private int leafPtr;

            public void setScorer(Scorable scorer) {
                this.scorer = scorer;
            }

            public void collect(int doc) throws IOException {
                float score = this.scorer.score();
                try {
                    long startNS = System.nanoTime();
                    for (int i = lastDoc[0] + 1; i <= doc; ++i) {
                        Weight w = s.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                        Scorer scorer = w.scorer((LeafReaderContext)context.get(this.leafPtr));
                        Assert.assertTrue((String)("query collected " + doc + " but advance(" + i + ") says no more docs!"), (scorer.iterator().advance(i) != Integer.MAX_VALUE ? 1 : 0) != 0);
                        Assert.assertEquals((String)("query collected " + doc + " but advance(" + i + ") got to " + scorer.docID()), (long)doc, (long)scorer.docID());
                        float advanceScore = scorer.score();
                        Assert.assertEquals((String)("unstable advance(" + i + ") score!"), (float)advanceScore, (float)scorer.score(), (float)0.001f);
                        Assert.assertEquals((String)("query assigned doc " + doc + " a score of <" + score + "> but advance(" + i + ") has <" + advanceScore + ">!"), (float)score, (float)advanceScore, (float)0.001f);
                        if (i >= doc || System.nanoTime() - startNS <= 5000000L) continue;
                        i = doc - 1;
                    }
                    lastDoc[0] = doc;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public ScoreMode scoreMode() {
                return ScoreMode.COMPLETE;
            }

            protected void doSetNextReader(LeafReaderContext context2) throws IOException {
                if (lastReader[0] != null) {
                    LeafReader previousReader = lastReader[0];
                    IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader, false);
                    indexSearcher.setSimilarity(s.getSimilarity());
                    Weight w = indexSearcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                    Scorer scorer = w.scorer((LeafReaderContext)indexSearcher.getTopReaderContext());
                    if (scorer != null) {
                        DocIdSetIterator iterator = scorer.iterator();
                        boolean more = false;
                        Bits liveDocs = context2.reader().getLiveDocs();
                        int d = iterator.advance(lastDoc[0] + 1);
                        while (d != Integer.MAX_VALUE) {
                            if (liveDocs == null || liveDocs.get(d)) {
                                more = true;
                                break;
                            }
                            d = iterator.nextDoc();
                        }
                        Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but advance(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
                    }
                    ++this.leafPtr;
                }
                lastReader[0] = context2.reader();
                lastDoc[0] = -1;
            }
        });
        if (lastReader[0] != null) {
            LeafReader previousReader = lastReader[0];
            IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader, false);
            indexSearcher.setSimilarity(s.getSimilarity());
            Weight w = indexSearcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
            Scorer scorer = w.scorer((LeafReaderContext)indexSearcher.getTopReaderContext());
            if (scorer != null) {
                DocIdSetIterator iterator = scorer.iterator();
                boolean more = false;
                Bits liveDocs = lastReader[0].getLiveDocs();
                int d = iterator.advance(lastDoc[0] + 1);
                while (d != Integer.MAX_VALUE) {
                    if (liveDocs == null || liveDocs.get(d)) {
                        more = true;
                        break;
                    }
                    d = iterator.nextDoc();
                }
                Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but advance(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
            }
        }
    }

    public static void checkBulkScorerSkipTo(Random r, Query query, IndexSearcher searcher) throws IOException {
        query = searcher.rewrite(query);
        Weight weight = searcher.createWeight(query, ScoreMode.COMPLETE, 1.0f);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            ScorerSupplier scorerSupplier = weight.scorerSupplier(context);
            final Scorer scorer = scorerSupplier == null ? null : scorerSupplier.get(0L);
            BulkScorer bulkScorer = weight.bulkScorer(context);
            if (scorer == null && bulkScorer == null) continue;
            if (bulkScorer == null) {
                assert (scorer.iterator().nextDoc() == Integer.MAX_VALUE);
                continue;
            }
            final DocIdSetIterator iterator = scorer.iterator();
            int upTo = 0;
            do {
                final int min = upTo + r.nextInt(5);
                final int max = min + 1 + r.nextInt(r.nextBoolean() ? 10 : 5000);
                if (scorer.docID() < min) {
                    iterator.advance(min);
                }
                int next = bulkScorer.score(new LeafCollector(){
                    Scorable scorer2;

                    public void setScorer(Scorable scorer2) throws IOException {
                        this.scorer2 = scorer2;
                    }

                    public void collect(int doc) throws IOException {
                        assert (doc >= min);
                        assert (doc < max);
                        Assert.assertEquals((long)scorer.docID(), (long)doc);
                        Assert.assertEquals((float)scorer.score(), (float)this.scorer2.score(), (float)0.01f);
                        iterator.nextDoc();
                    }
                }, null, min, max);
                assert (max <= next);
                assert (next <= scorer.docID());
                upTo = max;
            } while (scorer.docID() != Integer.MAX_VALUE);
            bulkScorer.score(new LeafCollector(){

                public void setScorer(Scorable scorer) throws IOException {
                }

                public void collect(int doc) throws IOException {
                    assert (false);
                }
            }, null, upTo, Integer.MAX_VALUE);
        }
    }

    public static void checkCount(Query query, IndexSearcher searcher) throws IOException {
        query = searcher.rewrite(query);
        Weight weight = searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            BulkScorer scorer = weight.bulkScorer(context);
            if (scorer == null) continue;
            final int[] expectedCount = new int[]{0};
            final boolean[] docIdStream = new boolean[]{false};
            scorer.score(new LeafCollector(){

                public void collect(DocIdStream stream) throws IOException {
                    docIdStream[0] = true;
                    super.collect(stream);
                }

                public void collect(int doc) throws IOException {
                    expectedCount[0] = expectedCount[0] + 1;
                }

                public void setScorer(Scorable scorer) throws IOException {
                }
            }, context.reader().getLiveDocs(), 0, Integer.MAX_VALUE);
            if (!docIdStream[0]) continue;
            scorer = weight.bulkScorer(context);
            if (scorer == null) {
                Assert.assertEquals((long)0L, (long)expectedCount[0]);
                continue;
            }
            final int[] actualCount = new int[]{0};
            scorer.score(new LeafCollector(){

                public void collect(DocIdStream stream) throws IOException {
                    actualCount[0] = actualCount[0] + stream.count();
                }

                public void collect(int doc) throws IOException {
                    actualCount[0] = actualCount[0] + 1;
                }

                public void setScorer(Scorable scorer) throws IOException {
                }
            }, context.reader().getLiveDocs(), 0, Integer.MAX_VALUE);
            Assert.assertEquals((long)expectedCount[0], (long)actualCount[0]);
        }
    }
}

