/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.tests.IndexPackageAccess;
import org.apache.lucene.internal.tests.TestSecrets;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.tests.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public abstract class BaseFieldInfoFormatTestCase
extends BaseIndexFileFormatTestCase {
    private static final IndexPackageAccess INDEX_PACKAGE_ACCESS = TestSecrets.getIndexPackageAccess();

    public void testOneField() throws Exception {
        BaseDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfo fi = this.createFieldInfo();
        this.addAttributes(fi);
        FieldInfos infos = INDEX_PACKAGE_ACCESS.newFieldInfosBuilder(null).add(fi).finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        FieldInfos infos2 = codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT);
        BaseFieldInfoFormatTestCase.assertEquals((long)1L, (long)infos2.size());
        BaseFieldInfoFormatTestCase.assertNotNull((Object)infos2.fieldInfo("field"));
        BaseFieldInfoFormatTestCase.assertTrue((infos2.fieldInfo("field").getIndexOptions() != IndexOptions.NONE ? 1 : 0) != 0);
        BaseFieldInfoFormatTestCase.assertFalse((infos2.fieldInfo("field").getDocValuesType() != DocValuesType.NONE ? 1 : 0) != 0);
        BaseFieldInfoFormatTestCase.assertFalse((boolean)infos2.fieldInfo("field").omitsNorms());
        BaseFieldInfoFormatTestCase.assertFalse((boolean)infos2.fieldInfo("field").hasPayloads());
        BaseFieldInfoFormatTestCase.assertFalse((boolean)infos2.fieldInfo("field").hasVectors());
        BaseFieldInfoFormatTestCase.assertEquals((long)0L, (long)infos2.fieldInfo("field").getPointDimensionCount());
        BaseFieldInfoFormatTestCase.assertEquals((long)0L, (long)infos2.fieldInfo("field").getVectorDimension());
        BaseFieldInfoFormatTestCase.assertFalse((boolean)infos2.fieldInfo("field").isSoftDeletesField());
        dir.close();
    }

    public void testImmutableAttributes() throws Exception {
        BaseDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfo fi = this.createFieldInfo();
        this.addAttributes(fi);
        fi.putAttribute("foo", "bar");
        fi.putAttribute("bar", "baz");
        FieldInfos infos = INDEX_PACKAGE_ACCESS.newFieldInfosBuilder(null).add(fi).finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        FieldInfos infos2 = codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT);
        BaseFieldInfoFormatTestCase.assertEquals((long)1L, (long)infos2.size());
        BaseFieldInfoFormatTestCase.assertNotNull((Object)infos2.fieldInfo("field"));
        Map attributes = infos2.fieldInfo("field").attributes();
        BaseFieldInfoFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> attributes.put("bogus", "bogus"));
        dir.close();
    }

    public void testExceptionOnCreateOutput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                if (this.doFail && LuceneTestCase.callStackContainsAnyOf("createOutput")) {
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfo fi = this.createFieldInfo();
        this.addAttributes(fi);
        FieldInfos infos = INDEX_PACKAGE_ACCESS.newFieldInfosBuilder(null).add(fi).finish();
        fail.setDoFail();
        BaseFieldInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnCloseOutput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                if (this.doFail && LuceneTestCase.callStackContainsAnyOf("close")) {
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfo fi = this.createFieldInfo();
        this.addAttributes(fi);
        FieldInfos infos = INDEX_PACKAGE_ACCESS.newFieldInfosBuilder(null).add(fi).finish();
        fail.setDoFail();
        BaseFieldInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnOpenInput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                if (this.doFail && LuceneTestCase.callStackContainsAnyOf("openInput")) {
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfo fi = this.createFieldInfo();
        this.addAttributes(fi);
        FieldInfos infos = INDEX_PACKAGE_ACCESS.newFieldInfosBuilder(null).add(fi).finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        fail.setDoFail();
        BaseFieldInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnCloseInput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                if (this.doFail && LuceneTestCase.callStackContainsAnyOf("close")) {
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfo fi = this.createFieldInfo();
        this.addAttributes(fi);
        FieldInfos infos = INDEX_PACKAGE_ACCESS.newFieldInfosBuilder(null).add(fi).finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        fail.setDoFail();
        BaseFieldInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testRandom() throws Exception {
        BaseDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        int numFields = BaseFieldInfoFormatTestCase.atLeast(2000);
        HashSet<String> fieldNames = new HashSet<String>();
        for (int i = 0; i < numFields; ++i) {
            fieldNames.add(TestUtil.randomUnicodeString(BaseFieldInfoFormatTestCase.random()));
        }
        String softDeletesField = BaseFieldInfoFormatTestCase.random().nextBoolean() ? TestUtil.randomUnicodeString(BaseFieldInfoFormatTestCase.random()) : null;
        IndexPackageAccess.FieldInfosBuilder builder = INDEX_PACKAGE_ACCESS.newFieldInfosBuilder(softDeletesField);
        for (String field : fieldNames) {
            IndexableFieldType fieldType = this.randomFieldType(BaseFieldInfoFormatTestCase.random(), field);
            boolean storeTermVectors = false;
            boolean storePayloads = false;
            boolean omitNorms = false;
            if (fieldType.indexOptions() != IndexOptions.NONE) {
                storeTermVectors = fieldType.storeTermVectors();
                omitNorms = fieldType.omitNorms();
                if (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
                    storePayloads = BaseFieldInfoFormatTestCase.random().nextBoolean();
                }
            }
            FieldInfo fi = new FieldInfo(field, -1, storeTermVectors, omitNorms, storePayloads, fieldType.indexOptions(), fieldType.docValuesType(), -1L, new HashMap(), fieldType.pointDimensionCount(), fieldType.pointIndexDimensionCount(), fieldType.pointNumBytes(), fieldType.vectorDimension(), fieldType.vectorEncoding(), fieldType.vectorSimilarityFunction(), field.equals(softDeletesField));
            this.addAttributes(fi);
            builder.add(fi);
        }
        FieldInfos infos = builder.finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        FieldInfos infos2 = codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT);
        this.assertEquals(infos, infos2);
        dir.close();
    }

    private int getVectorsMaxDimensions(String fieldName) {
        return Codec.getDefault().knnVectorsFormat().getMaxDimensions(fieldName);
    }

    private IndexableFieldType randomFieldType(Random r, String fieldName) {
        IndexOptions[] values;
        FieldType type = new FieldType();
        if (r.nextBoolean()) {
            values = IndexOptions.values();
            type.setIndexOptions(values[r.nextInt(values.length)]);
            type.setOmitNorms(r.nextBoolean());
            if (r.nextBoolean()) {
                type.setStoreTermVectors(true);
                if (type.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
                    type.setStoreTermVectorPositions(r.nextBoolean());
                    type.setStoreTermVectorOffsets(r.nextBoolean());
                    if (type.storeTermVectorPositions()) {
                        type.setStoreTermVectorPayloads(r.nextBoolean());
                    }
                }
            }
        }
        if (r.nextBoolean()) {
            values = DocValuesType.values();
            type.setDocValuesType((DocValuesType)values[r.nextInt(values.length)]);
        }
        if (r.nextBoolean()) {
            int dimension = 1 + r.nextInt(16);
            int indexDimension = 1 + r.nextInt(Math.min(dimension, 8));
            int dimensionNumBytes = 1 + r.nextInt(16);
            type.setDimensions(dimension, indexDimension, dimensionNumBytes);
        }
        if (r.nextBoolean()) {
            int dimension = 1 + r.nextInt(this.getVectorsMaxDimensions(fieldName));
            VectorSimilarityFunction similarityFunction = (VectorSimilarityFunction)RandomPicks.randomFrom((Random)r, (Object[])VectorSimilarityFunction.values());
            VectorEncoding encoding = (VectorEncoding)RandomPicks.randomFrom((Random)r, (Object[])VectorEncoding.values());
            type.setVectorAttributes(dimension, encoding, similarityFunction);
        }
        return type;
    }

    protected void addAttributes(FieldInfo fi) {
    }

    protected void assertEquals(FieldInfos expected, FieldInfos actual) {
        BaseFieldInfoFormatTestCase.assertEquals((long)expected.size(), (long)actual.size());
        for (FieldInfo expectedField : expected) {
            FieldInfo actualField = actual.fieldInfo(expectedField.number);
            BaseFieldInfoFormatTestCase.assertNotNull((Object)actualField);
            this.assertEquals(expectedField, actualField);
        }
    }

    protected void assertEquals(FieldInfo expected, FieldInfo actual) {
        BaseFieldInfoFormatTestCase.assertEquals((long)expected.number, (long)actual.number);
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.name, (Object)actual.name);
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.getDocValuesType(), (Object)actual.getDocValuesType());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.getIndexOptions(), (Object)actual.getIndexOptions());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.hasNorms(), (Object)actual.hasNorms());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.hasPayloads(), (Object)actual.hasPayloads());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.hasVectors(), (Object)actual.hasVectors());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.omitsNorms(), (Object)actual.omitsNorms());
        BaseFieldInfoFormatTestCase.assertEquals((long)expected.getDocValuesGen(), (long)actual.getDocValuesGen());
    }

    protected static SegmentInfo newSegmentInfo(Directory dir, String name) {
        Version minVersion = BaseFieldInfoFormatTestCase.random().nextBoolean() ? null : Version.LATEST;
        return new SegmentInfo(dir, Version.LATEST, minVersion, name, 10000, false, Codec.getDefault(), Collections.emptyMap(), StringHelper.randomId(), Collections.emptyMap(), null);
    }

    @Override
    protected void addRandomFields(Document doc) {
        doc.add((IndexableField)new StoredField("foobar", TestUtil.randomSimpleString(BaseFieldInfoFormatTestCase.random())));
    }

    private FieldInfo createFieldInfo() {
        return new FieldInfo("field", -1, false, false, false, TextField.TYPE_STORED.indexOptions(), DocValuesType.NONE, -1L, new HashMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false);
    }
}

