/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;

class MergeReaderWrapper
extends LeafReader {
    final CodecReader in;
    final FieldsProducer fields;
    final NormsProducer norms;
    final DocValuesProducer docValues;
    final StoredFieldsReader store;
    final TermVectorsReader vectors;

    MergeReaderWrapper(CodecReader in) throws IOException {
        this.in = in;
        FieldsProducer fields = in.getPostingsReader();
        if (fields != null) {
            fields = fields.getMergeInstance();
        }
        this.fields = fields;
        NormsProducer norms = in.getNormsReader();
        if (norms != null) {
            norms = norms.getMergeInstance();
        }
        this.norms = norms;
        DocValuesProducer docValues = in.getDocValuesReader();
        if (docValues != null) {
            docValues = docValues.getMergeInstance();
        }
        this.docValues = docValues;
        StoredFieldsReader store = in.getFieldsReader();
        if (store != null) {
            store = store.getMergeInstance();
        }
        this.store = store;
        TermVectorsReader vectors = in.getTermVectorsReader();
        if (vectors != null) {
            vectors = vectors.getMergeInstance();
        }
        this.vectors = vectors;
    }

    public Terms terms(String field) throws IOException {
        this.ensureOpen();
        if (this.fields == null) {
            return null;
        }
        return this.fields.terms(field);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.NUMERIC) {
            return null;
        }
        return this.docValues.getNumeric(fi);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.BINARY) {
            return null;
        }
        return this.docValues.getBinary(fi);
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED) {
            return null;
        }
        return this.docValues.getSorted(fi);
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED_NUMERIC) {
            return null;
        }
        return this.docValues.getSortedNumeric(fi);
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED_SET) {
            return null;
        }
        return this.docValues.getSortedSet(fi);
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.norms.getNorms(fi);
    }

    public FieldInfos getFieldInfos() {
        return this.in.getFieldInfos();
    }

    public Bits getLiveDocs() {
        return this.in.getLiveDocs();
    }

    public void checkIntegrity() throws IOException {
        this.in.checkIntegrity();
    }

    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        this.checkBounds(docID);
        if (this.vectors == null) {
            return null;
        }
        return this.vectors.get(docID);
    }

    public PointValues getPointValues(String fieldName) throws IOException {
        return this.in.getPointValues(fieldName);
    }

    public VectorValues getVectorValues(String fieldName) throws IOException {
        return this.in.getVectorValues(fieldName);
    }

    public TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        return this.in.searchNearestVectors(field, target, k, acceptDocs, visitedLimit);
    }

    public int numDocs() {
        return this.in.numDocs();
    }

    public int maxDoc() {
        return this.in.maxDoc();
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.checkBounds(docID);
        this.store.visitDocument(docID, visitor);
    }

    protected void doClose() throws IOException {
        this.in.close();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private void checkBounds(int docID) {
        Objects.checkIndex(docID, this.maxDoc());
    }

    public String toString() {
        return "MergeReaderWrapper(" + this.in + ")";
    }

    public LeafMetaData getMetaData() {
        return this.in.getMetaData();
    }
}

