/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.geo;

import java.io.Closeable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.codecs.lucene90.Lucene90PointsReader;
import org.apache.lucene.codecs.lucene90.Lucene90PointsWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.geo.ShapeTestUtil;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.search.FixedBitSetCollector;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;

public abstract class BaseXYPointTestCase
extends LuceneTestCase {
    protected static final String FIELD_NAME = "point";

    protected float nextX() {
        return ShapeTestUtil.nextFloat(BaseXYPointTestCase.random());
    }

    protected float nextY() {
        return ShapeTestUtil.nextFloat(BaseXYPointTestCase.random());
    }

    protected XYRectangle nextBox() {
        return ShapeTestUtil.nextBox(BaseXYPointTestCase.random());
    }

    protected XYPolygon nextPolygon() {
        return ShapeTestUtil.nextPolygon();
    }

    protected XYGeometry[] nextGeometry() {
        int len = BaseXYPointTestCase.random().nextInt(4) + 1;
        XYGeometry[] geometries = new XYGeometry[len];
        block4: for (int i = 0; i < len; ++i) {
            switch (BaseXYPointTestCase.random().nextInt(3)) {
                case 0: {
                    geometries[i] = new XYPoint(this.nextX(), this.nextY());
                    continue block4;
                }
                case 1: {
                    geometries[i] = this.nextBox();
                    continue block4;
                }
                default: {
                    geometries[i] = this.nextPolygon();
                }
            }
        }
        return geometries;
    }

    public void testIndexExtremeValues() {
        Document document = new Document();
        this.addPointToDoc("foo", document, Float.MAX_VALUE, Float.MAX_VALUE);
        this.addPointToDoc("foo", document, Float.MAX_VALUE, -3.4028235E38f);
        this.addPointToDoc("foo", document, -3.4028235E38f, Float.MAX_VALUE);
        this.addPointToDoc("foo", document, -3.4028235E38f, -3.4028235E38f);
    }

    public void testIndexNaNValues() {
        Document document = new Document();
        IllegalArgumentException expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, Float.NaN, 50.0f));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid value"));
        expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, 50.0f, Float.NaN));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid value"));
    }

    public void testIndexInfValues() {
        Document document = new Document();
        IllegalArgumentException expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, Float.POSITIVE_INFINITY, 0.0f));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid value"));
        expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, Float.NEGATIVE_INFINITY, 0.0f));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid value"));
        expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, 0.0f, Float.POSITIVE_INFINITY));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid value"));
        expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, 0.0f, Float.NEGATIVE_INFINITY));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid value"));
    }

    public void testBoxBasics() throws Exception {
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694f, -65.22745f);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseXYPointTestCase.newSearcher((IndexReader)reader);
        BaseXYPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newRectQuery("field", 18.0f, 19.0f, -66.0f, -65.0f)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testBoxNull() {
        IllegalArgumentException expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newRectQuery(null, 18.0f, 19.0f, -66.0f, -65.0f));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("field must not be null"));
    }

    public void testBoxInvalidCoordinates() throws Exception {
        BaseXYPointTestCase.expectThrows(Exception.class, () -> this.newRectQuery("field", Float.NaN, Float.NaN, Float.NaN, Float.NaN));
    }

    public void testDistanceBasics() throws Exception {
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694f, -65.22745f);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseXYPointTestCase.newSearcher((IndexReader)reader);
        BaseXYPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newDistanceQuery("field", 18.0f, -65.0f, 20.0f)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testDistanceNull() {
        IllegalArgumentException expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery(null, 18.0f, -65.0f, 50000.0f));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("field must not be null"));
    }

    public void testDistanceIllegal() throws Exception {
        BaseXYPointTestCase.expectThrows(Exception.class, () -> this.newDistanceQuery("field", Float.NaN, Float.NaN, 120000.0f));
    }

    public void testDistanceNegative() {
        IllegalArgumentException expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery("field", 18.0f, 19.0f, -1.0f));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("radius"));
    }

    public void testDistanceNaN() {
        IllegalArgumentException expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery("field", 18.0f, 19.0f, Float.NaN));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("radius"));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("NaN"));
    }

    public void testDistanceInf() {
        IllegalArgumentException expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery("field", 18.0f, 19.0f, Float.POSITIVE_INFINITY));
        BaseXYPointTestCase.assertTrue((String)expected.getMessage(), (boolean)expected.getMessage().contains("radius"));
        BaseXYPointTestCase.assertTrue((String)expected.getMessage(), (boolean)expected.getMessage().contains("finite"));
        expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery("field", 18.0f, 19.0f, Float.NEGATIVE_INFINITY));
        BaseXYPointTestCase.assertTrue((String)expected.getMessage(), (boolean)expected.getMessage().contains("radius"));
        BaseXYPointTestCase.assertTrue((String)expected.getMessage(), (boolean)expected.getMessage().contains("bigger than 0"));
    }

    public void testPolygonBasics() throws Exception {
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694f, -65.22745f);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseXYPointTestCase.newSearcher((IndexReader)reader);
        BaseXYPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newPolygonQuery("field", new XYPolygon(new float[]{18.0f, 18.0f, 19.0f, 19.0f, 18.0f}, new float[]{-66.0f, -65.0f, -65.0f, -66.0f, -66.0f}, new XYPolygon[0]))));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testPolygonHole() throws Exception {
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694f, -65.22745f);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseXYPointTestCase.newSearcher((IndexReader)reader);
        XYPolygon inner = new XYPolygon(new float[]{18.5f, 18.5f, 18.7f, 18.7f, 18.5f}, new float[]{-65.7f, -65.4f, -65.4f, -65.7f, -65.7f}, new XYPolygon[0]);
        XYPolygon outer = new XYPolygon(new float[]{18.0f, 18.0f, 19.0f, 19.0f, 18.0f}, new float[]{-66.0f, -65.0f, -65.0f, -66.0f, -66.0f}, new XYPolygon[]{inner});
        BaseXYPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newPolygonQuery("field", outer)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testPolygonHoleExcludes() throws Exception {
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694f, -65.22745f);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseXYPointTestCase.newSearcher((IndexReader)reader);
        XYPolygon inner = new XYPolygon(new float[]{18.2f, 18.2f, 18.4f, 18.4f, 18.2f}, new float[]{-65.3f, -65.2f, -65.2f, -65.3f, -65.3f}, new XYPolygon[0]);
        XYPolygon outer = new XYPolygon(new float[]{18.0f, 18.0f, 19.0f, 19.0f, 18.0f}, new float[]{-66.0f, -65.0f, -65.0f, -66.0f, -66.0f}, new XYPolygon[]{inner});
        BaseXYPointTestCase.assertEquals((long)0L, (long)searcher.count(this.newPolygonQuery("field", outer)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testMultiPolygonBasics() throws Exception {
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694f, -65.22745f);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseXYPointTestCase.newSearcher((IndexReader)reader);
        XYPolygon a = new XYPolygon(new float[]{28.0f, 28.0f, 29.0f, 29.0f, 28.0f}, new float[]{-56.0f, -55.0f, -55.0f, -56.0f, -56.0f}, new XYPolygon[0]);
        XYPolygon b = new XYPolygon(new float[]{18.0f, 18.0f, 19.0f, 19.0f, 18.0f}, new float[]{-66.0f, -65.0f, -65.0f, -66.0f, -66.0f}, new XYPolygon[0]);
        BaseXYPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newPolygonQuery("field", a, b)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testPolygonNullField() {
        IllegalArgumentException expected = BaseXYPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newPolygonQuery(null, new XYPolygon(new float[]{18.0f, 18.0f, 19.0f, 19.0f, 18.0f}, new float[]{-66.0f, -65.0f, -65.0f, -66.0f, -66.0f}, new XYPolygon[0])));
        BaseXYPointTestCase.assertTrue((boolean)expected.getMessage().contains("field must not be null"));
    }

    public void testSamePointManyTimes() throws Exception {
        int numPoints = BaseXYPointTestCase.atLeast(1000);
        float theX = this.nextX();
        float theY = this.nextY();
        float[] xs = new float[numPoints];
        Arrays.fill(xs, theX);
        float[] ys = new float[numPoints];
        Arrays.fill(ys, theY);
        this.verify(xs, ys);
    }

    public void testLowCardinality() throws Exception {
        int numPoints = BaseXYPointTestCase.atLeast(1000);
        int cardinality = TestUtil.nextInt(BaseXYPointTestCase.random(), 2, 20);
        float[] diffXs = new float[cardinality];
        float[] diffYs = new float[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            diffXs[i] = this.nextX();
            diffYs[i] = this.nextY();
        }
        float[] xs = new float[numPoints];
        float[] ys = new float[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            int index = BaseXYPointTestCase.random().nextInt(cardinality);
            xs[i] = diffXs[index];
            ys[i] = diffYs[index];
        }
        this.verify(xs, ys);
    }

    public void testAllYEqual() throws Exception {
        int numPoints = BaseXYPointTestCase.atLeast(1000);
        float y = this.nextY();
        float[] xs = new float[numPoints];
        float[] ys = new float[numPoints];
        boolean haveRealDoc = false;
        for (int docID = 0; docID < numPoints; ++docID) {
            int x = BaseXYPointTestCase.random().nextInt(20);
            if (x == 17) {
                ys[docID] = Float.NaN;
                if (!VERBOSE) continue;
                System.out.println("  doc=" + docID + " is missing");
                continue;
            }
            if (docID > 0 && x == 14 && haveRealDoc) {
                int oldDocID;
                while (Float.isNaN(ys[oldDocID = BaseXYPointTestCase.random().nextInt(docID)])) {
                }
                ys[docID] = xs[oldDocID];
                if (VERBOSE) {
                    System.out.println("  doc=" + docID + " y=" + y + " x=" + xs[docID] + " (same x/y as doc=" + oldDocID + ")");
                }
            } else {
                xs[docID] = this.nextX();
                haveRealDoc = true;
                if (VERBOSE) {
                    System.out.println("  doc=" + docID + " y=" + y + " x=" + xs[docID]);
                }
            }
            ys[docID] = y;
        }
        this.verify(xs, ys);
    }

    public void testAllXEqual() throws Exception {
        int numPoints = BaseXYPointTestCase.atLeast(1000);
        float theX = this.nextX();
        float[] xs = new float[numPoints];
        float[] ys = new float[numPoints];
        boolean haveRealDoc = false;
        for (int docID = 0; docID < numPoints; ++docID) {
            int x = BaseXYPointTestCase.random().nextInt(20);
            if (x == 17) {
                ys[docID] = Float.NaN;
                if (!VERBOSE) continue;
                System.out.println("  doc=" + docID + " is missing");
                continue;
            }
            if (docID > 0 && x == 14 && haveRealDoc) {
                int oldDocID;
                while (Float.isNaN(ys[oldDocID = BaseXYPointTestCase.random().nextInt(docID)])) {
                }
                ys[docID] = ys[oldDocID];
                if (VERBOSE) {
                    System.out.println("  doc=" + docID + " y=" + ys[docID] + " x=" + theX + " (same X/y as doc=" + oldDocID + ")");
                }
            } else {
                ys[docID] = this.nextY();
                haveRealDoc = true;
                if (VERBOSE) {
                    System.out.println("  doc=" + docID + " y=" + ys[docID] + " x=" + theX);
                }
            }
            xs[docID] = theX;
        }
        this.verify(xs, ys);
    }

    public void testMultiValued() throws Exception {
        int numPoints = BaseXYPointTestCase.atLeast(1000);
        float[] xs = new float[2 * numPoints];
        float[] ys = new float[2 * numPoints];
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        IndexWriterConfig iwc = BaseXYPointTestCase.newIndexWriterConfig();
        iwc.setMergePolicy((MergePolicy)BaseXYPointTestCase.newLogMergePolicy());
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        RandomIndexWriter w = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir, iwc);
        for (int id = 0; id < numPoints; ++id) {
            Document doc = new Document();
            xs[2 * id] = this.nextX();
            ys[2 * id] = this.nextY();
            doc.add((IndexableField)new StringField("id", "" + id, Field.Store.YES));
            this.addPointToDoc(FIELD_NAME, doc, xs[2 * id], ys[2 * id]);
            xs[2 * id + 1] = this.nextX();
            ys[2 * id + 1] = this.nextY();
            this.addPointToDoc(FIELD_NAME, doc, xs[2 * id + 1], ys[2 * id + 1]);
            if (VERBOSE) {
                System.out.println("id=" + id);
                System.out.println("  x=" + xs[2 * id] + " y=" + ys[2 * id]);
                System.out.println("  x=" + xs[2 * id + 1] + " y=" + ys[2 * id + 1]);
            }
            w.addDocument(doc);
        }
        if (BaseXYPointTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        DirectoryReader r = w.getReader();
        w.close();
        IndexSearcher s = BaseXYPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseXYPointTestCase.atLeast(25);
        for (int iter = 0; iter < iters; ++iter) {
            XYRectangle rect = this.nextBox();
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " rect=" + rect);
            }
            Query query = this.newRectQuery(FIELD_NAME, rect.minX, rect.maxX, rect.minY, rect.maxY);
            FixedBitSet hits = this.searchIndex(s, query, r.maxDoc());
            boolean fail = false;
            StoredFields storedFields = s.storedFields();
            for (int docID = 0; docID < ys.length / 2; ++docID) {
                boolean expected;
                float yDoc1 = ys[2 * docID];
                float xDoc1 = xs[2 * docID];
                float yDoc2 = ys[2 * docID + 1];
                float xDoc2 = xs[2 * docID + 1];
                boolean result1 = BaseXYPointTestCase.rectContainsPoint(rect, xDoc1, yDoc1);
                boolean result2 = BaseXYPointTestCase.rectContainsPoint(rect, xDoc2, yDoc2);
                boolean bl = expected = result1 || result2;
                if (hits.get(docID) == expected) continue;
                String id = storedFields.document(docID).get("id");
                if (expected) {
                    System.out.println("TEST: id=" + id + " docID=" + docID + " should match but did not");
                } else {
                    System.out.println("TEST: id=" + id + " docID=" + docID + " should not match but did");
                }
                System.out.println("  rect=" + rect);
                System.out.println("  x=" + xDoc1 + " y=" + yDoc1 + "\n  x=" + xDoc2 + " y=" + yDoc2);
                System.out.println("  result1=" + result1 + " result2=" + result2);
                fail = true;
            }
            if (!fail) continue;
            BaseXYPointTestCase.fail((String)"some hits were wrong");
        }
        r.close();
        dir.close();
    }

    public void testRandomTiny() throws Exception {
        this.doTestRandom(10);
    }

    public void testRandomMedium() throws Exception {
        this.doTestRandom(1000);
    }

    @LuceneTestCase.Nightly
    public void testRandomBig() throws Exception {
        BaseXYPointTestCase.assumeFalse("Direct codec can OOME on this test", TestUtil.getDocValuesFormat(FIELD_NAME).equals("Direct"));
        this.doTestRandom(200000);
    }

    private void doTestRandom(int count) throws Exception {
        int numPoints = BaseXYPointTestCase.atLeast(count);
        if (VERBOSE) {
            System.out.println("TEST: numPoints=" + numPoints);
        }
        float[] xs = new float[numPoints];
        float[] ys = new float[numPoints];
        boolean haveRealDoc = false;
        for (int id = 0; id < numPoints; ++id) {
            int x = BaseXYPointTestCase.random().nextInt(20);
            if (x == 17) {
                ys[id] = Float.NaN;
                if (!VERBOSE) continue;
                System.out.println("  id=" + id + " is missing");
                continue;
            }
            if (id > 0 && x < 3 && haveRealDoc) {
                int oldID;
                while (Float.isNaN(ys[oldID = BaseXYPointTestCase.random().nextInt(id)])) {
                }
                if (x == 0) {
                    ys[id] = ys[oldID];
                    xs[id] = this.nextX();
                    if (!VERBOSE) continue;
                    System.out.println("  id=" + id + " x=" + xs[id] + " y=" + ys[id] + " (same x as doc=" + oldID + ")");
                    continue;
                }
                if (x == 1) {
                    ys[id] = this.nextY();
                    xs[id] = xs[oldID];
                    if (!VERBOSE) continue;
                    System.out.println("  id=" + id + " x=" + xs[id] + " y=" + ys[id] + " (same y as doc=" + oldID + ")");
                    continue;
                }
                assert (x == 2);
                xs[id] = xs[oldID];
                ys[id] = ys[oldID];
                if (!VERBOSE) continue;
                System.out.println("  id=" + id + " x=" + xs[id] + " y=" + ys[id] + " (same X/y as doc=" + oldID + ")");
                continue;
            }
            xs[id] = this.nextX();
            ys[id] = this.nextY();
            haveRealDoc = true;
            if (!VERBOSE) continue;
            System.out.println("  id=" + id + " x=" + xs[id] + " y=" + ys[id]);
        }
        this.verify(xs, ys);
    }

    protected abstract void addPointToDoc(String var1, Document var2, float var3, float var4);

    protected abstract Query newRectQuery(String var1, float var2, float var3, float var4, float var5);

    protected abstract Query newDistanceQuery(String var1, float var2, float var3, float var4);

    protected abstract Query newPolygonQuery(String var1, XYPolygon ... var2);

    protected abstract Query newGeometryQuery(String var1, XYGeometry ... var2);

    static boolean rectContainsPoint(XYRectangle rect, double x, double y) {
        if (y < (double)rect.minY || y > (double)rect.maxY) {
            return false;
        }
        return x >= (double)rect.minX && x <= (double)rect.maxX;
    }

    static double cartesianDistance(double x1, double y1, double x2, double y2) {
        double diffX = x1 - x2;
        double diffY = y1 - y2;
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }

    private void verify(float[] xs, float[] ys) throws Exception {
        this.verifyRandomRectangles(xs, ys);
        this.verifyRandomDistances(xs, ys);
        this.verifyRandomPolygons(xs, ys);
        this.verifyRandomGeometries(xs, ys);
    }

    protected void verifyRandomRectangles(float[] xs, float[] ys) throws Exception {
        BaseDirectoryWrapper dir;
        IndexWriterConfig iwc = BaseXYPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        int mbd = iwc.getMaxBufferedDocs();
        if (mbd != -1 && mbd < xs.length / 100) {
            iwc.setMaxBufferedDocs(xs.length / 100);
        }
        if (xs.length > 100000) {
            iwc.setCodec(TestUtil.getDefaultCodec());
            dir = BaseXYPointTestCase.newFSDirectory(BaseXYPointTestCase.createTempDir(((Object)((Object)this)).getClass().getSimpleName()));
        } else {
            dir = BaseXYPointTestCase.newDirectory();
        }
        HashSet<Integer> deleted = new HashSet<Integer>();
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        this.indexPoints(xs, ys, deleted, w);
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = BaseXYPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseXYPointTestCase.atLeast(25);
        Bits liveDocs = MultiBits.getLiveDocs((IndexReader)s.getIndexReader());
        int maxDoc = s.getIndexReader().maxDoc();
        for (int iter = 0; iter < iters; ++iter) {
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s=" + s);
            }
            XYRectangle rect = this.nextBox();
            Query query = this.newRectQuery(FIELD_NAME, rect.minX, rect.maxX, rect.minY, rect.maxY);
            if (VERBOSE) {
                System.out.println("  query=" + query);
            }
            FixedBitSet hits = this.searchIndex(s, query, maxDoc);
            boolean fail = false;
            NumericDocValues docIDToID = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
            for (int docID = 0; docID < maxDoc; ++docID) {
                BaseXYPointTestCase.assertEquals((long)docID, (long)docIDToID.nextDoc());
                int id = (int)docIDToID.longValue();
                boolean expected = liveDocs != null && !liveDocs.get(docID) ? false : (Float.isNaN(xs[id]) || Float.isNaN(ys[id]) ? false : BaseXYPointTestCase.rectContainsPoint(rect, xs[id], ys[id]));
                if (hits.get(docID) == expected) continue;
                this.buildError(docID, expected, id, xs, ys, query, liveDocs, b -> b.append("  rect=").append(rect));
                fail = true;
            }
            if (!fail) continue;
            BaseXYPointTestCase.fail((String)"some hits were wrong");
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    protected void verifyRandomDistances(float[] xs, float[] ys) throws Exception {
        BaseDirectoryWrapper dir;
        IndexWriterConfig iwc = BaseXYPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        int mbd = iwc.getMaxBufferedDocs();
        if (mbd != -1 && mbd < xs.length / 100) {
            iwc.setMaxBufferedDocs(xs.length / 100);
        }
        if (xs.length > 100000) {
            iwc.setCodec(TestUtil.getDefaultCodec());
            dir = BaseXYPointTestCase.newFSDirectory(BaseXYPointTestCase.createTempDir(((Object)((Object)this)).getClass().getSimpleName()));
        } else {
            dir = BaseXYPointTestCase.newDirectory();
        }
        HashSet<Integer> deleted = new HashSet<Integer>();
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        this.indexPoints(xs, ys, deleted, w);
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = BaseXYPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseXYPointTestCase.atLeast(25);
        Bits liveDocs = MultiBits.getLiveDocs((IndexReader)s.getIndexReader());
        int maxDoc = s.getIndexReader().maxDoc();
        for (int iter = 0; iter < iters; ++iter) {
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s=" + s);
            }
            float centerX = this.nextX();
            float centerY = this.nextY();
            float radius = BaseXYPointTestCase.random().nextFloat() * Float.MAX_VALUE / 2.0f;
            if (VERBOSE) {
                DecimalFormat df = new DecimalFormat("#,###.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                System.out.println("  radius = " + df.format(radius));
            }
            Query query = this.newDistanceQuery(FIELD_NAME, centerX, centerY, radius);
            if (VERBOSE) {
                System.out.println("  query=" + query);
            }
            FixedBitSet hits = this.searchIndex(s, query, maxDoc);
            boolean fail = false;
            NumericDocValues docIDToID = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
            for (int docID = 0; docID < maxDoc; ++docID) {
                boolean expected;
                BaseXYPointTestCase.assertEquals((long)docID, (long)docIDToID.nextDoc());
                int id = (int)docIDToID.longValue();
                if (liveDocs != null && !liveDocs.get(docID)) {
                    expected = false;
                } else if (Float.isNaN(xs[id]) || Float.isNaN(ys[id])) {
                    expected = false;
                } else {
                    boolean bl = expected = BaseXYPointTestCase.cartesianDistance(centerX, centerY, xs[id], ys[id]) <= (double)radius;
                }
                if (hits.get(docID) == expected) continue;
                Consumer<StringBuilder> explain = b -> {
                    if (!Double.isNaN(xs[id])) {
                        double distance = BaseXYPointTestCase.cartesianDistance(centerX, centerY, xs[id], ys[id]);
                        b.append("  centerX=").append(centerX).append(" centerY=").append(centerY).append(" distance=").append(distance).append(" vs radius=").append(radius);
                    }
                };
                this.buildError(docID, expected, id, xs, ys, query, liveDocs, explain);
                fail = true;
            }
            if (!fail) continue;
            BaseXYPointTestCase.fail((String)"some hits were wrong");
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    protected void verifyRandomPolygons(float[] xs, float[] ys) throws Exception {
        BaseDirectoryWrapper dir;
        IndexWriterConfig iwc = BaseXYPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        int mbd = iwc.getMaxBufferedDocs();
        if (mbd != -1 && mbd < xs.length / 100) {
            iwc.setMaxBufferedDocs(xs.length / 100);
        }
        if (xs.length > 100000) {
            iwc.setCodec(TestUtil.getDefaultCodec());
            dir = BaseXYPointTestCase.newFSDirectory(BaseXYPointTestCase.createTempDir(((Object)((Object)this)).getClass().getSimpleName()));
        } else {
            dir = BaseXYPointTestCase.newDirectory();
        }
        HashSet<Integer> deleted = new HashSet<Integer>();
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        this.indexPoints(xs, ys, deleted, w);
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = BaseXYPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseXYPointTestCase.atLeast(75);
        Bits liveDocs = MultiBits.getLiveDocs((IndexReader)s.getIndexReader());
        int maxDoc = s.getIndexReader().maxDoc();
        for (int iter = 0; iter < iters; ++iter) {
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s=" + s);
            }
            XYPolygon polygon = this.nextPolygon();
            Query query = this.newPolygonQuery(FIELD_NAME, polygon);
            if (VERBOSE) {
                System.out.println("  query=" + query);
            }
            FixedBitSet hits = this.searchIndex(s, query, maxDoc);
            boolean fail = false;
            NumericDocValues docIDToID = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
            for (int docID = 0; docID < maxDoc; ++docID) {
                BaseXYPointTestCase.assertEquals((long)docID, (long)docIDToID.nextDoc());
                int id = (int)docIDToID.longValue();
                boolean expected = liveDocs != null && !liveDocs.get(docID) ? false : (Float.isNaN(xs[id]) || Float.isNaN(ys[id]) ? false : ShapeTestUtil.containsSlowly(polygon, xs[id], ys[id]));
                if (hits.get(docID) == expected) continue;
                this.buildError(docID, expected, id, xs, ys, query, liveDocs, b -> b.append("  polygon=").append(polygon));
                fail = true;
            }
            if (!fail) continue;
            BaseXYPointTestCase.fail((String)"some hits were wrong");
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    protected void verifyRandomGeometries(float[] xs, float[] ys) throws Exception {
        BaseDirectoryWrapper dir;
        IndexWriterConfig iwc = BaseXYPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        int mbd = iwc.getMaxBufferedDocs();
        if (mbd != -1 && mbd < xs.length / 100) {
            iwc.setMaxBufferedDocs(xs.length / 100);
        }
        if (xs.length > 100000) {
            iwc.setCodec(TestUtil.getDefaultCodec());
            dir = BaseXYPointTestCase.newFSDirectory(BaseXYPointTestCase.createTempDir(((Object)((Object)this)).getClass().getSimpleName()));
        } else {
            dir = BaseXYPointTestCase.newDirectory();
        }
        HashSet<Integer> deleted = new HashSet<Integer>();
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        this.indexPoints(xs, ys, deleted, w);
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = BaseXYPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseXYPointTestCase.atLeast(75);
        Bits liveDocs = MultiBits.getLiveDocs((IndexReader)s.getIndexReader());
        int maxDoc = s.getIndexReader().maxDoc();
        for (int iter = 0; iter < iters; ++iter) {
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s=" + s);
            }
            XYGeometry[] geometries = this.nextGeometry();
            Query query = this.newGeometryQuery(FIELD_NAME, geometries);
            Component2D component2D = XYGeometry.create((XYGeometry[])geometries);
            if (VERBOSE) {
                System.out.println("  query=" + query);
            }
            FixedBitSet hits = this.searchIndex(s, query, maxDoc);
            boolean fail = false;
            NumericDocValues docIDToID = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
            for (int docID = 0; docID < maxDoc; ++docID) {
                BaseXYPointTestCase.assertEquals((long)docID, (long)docIDToID.nextDoc());
                int id = (int)docIDToID.longValue();
                boolean expected = liveDocs != null && !liveDocs.get(docID) ? false : (Float.isNaN(xs[id]) || Float.isNaN(ys[id]) ? false : component2D.contains((double)xs[id], (double)ys[id]));
                if (hits.get(docID) == expected) continue;
                this.buildError(docID, expected, id, xs, ys, query, liveDocs, b -> b.append("  geometry=").append(Arrays.toString(geometries)));
                fail = true;
            }
            if (!fail) continue;
            BaseXYPointTestCase.fail((String)"some hits were wrong");
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    private void indexPoints(float[] xs, float[] ys, Set<Integer> deleted, IndexWriter w) throws IOException {
        for (int id = 0; id < xs.length; ++id) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", "" + id, Field.Store.NO));
            doc.add((IndexableField)new NumericDocValuesField("id", (long)id));
            if (!Float.isNaN(xs[id]) && !Float.isNaN(ys[id])) {
                this.addPointToDoc(FIELD_NAME, doc, xs[id], ys[id]);
            }
            w.addDocument((Iterable)doc);
            if (id <= 0 || BaseXYPointTestCase.random().nextInt(100) != 42) continue;
            int idToDelete = BaseXYPointTestCase.random().nextInt(id);
            w.deleteDocuments(new Term[]{new Term("id", "" + idToDelete)});
            deleted.add(idToDelete);
            if (!VERBOSE) continue;
            System.out.println("  delete id=" + idToDelete);
        }
        if (BaseXYPointTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
    }

    private FixedBitSet searchIndex(IndexSearcher s, Query query, int maxDoc) throws IOException {
        return (FixedBitSet)s.search(query, FixedBitSetCollector.createManager(maxDoc));
    }

    private void buildError(int docID, boolean expected, int id, float[] xs, float[] ys, Query query, Bits liveDocs, Consumer<StringBuilder> explain) {
        StringBuilder b = new StringBuilder();
        if (expected) {
            b.append("FAIL: id=").append(id).append(" should match but did not\n");
        } else {
            b.append("FAIL: id=").append(id).append(" should not match but did\n");
        }
        b.append("  query=").append(query).append(" docID=").append(docID).append("\n");
        b.append("  x=").append(xs[id]).append(" y=").append(ys[id]).append("\n");
        b.append("  deleted?=").append(liveDocs != null && !liveDocs.get(docID));
        explain.accept(b);
        BaseXYPointTestCase.fail((String)("wrong hit (first of possibly more):\n\n" + b));
    }

    public void testRectBoundariesAreInclusive() throws Exception {
        XYRectangle rect = ShapeTestUtil.nextBox(BaseXYPointTestCase.random());
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        IndexWriterConfig iwc = BaseXYPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        RandomIndexWriter w = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir, iwc);
        for (int i = 0; i < 3; ++i) {
            float y = i == 0 ? rect.minY : (i == 1 ? (float)(((double)rect.minY + (double)rect.maxY) / 2.0) : rect.maxY);
            for (int j = 0; j < 3; ++j) {
                float x;
                if (j == 0) {
                    x = rect.minX;
                } else if (j == 1) {
                    if (i == 1) continue;
                    x = (float)(((double)rect.minX + (double)rect.maxX) / 2.0);
                } else {
                    x = rect.maxX;
                }
                Document doc = new Document();
                this.addPointToDoc(FIELD_NAME, doc, x, y);
                w.addDocument(doc);
            }
        }
        DirectoryReader r = w.getReader();
        IndexSearcher s = BaseXYPointTestCase.newSearcher((IndexReader)r, false);
        BaseXYPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, rect.minX, rect.maxX, rect.minY, rect.maxY)));
        if (rect.minX != -3.4028235E38f) {
            BaseXYPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, Math.nextDown(rect.minX), rect.maxX, rect.minY, rect.maxY)));
        }
        if (rect.maxX != Float.MAX_VALUE) {
            BaseXYPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, rect.minX, Math.nextUp(rect.maxX), rect.minY, rect.maxY)));
        }
        if (rect.minY != -3.4028235E38f) {
            BaseXYPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, rect.minX, rect.maxX, Math.nextDown(rect.minY), rect.maxY)));
        }
        if (rect.maxY != Float.MAX_VALUE) {
            BaseXYPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, rect.minX, rect.maxX, rect.minY, Math.nextUp(rect.maxY))));
        }
        r.close();
        w.close();
        dir.close();
    }

    public void testRandomDistance() throws Exception {
        int numIters = BaseXYPointTestCase.atLeast(1);
        for (int iters = 0; iters < numIters; ++iters) {
            this.doRandomDistanceTest(10, 100);
        }
    }

    @LuceneTestCase.Nightly
    public void testRandomDistanceHuge() throws Exception {
        for (int iters = 0; iters < 10; ++iters) {
            this.doRandomDistanceTest(2000, 100);
        }
    }

    private void doRandomDistanceTest(int numDocs, int numQueries) throws IOException {
        BaseDirectoryWrapper dir = BaseXYPointTestCase.newDirectory();
        IndexWriterConfig iwc = BaseXYPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        final int pointsInLeaf = 2 + BaseXYPointTestCase.random().nextInt(4);
        Codec in = TestUtil.getDefaultCodec();
        iwc.setCodec((Codec)new FilterCodec(in.getName(), in){

            public PointsFormat pointsFormat() {
                return new PointsFormat(){

                    public PointsWriter fieldsWriter(SegmentWriteState writeState) throws IOException {
                        return new Lucene90PointsWriter(writeState, pointsInLeaf, 16.0);
                    }

                    public PointsReader fieldsReader(SegmentReadState readState) throws IOException {
                        return new Lucene90PointsReader(readState);
                    }
                };
            }
        });
        RandomIndexWriter writer = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)dir, iwc);
        for (int i = 0; i < numDocs; ++i) {
            float x = this.nextX();
            float y = this.nextY();
            Document doc = new Document();
            this.addPointToDoc("field", doc, x, y);
            doc.add((IndexableField)new StoredField("x", x));
            doc.add((IndexableField)new StoredField("y", y));
            writer.addDocument(doc);
        }
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseXYPointTestCase.newSearcher((IndexReader)reader);
        StoredFields storedFields = reader.storedFields();
        for (int i = 0; i < numQueries; ++i) {
            XYCircle circle = ShapeTestUtil.nextCircle();
            float x = circle.getX();
            float y = circle.getY();
            float radius = circle.getRadius();
            BitSet expected = new BitSet();
            for (int doc = 0; doc < reader.maxDoc(); ++doc) {
                float docY;
                float docX = storedFields.document(doc).getField("x").numericValue().floatValue();
                double distance = BaseXYPointTestCase.cartesianDistance(x, y, docX, docY = storedFields.document(doc).getField("y").numericValue().floatValue());
                if (!(distance <= (double)radius)) continue;
                expected.set(doc);
            }
            TopFieldDocs topDocs = searcher.search(this.newDistanceQuery("field", x, y, radius), reader.maxDoc(), Sort.INDEXORDER);
            BitSet actual = new BitSet();
            for (ScoreDoc doc : topDocs.scoreDocs) {
                actual.set(doc.doc);
            }
            try {
                BaseXYPointTestCase.assertEquals((Object)expected, (Object)actual);
                continue;
            }
            catch (AssertionError e) {
                System.out.println("center: (" + x + "," + y + "), radius=" + radius);
                for (int doc = 0; doc < reader.maxDoc(); ++doc) {
                    float docX = storedFields.document(doc).getField("x").numericValue().floatValue();
                    float docY = storedFields.document(doc).getField("y").numericValue().floatValue();
                    double distance = BaseXYPointTestCase.cartesianDistance(x, y, docX, docY);
                    System.out.println(doc + ": (" + x + "," + y + "), distance=" + distance);
                }
                throw e;
            }
        }
        reader.close();
        writer.close();
        dir.close();
    }

    public void testEquals() {
        XYRectangle rect = this.nextBox();
        Query q1 = this.newRectQuery("field", rect.minX, rect.maxX, rect.minY, rect.maxY);
        Query q2 = this.newRectQuery("field", rect.minX, rect.maxX, rect.minY, rect.maxY);
        BaseXYPointTestCase.assertEquals((Object)q1, (Object)q2);
        float x = this.nextX();
        float y = this.nextY();
        q1 = this.newDistanceQuery("field", x, y, 10000.0f);
        q2 = this.newDistanceQuery("field", x, y, 10000.0f);
        BaseXYPointTestCase.assertEquals((Object)q1, (Object)q2);
        BaseXYPointTestCase.assertFalse((boolean)q1.equals((Object)this.newDistanceQuery("field2", x, y, 10000.0f)));
        float[] xs = new float[5];
        float[] ys = new float[5];
        xs[0] = rect.minX;
        ys[0] = rect.minY;
        xs[1] = rect.maxX;
        ys[1] = rect.minY;
        xs[2] = rect.maxX;
        ys[2] = rect.maxY;
        xs[3] = rect.minX;
        ys[3] = rect.maxY;
        xs[4] = rect.minX;
        ys[4] = rect.minY;
        q1 = this.newPolygonQuery("field", new XYPolygon(xs, ys, new XYPolygon[0]));
        q2 = this.newPolygonQuery("field", new XYPolygon(xs, ys, new XYPolygon[0]));
        BaseXYPointTestCase.assertEquals((Object)q1, (Object)q2);
        BaseXYPointTestCase.assertFalse((boolean)q1.equals((Object)this.newPolygonQuery("field2", new XYPolygon(xs, ys, new XYPolygon[0]))));
    }

    private TopDocs searchSmallSet(Query query, int size) throws Exception {
        int i;
        double[][] pts = new double[][]{{32.76342, -96.774}, {32.7559529921407, -96.7759895324707}, {32.77866942010977, -96.77701950073242}, {32.7756745755423, -96.7706036567688}, {27.703618681345585, -139.73458170890808}, {32.94823588839368, -96.4538113027811}, {33.06047141970814, -96.65084838867188}, {32.77865, -96.7772}, {-88.56029371730983, -177.23537676036358}, {33.541429799076354, -26.779373834241003}, {26.774024500421728, -77.35379276106497}, {-90.0, -14.796283808944777}, {32.94823588839368, -178.8538113027811}, {32.94823588839368, 178.8538113027811}, {40.720611, -73.998776}, {-44.5, -179.5}};
        BaseDirectoryWrapper directory = BaseXYPointTestCase.newDirectory();
        IndexWriterConfig iwc = BaseXYPointTestCase.newIndexWriterConfig(new MockAnalyzer(BaseXYPointTestCase.random()));
        iwc.setMaxBufferedDocs(TestUtil.nextInt(BaseXYPointTestCase.random(), 100, 1000));
        iwc.setMergePolicy((MergePolicy)BaseXYPointTestCase.newLogMergePolicy());
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        RandomIndexWriter writer = new RandomIndexWriter(BaseXYPointTestCase.random(), (Directory)directory, iwc);
        for (double[] p : pts) {
            Document doc = new Document();
            this.addPointToDoc(FIELD_NAME, doc, (float)p[0], (float)p[1]);
            writer.addDocument(doc);
        }
        for (i = 0; i < pts.length; i += 2) {
            Document doc = new Document();
            this.addPointToDoc(FIELD_NAME, doc, (float)pts[i][0], (float)pts[i][1]);
            this.addPointToDoc(FIELD_NAME, doc, (float)pts[i + 1][0], (float)pts[i + 1][1]);
            writer.addDocument(doc);
        }
        for (i = 0; i < BaseXYPointTestCase.random().nextInt(10); ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("string", Integer.toString(i), Field.Store.NO));
            writer.addDocument(doc);
        }
        DirectoryReader reader = writer.getReader();
        writer.close();
        IndexSearcher searcher = BaseXYPointTestCase.newSearcher((IndexReader)reader);
        TopDocs topDocs = searcher.search(query, size);
        reader.close();
        directory.close();
        return topDocs;
    }

    public void testSmallSetRect() throws Exception {
        TopDocs td = this.searchSmallSet(this.newRectQuery(FIELD_NAME, 32.778f, 32.779f, -96.778f, -96.777f), 5);
        BaseXYPointTestCase.assertEquals((long)4L, (long)td.totalHits.value);
    }

    public void testSmallSetRect2() throws Exception {
        TopDocs td = this.searchSmallSet(this.newRectQuery(FIELD_NAME, -45.0f, -44.0f, -180.0f, 180.0f), 20);
        BaseXYPointTestCase.assertEquals((long)2L, (long)td.totalHits.value);
    }

    public void testSmallSetMultiValued() throws Exception {
        TopDocs td = this.searchSmallSet(this.newRectQuery(FIELD_NAME, 32.755f, 32.776f, -180.0f, 180.77f), 20);
        BaseXYPointTestCase.assertEquals((long)5L, (long)td.totalHits.value);
    }

    public void testSmallSetWholeSpace() throws Exception {
        TopDocs td = this.searchSmallSet(this.newRectQuery(FIELD_NAME, -3.4028235E38f, Float.MAX_VALUE, -3.4028235E38f, Float.MAX_VALUE), 20);
        BaseXYPointTestCase.assertEquals((long)24L, (long)td.totalHits.value);
    }

    public void testSmallSetPoly() throws Exception {
        TopDocs td = this.searchSmallSet(this.newPolygonQuery(FIELD_NAME, new XYPolygon(new float[]{33.07313f, 32.994267f, 32.938385f, 33.03745f, 33.136974f, 33.116276f, 33.07313f, 33.07313f}, new float[]{-96.768265f, -96.828f, -96.628876f, -96.49292f, -96.60416f, -96.74492f, -96.768265f, -96.768265f}, new XYPolygon[0])), 5);
        BaseXYPointTestCase.assertEquals((long)2L, (long)td.totalHits.value);
    }

    public void testSmallSetPolyWholeSpace() throws Exception {
        TopDocs td = this.searchSmallSet(this.newPolygonQuery(FIELD_NAME, new XYPolygon(new float[]{-3.4028235E38f, Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f}, new float[]{-3.4028235E38f, -3.4028235E38f, Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f}, new XYPolygon[0])), 20);
        BaseXYPointTestCase.assertEquals((String)"testWholeMap failed", (long)24L, (long)td.totalHits.value);
    }

    public void testSmallSetDistance() throws Exception {
        TopDocs td = this.searchSmallSet(this.newDistanceQuery(FIELD_NAME, 32.948235f, -96.45381f, 6.0f), 20);
        BaseXYPointTestCase.assertEquals((long)11L, (long)td.totalHits.value);
    }

    public void testSmallSetTinyDistance() throws Exception {
        TopDocs td = this.searchSmallSet(this.newDistanceQuery(FIELD_NAME, 40.72061f, -73.99878f, 0.1f), 20);
        BaseXYPointTestCase.assertEquals((long)2L, (long)td.totalHits.value);
    }

    public void testSmallSetHugeDistance() throws Exception {
        TopDocs td = this.searchSmallSet(this.newDistanceQuery(FIELD_NAME, 32.948235f, -96.45381f, Float.MAX_VALUE), 20);
        BaseXYPointTestCase.assertEquals((long)24L, (long)td.totalHits.value);
    }
}

