/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.tests.search.AssertingCollector;
import org.apache.lucene.tests.search.AssertingWeight;
import org.apache.lucene.tests.search.QueryUtils;

public class AssertingIndexSearcher
extends IndexSearcher {
    final Random random;

    public AssertingIndexSearcher(Random random, IndexReader r) {
        super(r);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReaderContext context) {
        super(context);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReader r, ExecutorService ex) {
        super(r, (Executor)ex);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReaderContext context, ExecutorService ex) {
        super(context, (Executor)ex);
        this.random = new Random(random.nextLong());
    }

    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        return new AssertingWeight(this.random, super.createWeight(query, scoreMode, boost), scoreMode);
    }

    public Query rewrite(Query original) throws IOException {
        QueryUtils.check(original);
        Query rewritten = super.rewrite(original);
        QueryUtils.check(rewritten);
        return rewritten;
    }

    protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        assert (weight instanceof AssertingWeight);
        AssertingCollector assertingCollector = AssertingCollector.wrap(collector);
        super.search(leaves, weight, (Collector)assertingCollector);
        assert (assertingCollector.hasFinishedCollectingPreviousLeaf);
    }

    public String toString() {
        return "AssertingIndexSearcher(" + super.toString() + ")";
    }
}

