/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Random;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.tests.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;

public class MockTokenizer
extends Tokenizer {
    public static final CharacterRunAutomaton WHITESPACE = new CharacterRunAutomaton(new RegExp("[^ \t\r\n]+").toAutomaton());
    public static final CharacterRunAutomaton KEYWORD = new CharacterRunAutomaton(new RegExp(".*").toAutomaton());
    public static final CharacterRunAutomaton SIMPLE = new CharacterRunAutomaton(new RegExp("[A-Za-z\u00aa\u00b5\u00ba\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02c1\u4e00-\u9fcc]+").toAutomaton());
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private final CharacterRunAutomaton runAutomaton;
    private final boolean lowerCase;
    private final int maxTokenLength;
    private int state;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    int off = 0;
    int bufferedCodePoint = -1;
    int bufferedOff = -1;
    private State streamState = State.CLOSE;
    private int lastOffset = 0;
    private boolean enableChecks = true;
    private final Random random = new Random(RandomizedContext.current().getRandom().nextLong());

    public MockTokenizer(AttributeFactory factory, CharacterRunAutomaton runAutomaton, boolean lowerCase, int maxTokenLength) {
        super(factory);
        this.runAutomaton = runAutomaton;
        this.lowerCase = lowerCase;
        this.state = 0;
        this.maxTokenLength = maxTokenLength;
    }

    public MockTokenizer(CharacterRunAutomaton runAutomaton, boolean lowerCase, int maxTokenLength) {
        this(BaseTokenStreamTestCase.newAttributeFactory(), runAutomaton, lowerCase, maxTokenLength);
    }

    public MockTokenizer(CharacterRunAutomaton runAutomaton, boolean lowerCase) {
        this(runAutomaton, lowerCase, 255);
    }

    public MockTokenizer() {
        this(WHITESPACE, true);
    }

    public MockTokenizer(AttributeFactory factory, CharacterRunAutomaton runAutomaton, boolean lowerCase) {
        this(factory, runAutomaton, lowerCase, 255);
    }

    public MockTokenizer(AttributeFactory factory) {
        this(factory, WHITESPACE, true);
    }

    private void fail(String message) {
        if (this.enableChecks) {
            throw new IllegalStateException(message);
        }
    }

    private void failAlways(String message) {
        throw new IllegalStateException(message);
    }

    public final boolean incrementToken() throws IOException {
        block12: {
            if (this.streamState != State.RESET && this.streamState != State.INCREMENT) {
                this.fail("incrementToken() called while in wrong state: " + this.streamState);
            }
            this.clearAttributes();
            while (true) {
                int endOffset;
                int startOffset;
                int cp;
                if (this.bufferedCodePoint >= 0) {
                    cp = this.bufferedCodePoint;
                    startOffset = this.bufferedOff;
                    this.bufferedCodePoint = -1;
                } else {
                    startOffset = this.off;
                    cp = this.readCodePoint();
                }
                if (cp < 0) break block12;
                if (!this.isTokenChar(cp)) continue;
                char[] chars = new char[2];
                do {
                    int len = Character.toChars(this.normalize(cp), chars, 0);
                    for (int i = 0; i < len; ++i) {
                        this.termAtt.append(chars[i]);
                    }
                    endOffset = this.off;
                } while (this.termAtt.length() < this.maxTokenLength && (cp = this.readCodePoint()) >= 0 && this.isTokenChar(cp));
                if (this.termAtt.length() < this.maxTokenLength) {
                    this.bufferedCodePoint = cp;
                    this.bufferedOff = endOffset;
                } else {
                    this.bufferedCodePoint = -1;
                }
                int correctedStartOffset = this.correctOffset(startOffset);
                int correctedEndOffset = this.correctOffset(endOffset);
                if (correctedStartOffset < 0) {
                    this.failAlways("invalid start offset: " + correctedStartOffset + ", before correction: " + startOffset);
                }
                if (correctedEndOffset < 0) {
                    this.failAlways("invalid end offset: " + correctedEndOffset + ", before correction: " + endOffset);
                }
                if (correctedStartOffset < this.lastOffset) {
                    this.failAlways("start offset went backwards: " + correctedStartOffset + ", before correction: " + startOffset + ", lastOffset: " + this.lastOffset);
                }
                this.lastOffset = correctedStartOffset;
                if (correctedEndOffset < correctedStartOffset) {
                    this.failAlways("end offset: " + correctedEndOffset + " is before start offset: " + correctedStartOffset);
                }
                this.offsetAtt.setOffset(correctedStartOffset, correctedEndOffset);
                if (this.state == -1 || this.runAutomaton.isAccept(this.state)) break;
            }
            this.streamState = State.INCREMENT;
            return true;
        }
        this.streamState = State.INCREMENT_FALSE;
        return false;
    }

    protected int readCodePoint() throws IOException {
        int ch = this.readChar();
        if (ch < 0) {
            return ch;
        }
        if (Character.isLowSurrogate((char)ch)) {
            this.failAlways("unpaired low surrogate: " + Integer.toHexString(ch));
        }
        ++this.off;
        if (Character.isHighSurrogate((char)ch)) {
            int ch2 = this.readChar();
            if (ch2 >= 0) {
                ++this.off;
                if (!Character.isLowSurrogate((char)ch2)) {
                    this.failAlways("unpaired high surrogate: " + Integer.toHexString(ch) + ", followed by: " + Integer.toHexString(ch2));
                }
                return Character.toCodePoint((char)ch, (char)ch2);
            }
            this.failAlways("stream ends with unpaired high surrogate: " + Integer.toHexString(ch));
        }
        return ch;
    }

    protected int readChar() throws IOException {
        switch (this.random.nextInt(10)) {
            case 0: {
                char[] c = new char[1];
                int ret = this.input.read(c);
                return ret < 0 ? ret : c[0];
            }
            case 1: {
                char[] c = new char[2];
                int ret = this.input.read(c, 1, 1);
                return ret < 0 ? ret : c[1];
            }
            case 2: {
                char[] c = new char[1];
                CharBuffer cb = CharBuffer.wrap(c);
                int ret = this.input.read(cb);
                return ret < 0 ? ret : c[0];
            }
        }
        return this.input.read();
    }

    protected boolean isTokenChar(int c) {
        if (this.state < 0) {
            this.state = 0;
        }
        this.state = this.runAutomaton.step(this.state, c);
        return this.state >= 0;
    }

    protected int normalize(int c) {
        return this.lowerCase ? Character.toLowerCase(c) : c;
    }

    public void reset() throws IOException {
        try {
            super.reset();
            this.state = 0;
            this.off = 0;
            this.lastOffset = 0;
            this.bufferedCodePoint = -1;
            if (this.streamState == State.RESET) {
                this.fail("double reset()");
            }
        }
        finally {
            this.streamState = State.RESET;
        }
    }

    public void close() throws IOException {
        try {
            super.close();
            if (this.streamState != State.END && this.streamState != State.CLOSE) {
                this.fail("close() called in wrong state: " + this.streamState);
            }
        }
        finally {
            this.streamState = State.CLOSE;
        }
    }

    protected void setReaderTestPoint() {
        try {
            if (this.streamState != State.CLOSE) {
                this.fail("setReader() called in wrong state: " + this.streamState);
            }
        }
        finally {
            this.streamState = State.SETREADER;
        }
    }

    public void end() throws IOException {
        try {
            super.end();
            int finalOffset = this.correctOffset(this.off);
            this.offsetAtt.setOffset(finalOffset, finalOffset);
            if (this.streamState != State.INCREMENT_FALSE) {
                this.fail("end() called in wrong state=" + this.streamState + "!");
            }
        }
        finally {
            this.streamState = State.END;
        }
    }

    public void setEnableChecks(boolean enableChecks) {
        this.enableChecks = enableChecks;
    }

    private static enum State {
        SETREADER,
        RESET,
        INCREMENT,
        INCREMENT_FALSE,
        END,
        CLOSE;

    }
}

