/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.internal.tests.IndexWriterAccess;
import org.apache.lucene.internal.tests.TestSecrets;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.analysis.MockTokenizer;

public class DocHelper {
    private static final IndexWriterAccess INDEX_WRITER_ACCESS;
    public static final FieldType customType;
    public static final String FIELD_1_TEXT = "field one text";
    public static final String TEXT_FIELD_1_KEY = "textField1";
    public static Field textField1;
    public static final FieldType TEXT_TYPE_STORED_WITH_TVS;
    public static final String FIELD_2_TEXT = "field field field two text";
    public static final int[] FIELD_2_FREQS;
    public static final String TEXT_FIELD_2_KEY = "textField2";
    public static Field textField2;
    public static final FieldType customType3;
    public static final String FIELD_3_TEXT = "aaaNoNorms aaaNoNorms bbbNoNorms";
    public static final String TEXT_FIELD_3_KEY = "textField3";
    public static Field textField3;
    public static final String KEYWORD_TEXT = "Keyword";
    public static final String KEYWORD_FIELD_KEY = "keyField";
    public static Field keyField;
    public static final FieldType customType5;
    public static final String NO_NORMS_TEXT = "omitNormsText";
    public static final String NO_NORMS_KEY = "omitNorms";
    public static Field noNormsField;
    public static final FieldType customType6;
    public static final String NO_TF_TEXT = "analyzed with no tf and positions";
    public static final String NO_TF_KEY = "omitTermFreqAndPositions";
    public static Field noTFField;
    public static final FieldType customType7;
    public static final String UNINDEXED_FIELD_TEXT = "unindexed field text";
    public static final String UNINDEXED_FIELD_KEY = "unIndField";
    public static Field unIndField;
    public static final FieldType STRING_TYPE_STORED_WITH_TVS;
    public static final String UNSTORED_1_FIELD_TEXT = "unstored field text";
    public static final String UNSTORED_FIELD_1_KEY = "unStoredField1";
    public static Field unStoredField1;
    public static final FieldType customType8;
    public static final String UNSTORED_2_FIELD_TEXT = "unstored field text";
    public static final String UNSTORED_FIELD_2_KEY = "unStoredField2";
    public static Field unStoredField2;
    public static final String LAZY_FIELD_BINARY_KEY = "lazyFieldBinary";
    public static byte[] LAZY_FIELD_BINARY_BYTES;
    public static Field lazyFieldBinary;
    public static final String LAZY_FIELD_KEY = "lazyField";
    public static final String LAZY_FIELD_TEXT = "These are some field bytes";
    public static Field lazyField;
    public static final String LARGE_LAZY_FIELD_KEY = "largeLazyField";
    public static String LARGE_LAZY_FIELD_TEXT;
    public static Field largeLazyField;
    public static final String FIELD_UTF1_TEXT = "field one \u4e00text";
    public static final String TEXT_FIELD_UTF1_KEY = "textField1Utf8";
    public static Field textUtfField1;
    public static final String FIELD_UTF2_TEXT = "field field field \u4e00two text";
    public static final int[] FIELD_UTF2_FREQS;
    public static final String TEXT_FIELD_UTF2_KEY = "textField2Utf8";
    public static Field textUtfField2;
    public static Map<String, Object> nameValues;
    public static Field[] fields;
    public static Map<String, IndexableField> all;
    public static Map<String, IndexableField> indexed;
    public static Map<String, IndexableField> stored;
    public static Map<String, IndexableField> unstored;
    public static Map<String, IndexableField> unindexed;
    public static Map<String, IndexableField> termvector;
    public static Map<String, IndexableField> notermvector;
    public static Map<String, IndexableField> lazy;
    public static Map<String, IndexableField> noNorms;
    public static Map<String, IndexableField> noTf;

    private static void add(Map<String, IndexableField> map, IndexableField field) {
        map.put(field.name(), field);
    }

    public static void setupDoc(Document doc) {
        for (int i = 0; i < fields.length; ++i) {
            doc.add((IndexableField)fields[i]);
        }
    }

    public static SegmentCommitInfo writeDoc(Random random, Directory dir, Document doc) throws IOException {
        return DocHelper.writeDoc(random, dir, new MockAnalyzer(random, MockTokenizer.WHITESPACE, false), null, doc);
    }

    public static SegmentCommitInfo writeDoc(Random random, Directory dir, Analyzer analyzer, Similarity similarity, Document doc) throws IOException {
        IndexWriter writer = new IndexWriter(dir, new IndexWriterConfig(analyzer).setSimilarity(similarity == null ? IndexSearcher.getDefaultSimilarity() : similarity));
        writer.addDocument((Iterable)doc);
        writer.commit();
        SegmentCommitInfo info = INDEX_WRITER_ACCESS.newestSegment(writer);
        writer.close();
        return info;
    }

    public static int numFields(Document doc) {
        return doc.getFields().size();
    }

    public static Document createDocument(int n, String indexName, int numFields) {
        StringBuilder sb = new StringBuilder();
        Document doc = new Document();
        doc.add((IndexableField)new Field("id", (CharSequence)Integer.toString(n), (IndexableFieldType)STRING_TYPE_STORED_WITH_TVS));
        doc.add((IndexableField)new Field("indexname", (CharSequence)indexName, (IndexableFieldType)STRING_TYPE_STORED_WITH_TVS));
        sb.append("a");
        sb.append(n);
        doc.add((IndexableField)new Field("field1", (CharSequence)sb.toString(), (IndexableFieldType)TEXT_TYPE_STORED_WITH_TVS));
        sb.append(" b");
        sb.append(n);
        for (int i = 1; i < numFields; ++i) {
            doc.add((IndexableField)new Field("field" + (i + 1), (CharSequence)sb.toString(), (IndexableFieldType)TEXT_TYPE_STORED_WITH_TVS));
        }
        return doc;
    }

    static {
        int i;
        INDEX_WRITER_ACCESS = TestSecrets.getIndexWriterAccess();
        customType = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        textField1 = new Field(TEXT_FIELD_1_KEY, (CharSequence)FIELD_1_TEXT, (IndexableFieldType)customType);
        FIELD_2_FREQS = new int[]{3, 1, 1};
        TEXT_TYPE_STORED_WITH_TVS = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        TEXT_TYPE_STORED_WITH_TVS.setStoreTermVectors(true);
        TEXT_TYPE_STORED_WITH_TVS.setStoreTermVectorPositions(true);
        TEXT_TYPE_STORED_WITH_TVS.setStoreTermVectorOffsets(true);
        TEXT_TYPE_STORED_WITH_TVS.freeze();
        textField2 = new Field(TEXT_FIELD_2_KEY, (CharSequence)FIELD_2_TEXT, (IndexableFieldType)TEXT_TYPE_STORED_WITH_TVS);
        customType3 = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        customType3.setOmitNorms(true);
        textField3 = new Field(TEXT_FIELD_3_KEY, (CharSequence)FIELD_3_TEXT, (IndexableFieldType)customType3);
        keyField = new StringField(KEYWORD_FIELD_KEY, KEYWORD_TEXT, Field.Store.YES);
        customType5 = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        customType5.setOmitNorms(true);
        customType5.setTokenized(false);
        noNormsField = new Field(NO_NORMS_KEY, (CharSequence)NO_NORMS_TEXT, (IndexableFieldType)customType5);
        customType6 = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        customType6.setIndexOptions(IndexOptions.DOCS);
        noTFField = new Field(NO_TF_KEY, (CharSequence)NO_TF_TEXT, (IndexableFieldType)customType6);
        customType7 = new FieldType();
        customType7.setStored(true);
        unIndField = new Field(UNINDEXED_FIELD_KEY, (CharSequence)UNINDEXED_FIELD_TEXT, (IndexableFieldType)customType7);
        STRING_TYPE_STORED_WITH_TVS = new FieldType((IndexableFieldType)StringField.TYPE_STORED);
        STRING_TYPE_STORED_WITH_TVS.setStoreTermVectors(true);
        STRING_TYPE_STORED_WITH_TVS.setStoreTermVectorPositions(true);
        STRING_TYPE_STORED_WITH_TVS.setStoreTermVectorOffsets(true);
        STRING_TYPE_STORED_WITH_TVS.freeze();
        unStoredField1 = new TextField(UNSTORED_FIELD_1_KEY, "unstored field text", Field.Store.NO);
        customType8 = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        customType8.setStoreTermVectors(true);
        unStoredField2 = new Field(UNSTORED_FIELD_2_KEY, (CharSequence)"unstored field text", (IndexableFieldType)customType8);
        lazyField = new Field(LAZY_FIELD_KEY, (CharSequence)LAZY_FIELD_TEXT, (IndexableFieldType)customType);
        textUtfField1 = new Field(TEXT_FIELD_UTF1_KEY, (CharSequence)FIELD_UTF1_TEXT, (IndexableFieldType)customType);
        FIELD_UTF2_FREQS = new int[]{3, 1, 1};
        textUtfField2 = new Field(TEXT_FIELD_UTF2_KEY, (CharSequence)FIELD_UTF2_TEXT, (IndexableFieldType)TEXT_TYPE_STORED_WITH_TVS);
        nameValues = null;
        fields = new Field[]{textField1, textField2, textField3, keyField, noNormsField, noTFField, unIndField, unStoredField1, unStoredField2, textUtfField1, textUtfField2, lazyField, lazyFieldBinary, largeLazyField};
        all = new HashMap<String, IndexableField>();
        indexed = new HashMap<String, IndexableField>();
        stored = new HashMap<String, IndexableField>();
        unstored = new HashMap<String, IndexableField>();
        unindexed = new HashMap<String, IndexableField>();
        termvector = new HashMap<String, IndexableField>();
        notermvector = new HashMap<String, IndexableField>();
        lazy = new HashMap<String, IndexableField>();
        noNorms = new HashMap<String, IndexableField>();
        noTf = new HashMap<String, IndexableField>();
        StringBuilder buffer = new StringBuilder();
        for (i = 0; i < 10000; ++i) {
            buffer.append("Lazily loading lengths of language in lieu of laughing ");
        }
        LAZY_FIELD_BINARY_BYTES = "These are some binary field bytes".getBytes(StandardCharsets.UTF_8);
        DocHelper.fields[DocHelper.fields.length - 2] = lazyFieldBinary = new StoredField(LAZY_FIELD_BINARY_KEY, LAZY_FIELD_BINARY_BYTES);
        LARGE_LAZY_FIELD_TEXT = buffer.toString();
        DocHelper.fields[DocHelper.fields.length - 1] = largeLazyField = new Field(LARGE_LAZY_FIELD_KEY, (CharSequence)LARGE_LAZY_FIELD_TEXT, (IndexableFieldType)customType);
        for (i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            DocHelper.add(all, (IndexableField)f);
            if (f.fieldType().indexOptions() != IndexOptions.NONE) {
                DocHelper.add(indexed, (IndexableField)f);
            } else {
                DocHelper.add(unindexed, (IndexableField)f);
            }
            if (f.fieldType().storeTermVectors()) {
                DocHelper.add(termvector, (IndexableField)f);
            }
            if (f.fieldType().indexOptions() != IndexOptions.NONE && !f.fieldType().storeTermVectors()) {
                DocHelper.add(notermvector, (IndexableField)f);
            }
            if (f.fieldType().stored()) {
                DocHelper.add(stored, (IndexableField)f);
            } else {
                DocHelper.add(unstored, (IndexableField)f);
            }
            if (f.fieldType().indexOptions() == IndexOptions.DOCS) {
                DocHelper.add(noTf, (IndexableField)f);
            }
            if (f.fieldType().omitNorms()) {
                DocHelper.add(noNorms, (IndexableField)f);
            }
            if (f.fieldType().indexOptions() != IndexOptions.DOCS) continue;
            DocHelper.add(noTf, (IndexableField)f);
        }
        nameValues = new HashMap<String, Object>();
        nameValues.put(TEXT_FIELD_1_KEY, FIELD_1_TEXT);
        nameValues.put(TEXT_FIELD_2_KEY, FIELD_2_TEXT);
        nameValues.put(TEXT_FIELD_3_KEY, FIELD_3_TEXT);
        nameValues.put(KEYWORD_FIELD_KEY, KEYWORD_TEXT);
        nameValues.put(NO_NORMS_KEY, NO_NORMS_TEXT);
        nameValues.put(NO_TF_KEY, NO_TF_TEXT);
        nameValues.put(UNINDEXED_FIELD_KEY, UNINDEXED_FIELD_TEXT);
        nameValues.put(UNSTORED_FIELD_1_KEY, "unstored field text");
        nameValues.put(UNSTORED_FIELD_2_KEY, "unstored field text");
        nameValues.put(LAZY_FIELD_KEY, LAZY_FIELD_TEXT);
        nameValues.put(LAZY_FIELD_BINARY_KEY, LAZY_FIELD_BINARY_BYTES);
        nameValues.put(LARGE_LAZY_FIELD_KEY, LARGE_LAZY_FIELD_TEXT);
        nameValues.put(TEXT_FIELD_UTF1_KEY, FIELD_UTF1_TEXT);
        nameValues.put(TEXT_FIELD_UTF2_KEY, FIELD_UTF2_TEXT);
    }
}

