/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.RoaringDocIdSet;
import org.apache.lucene.util.SparseFixedBitSet;
import org.junit.Ignore;

@Ignore
public abstract class BaseBitSetTestCase<T extends BitSet>
extends LuceneTestCase {
    public abstract T copyOf(BitSet var1, int var2) throws IOException;

    static java.util.BitSet randomSet(int numBits, int numBitsSet) {
        assert (numBitsSet <= numBits);
        java.util.BitSet set = new java.util.BitSet(numBits);
        if (numBitsSet == numBits) {
            set.set(0, numBits);
        } else {
            Random random = BaseBitSetTestCase.random();
            for (int i = 0; i < numBitsSet; ++i) {
                int o;
                while (set.get(o = random.nextInt(numBits))) {
                }
                set.set(o);
            }
        }
        return set;
    }

    static java.util.BitSet randomSet(int numBits, float percentSet) {
        return BaseBitSetTestCase.randomSet(numBits, (int)(percentSet * (float)numBits));
    }

    protected void assertEquals(BitSet set1, T set2, int maxDoc) {
        for (int i = 0; i < maxDoc; ++i) {
            BaseBitSetTestCase.assertEquals((String)("Different at " + i), (Object)set1.get(i), (Object)set2.get(i));
        }
    }

    public void testCardinality() throws IOException {
        int numBits = 1 + BaseBitSetTestCase.random().nextInt(100000);
        for (float percentSet : new float[]{0.0f, 0.01f, 0.1f, 0.5f, 0.9f, 0.99f, 1.0f}) {
            JavaUtilBitSet set1 = new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, percentSet), numBits);
            T set2 = this.copyOf(set1, numBits);
            BaseBitSetTestCase.assertEquals((long)set1.cardinality(), (long)set2.cardinality());
        }
    }

    public void testPrevSetBit() throws IOException {
        int numBits = 1 + BaseBitSetTestCase.random().nextInt(100000);
        for (float percentSet : new float[]{0.0f, 0.01f, 0.1f, 0.5f, 0.9f, 0.99f, 1.0f}) {
            JavaUtilBitSet set1 = new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, percentSet), numBits);
            T set2 = this.copyOf(set1, numBits);
            for (int i = 0; i < numBits; ++i) {
                BaseBitSetTestCase.assertEquals((String)Integer.toString(i), (long)set1.prevSetBit(i), (long)set2.prevSetBit(i));
            }
        }
    }

    public void testNextSetBit() throws IOException {
        int numBits = 1 + BaseBitSetTestCase.random().nextInt(100000);
        for (float percentSet : new float[]{0.0f, 0.01f, 0.1f, 0.5f, 0.9f, 0.99f, 1.0f}) {
            JavaUtilBitSet set1 = new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, percentSet), numBits);
            T set2 = this.copyOf(set1, numBits);
            for (int i = 0; i < numBits; ++i) {
                BaseBitSetTestCase.assertEquals((long)set1.nextSetBit(i), (long)set2.nextSetBit(i));
            }
        }
    }

    public void testSet() throws IOException {
        Random random = BaseBitSetTestCase.random();
        int numBits = 1 + random.nextInt(100000);
        JavaUtilBitSet set1 = new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, 0), numBits);
        T set2 = this.copyOf(set1, numBits);
        int iters = 10000 + random.nextInt(10000);
        for (int i = 0; i < iters; ++i) {
            int index = random.nextInt(numBits);
            set1.set(index);
            set2.set(index);
        }
        this.assertEquals(set1, set2, numBits);
    }

    public void testGetAndSet() throws IOException {
        Random random = BaseBitSetTestCase.random();
        int numBits = 1 + random.nextInt(100000);
        JavaUtilBitSet set1 = new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, 0), numBits);
        T set2 = this.copyOf(set1, numBits);
        int iters = 10000 + random.nextInt(10000);
        for (int i = 0; i < iters; ++i) {
            int index = random.nextInt(numBits);
            boolean v1 = set1.getAndSet(index);
            boolean v2 = set2.getAndSet(index);
            BaseBitSetTestCase.assertEquals((Object)v1, (Object)v2);
        }
        this.assertEquals(set1, set2, numBits);
    }

    public void testClear() throws IOException {
        Random random = BaseBitSetTestCase.random();
        int numBits = 1 + random.nextInt(100000);
        for (float percentSet : new float[]{0.0f, 0.01f, 0.1f, 0.5f, 0.9f, 0.99f, 1.0f}) {
            JavaUtilBitSet set1 = new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, percentSet), numBits);
            T set2 = this.copyOf(set1, numBits);
            int iters = 1 + random.nextInt(numBits * 2);
            for (int i = 0; i < iters; ++i) {
                int index = random.nextInt(numBits);
                set1.clear(index);
                set2.clear(index);
            }
            this.assertEquals(set1, set2, numBits);
        }
    }

    public void testClearRange() throws IOException {
        Random random = BaseBitSetTestCase.random();
        int numBits = 1 + random.nextInt(100000);
        for (float percentSet : new float[]{0.0f, 0.01f, 0.1f, 0.5f, 0.9f, 0.99f, 1.0f}) {
            JavaUtilBitSet set1 = new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, percentSet), numBits);
            T set2 = this.copyOf(set1, numBits);
            int iters = BaseBitSetTestCase.atLeast(random, 10);
            for (int i = 0; i < iters; ++i) {
                int from = random.nextInt(numBits);
                int to = random.nextInt(numBits + 1);
                set1.clear(from, to);
                set2.clear(from, to);
                this.assertEquals(set1, set2, numBits);
            }
        }
    }

    private DocIdSet randomCopy(BitSet set, int numBits) throws IOException {
        switch (BaseBitSetTestCase.random().nextInt(5)) {
            case 0: {
                return new BitDocIdSet(set, (long)set.cardinality());
            }
            case 1: {
                return new BitDocIdSet(this.copyOf(set, numBits), (long)set.cardinality());
            }
            case 2: {
                RoaringDocIdSet.Builder builder = new RoaringDocIdSet.Builder(numBits);
                int i = set.nextSetBit(0);
                while (i != Integer.MAX_VALUE) {
                    builder.add(i);
                    i = i + 1 >= numBits ? Integer.MAX_VALUE : set.nextSetBit(i + 1);
                }
                return builder.build();
            }
            case 3: {
                FixedBitSet fbs = new FixedBitSet(numBits);
                fbs.or((DocIdSetIterator)new BitSetIterator(set, 0L));
                return new BitDocIdSet((BitSet)fbs);
            }
            case 4: {
                SparseFixedBitSet sfbs = new SparseFixedBitSet(numBits);
                sfbs.or((DocIdSetIterator)new BitSetIterator(set, 0L));
                return new BitDocIdSet((BitSet)sfbs);
            }
        }
        BaseBitSetTestCase.fail();
        return null;
    }

    private void testOr(float load) throws IOException {
        int numBits = 1 + BaseBitSetTestCase.random().nextInt(100000);
        JavaUtilBitSet set1 = new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, 0), numBits);
        T set2 = this.copyOf(set1, numBits);
        int iterations = BaseBitSetTestCase.atLeast(10);
        for (int iter = 0; iter < iterations; ++iter) {
            DocIdSet otherSet = this.randomCopy(new JavaUtilBitSet(BaseBitSetTestCase.randomSet(numBits, load), numBits), numBits);
            DocIdSetIterator otherIterator = otherSet.iterator();
            if (otherIterator == null) continue;
            set1.or(otherIterator);
            set2.or(otherSet.iterator());
            this.assertEquals(set1, set2, numBits);
        }
    }

    public void testOrSparse() throws IOException {
        this.testOr(0.001f);
    }

    public void testOrDense() throws IOException {
        this.testOr(0.5f);
    }

    public void testOrRandom() throws IOException {
        this.testOr(BaseBitSetTestCase.random().nextFloat());
    }

    private static class JavaUtilBitSet
    extends BitSet {
        private final java.util.BitSet bitSet;
        private final int numBits;

        JavaUtilBitSet(java.util.BitSet bitSet, int numBits) {
            this.bitSet = bitSet;
            this.numBits = numBits;
        }

        public void clear(int index) {
            this.bitSet.clear(index);
        }

        public boolean get(int index) {
            return this.bitSet.get(index);
        }

        public boolean getAndSet(int index) {
            boolean v = this.get(index);
            this.set(index);
            return v;
        }

        public int length() {
            return this.numBits;
        }

        public long ramBytesUsed() {
            return -1L;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public void set(int i) {
            this.bitSet.set(i);
        }

        public void clear(int startIndex, int endIndex) {
            if (startIndex >= endIndex) {
                return;
            }
            this.bitSet.clear(startIndex, endIndex);
        }

        public int cardinality() {
            return this.bitSet.cardinality();
        }

        public int prevSetBit(int index) {
            return this.bitSet.previousSetBit(index);
        }

        public int nextSetBit(int i) {
            int next = this.bitSet.nextSetBit(i);
            if (next == -1) {
                next = Integer.MAX_VALUE;
            }
            return next;
        }
    }
}

