/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public abstract class BaseTermVectorsFormatTestCase
extends BaseIndexFileFormatTestCase {
    private final ThreadLocal<PostingsEnum> docsEnum = new ThreadLocal();

    protected Set<Options> validOptions() {
        return EnumSet.allOf(Options.class);
    }

    protected Options randomOptions() {
        return (Options)((Object)RandomPicks.randomFrom((Random)BaseTermVectorsFormatTestCase.random(), new ArrayList<Options>(this.validOptions())));
    }

    protected FieldType fieldType(Options options) {
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(options.positions);
        ft.setStoreTermVectorOffsets(options.offsets);
        ft.setStoreTermVectorPayloads(options.payloads);
        ft.freeze();
        return ft;
    }

    @Override
    protected void addRandomFields(Document doc) {
        for (Options opts : this.validOptions()) {
            FieldType ft = this.fieldType(opts);
            int numFields = BaseTermVectorsFormatTestCase.random().nextInt(5);
            for (int j = 0; j < numFields; ++j) {
                doc.add((IndexableField)new Field("f_" + opts, (CharSequence)TestUtil.randomSimpleString(BaseTermVectorsFormatTestCase.random(), 2), (IndexableFieldType)ft));
            }
        }
    }

    protected void assertEquals(RandomDocument doc, Fields fields) throws IOException {
        BaseTermVectorsFormatTestCase.assertNotNull((Object)doc);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)fields);
        BaseTermVectorsFormatTestCase.assertEquals((long)doc.fieldNames.length, (long)fields.size());
        HashSet fields1 = new HashSet();
        HashSet<String> fields2 = new HashSet<String>();
        Collections.addAll(fields1, doc.fieldNames);
        for (String field : fields) {
            fields2.add(field);
        }
        BaseTermVectorsFormatTestCase.assertEquals(fields1, fields2);
        for (int i = 0; i < doc.fieldNames.length; ++i) {
            this.assertEquals(doc.tokenStreams[i], doc.fieldTypes[i], fields.terms(doc.fieldNames[i]));
        }
    }

    protected static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    protected void assertEquals(RandomTokenStream tk, FieldType ft, Terms terms) throws IOException {
        int i;
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)terms.getDocCount());
        int termCount = new HashSet<String>(Arrays.asList(tk.terms)).size();
        BaseTermVectorsFormatTestCase.assertEquals((long)termCount, (long)terms.size());
        BaseTermVectorsFormatTestCase.assertEquals((long)termCount, (long)terms.getSumDocFreq());
        BaseTermVectorsFormatTestCase.assertEquals((Object)ft.storeTermVectorPositions(), (Object)terms.hasPositions());
        BaseTermVectorsFormatTestCase.assertEquals((Object)ft.storeTermVectorOffsets(), (Object)terms.hasOffsets());
        BaseTermVectorsFormatTestCase.assertEquals((Object)(ft.storeTermVectorPayloads() && tk.hasPayloads() ? 1 : 0), (Object)terms.hasPayloads());
        HashSet<BytesRef> uniqueTerms = new HashSet<BytesRef>();
        for (String term : tk.freqs.keySet()) {
            uniqueTerms.add(new BytesRef((CharSequence)term));
        }
        Object[] sortedTerms = uniqueTerms.toArray(new BytesRef[0]);
        Arrays.sort(sortedTerms);
        TermsEnum termsEnum = terms.iterator();
        for (i = 0; i < sortedTerms.length; ++i) {
            BytesRef nextTerm = termsEnum.next();
            BaseTermVectorsFormatTestCase.assertEquals((Object)sortedTerms[i], (Object)nextTerm);
            BaseTermVectorsFormatTestCase.assertEquals((Object)sortedTerms[i], (Object)termsEnum.term());
            BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)termsEnum.docFreq());
            PostingsEnum postingsEnum = termsEnum.postings(null);
            postingsEnum = termsEnum.postings(BaseTermVectorsFormatTestCase.random().nextBoolean() ? null : postingsEnum);
            BaseTermVectorsFormatTestCase.assertNotNull((Object)postingsEnum);
            BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postingsEnum.nextDoc());
            BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postingsEnum.docID());
            BaseTermVectorsFormatTestCase.assertEquals((Object)tk.freqs.get(termsEnum.term().utf8ToString()), (Object)postingsEnum.freq());
            BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postingsEnum.nextDoc());
            this.docsEnum.set(postingsEnum);
            PostingsEnum docsAndPositionsEnum = termsEnum.postings(null);
            docsAndPositionsEnum = termsEnum.postings(BaseTermVectorsFormatTestCase.random().nextBoolean() ? null : docsAndPositionsEnum, 24);
            if (terms.hasPositions() || terms.hasOffsets()) {
                BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
                int freq = docsAndPositionsEnum.freq();
                BaseTermVectorsFormatTestCase.assertEquals((Object)tk.freqs.get(termsEnum.term().utf8ToString()), (Object)freq);
                for (int k = 0; k < freq; ++k) {
                    Set<Integer> indexes;
                    int position = docsAndPositionsEnum.nextPosition();
                    if (terms.hasPositions()) {
                        indexes = tk.positionToTerms.get(position);
                        BaseTermVectorsFormatTestCase.assertNotNull(indexes);
                    } else {
                        indexes = tk.startOffsetToTerms.get(docsAndPositionsEnum.startOffset());
                        BaseTermVectorsFormatTestCase.assertNotNull(indexes);
                    }
                    if (terms.hasPositions()) {
                        boolean foundPosition = false;
                        for (int index : indexes) {
                            if (!tk.termBytes[index].equals((Object)termsEnum.term()) || tk.positions[index] != position) continue;
                            foundPosition = true;
                            break;
                        }
                        BaseTermVectorsFormatTestCase.assertTrue((boolean)foundPosition);
                    }
                    if (terms.hasOffsets()) {
                        boolean foundOffset = false;
                        for (int index : indexes) {
                            if (!tk.termBytes[index].equals((Object)termsEnum.term()) || tk.startOffsets[index] != docsAndPositionsEnum.startOffset() || tk.endOffsets[index] != docsAndPositionsEnum.endOffset()) continue;
                            foundOffset = true;
                            break;
                        }
                        BaseTermVectorsFormatTestCase.assertTrue((boolean)foundOffset);
                    }
                    if (!terms.hasPayloads()) continue;
                    boolean foundPayload = false;
                    for (int index : indexes) {
                        if (!tk.termBytes[index].equals((Object)termsEnum.term()) || !BaseTermVectorsFormatTestCase.equals(tk.payloads[index], docsAndPositionsEnum.getPayload())) continue;
                        foundPayload = true;
                        break;
                    }
                    BaseTermVectorsFormatTestCase.assertTrue((boolean)foundPayload);
                }
                BaseTermVectorsFormatTestCase.expectThrows(this.getReadPastLastPositionExceptionClass(), () -> ((PostingsEnum)docsAndPositionsEnum).nextPosition());
                BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
            }
            this.docsEnum.set(docsAndPositionsEnum);
        }
        BaseTermVectorsFormatTestCase.assertNull((Object)termsEnum.next());
        for (i = 0; i < 5; ++i) {
            if (BaseTermVectorsFormatTestCase.random().nextBoolean()) {
                BaseTermVectorsFormatTestCase.assertTrue((boolean)termsEnum.seekExact((BytesRef)RandomPicks.randomFrom((Random)BaseTermVectorsFormatTestCase.random(), (Object[])tk.termBytes)));
                continue;
            }
            BaseTermVectorsFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil((BytesRef)RandomPicks.randomFrom((Random)BaseTermVectorsFormatTestCase.random(), (Object[])tk.termBytes)));
        }
    }

    protected Class<? extends Throwable> getReadPastLastPositionExceptionClass() {
        return IllegalStateException.class;
    }

    protected Document addId(Document doc, String id) {
        doc.add((IndexableField)new StringField("id", id, Field.Store.NO));
        return doc;
    }

    protected int docID(IndexReader reader, String id) throws IOException {
        return new IndexSearcher((IndexReader)reader).search((Query)new TermQuery((Term)new Term((String)"id", (String)id)), (int)1).scoreDocs[0].doc;
    }

    public void testRareVectors() throws IOException {
        RandomDocumentFactory docFactory = new RandomDocumentFactory(10, 20);
        for (Options options : this.validOptions()) {
            int numDocs = BaseTermVectorsFormatTestCase.atLeast(200);
            int docWithVectors = BaseTermVectorsFormatTestCase.random().nextInt(numDocs);
            Document emptyDoc = new Document();
            BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
            RandomIndexWriter writer = new RandomIndexWriter(BaseTermVectorsFormatTestCase.random(), (Directory)dir);
            RandomDocument doc = docFactory.newDocument(TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 1, 3), 20, options);
            for (int i = 0; i < numDocs; ++i) {
                if (i == docWithVectors) {
                    writer.addDocument(this.addId(doc.toDocument(), "42"));
                    continue;
                }
                writer.addDocument(emptyDoc);
            }
            DirectoryReader reader = writer.getReader();
            int docWithVectorsID = this.docID((IndexReader)reader, "42");
            for (int i = 0; i < 10; ++i) {
                int docID = BaseTermVectorsFormatTestCase.random().nextInt(numDocs);
                Fields fields = reader.getTermVectors(docID);
                if (docID == docWithVectorsID) {
                    this.assertEquals(doc, fields);
                    continue;
                }
                BaseTermVectorsFormatTestCase.assertNull((Object)fields);
            }
            Fields fields = reader.getTermVectors(docWithVectorsID);
            this.assertEquals(doc, fields);
            reader.close();
            writer.close();
            dir.close();
        }
    }

    public void testHighFreqs() throws IOException {
        RandomDocumentFactory docFactory = new RandomDocumentFactory(3, 5);
        for (Options options : this.validOptions()) {
            if (options == Options.NONE) continue;
            BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
            RandomIndexWriter writer = new RandomIndexWriter(BaseTermVectorsFormatTestCase.random(), (Directory)dir);
            RandomDocument doc = docFactory.newDocument(TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 1, 2), BaseTermVectorsFormatTestCase.atLeast(2000), options);
            writer.addDocument(doc.toDocument());
            DirectoryReader reader = writer.getReader();
            this.assertEquals(doc, reader.getTermVectors(0));
            reader.close();
            writer.close();
            dir.close();
        }
    }

    @LuceneTestCase.Slow
    public void testLotsOfFields() throws IOException {
        int fieldCount = BaseTermVectorsFormatTestCase.atLeast(100);
        RandomDocumentFactory docFactory = new RandomDocumentFactory(fieldCount, 10);
        for (Options options : this.validOptions()) {
            BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
            RandomIndexWriter writer = new RandomIndexWriter(BaseTermVectorsFormatTestCase.random(), (Directory)dir);
            RandomDocument doc = docFactory.newDocument(TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 20, fieldCount), 5, options);
            writer.addDocument(doc.toDocument());
            DirectoryReader reader = writer.getReader();
            this.assertEquals(doc, reader.getTermVectors(0));
            reader.close();
            writer.close();
            dir.close();
        }
    }

    public void testMixedOptions() throws IOException {
        int numFields = TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 1, 3);
        RandomDocumentFactory docFactory = new RandomDocumentFactory(numFields, 10);
        for (Options options1 : this.validOptions()) {
            for (Options options2 : this.validOptions()) {
                if (options1 == options2) continue;
                BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
                RandomIndexWriter writer = new RandomIndexWriter(BaseTermVectorsFormatTestCase.random(), (Directory)dir);
                RandomDocument doc1 = docFactory.newDocument(numFields, 20, options1);
                RandomDocument doc2 = docFactory.newDocument(numFields, 20, options2);
                writer.addDocument(this.addId(doc1.toDocument(), "1"));
                writer.addDocument(this.addId(doc2.toDocument(), "2"));
                DirectoryReader reader = writer.getReader();
                int doc1ID = this.docID((IndexReader)reader, "1");
                this.assertEquals(doc1, reader.getTermVectors(doc1ID));
                int doc2ID = this.docID((IndexReader)reader, "2");
                this.assertEquals(doc2, reader.getTermVectors(doc2ID));
                reader.close();
                writer.close();
                dir.close();
            }
        }
    }

    public void testRandom() throws IOException {
        RandomDocumentFactory docFactory = new RandomDocumentFactory(5, 20);
        int numDocs = BaseTermVectorsFormatTestCase.atLeast(50);
        RandomDocument[] docs = new RandomDocument[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            docs[i] = docFactory.newDocument(TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 1, 3), TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 10, 50), this.randomOptions());
        }
        BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseTermVectorsFormatTestCase.random(), (Directory)dir);
        for (int i = 0; i < numDocs; ++i) {
            writer.addDocument(this.addId(docs[i].toDocument(), "" + i));
        }
        DirectoryReader reader = writer.getReader();
        for (int i = 0; i < numDocs; ++i) {
            int docID = this.docID((IndexReader)reader, "" + i);
            this.assertEquals(docs[i], reader.getTermVectors(docID));
        }
        reader.close();
        writer.close();
        dir.close();
    }

    private void doTestMerge(Sort indexSort, boolean allowDeletes) throws IOException {
        RandomDocumentFactory docFactory = new RandomDocumentFactory(5, 20);
        int numDocs = BaseTermVectorsFormatTestCase.atLeast(100);
        for (Options options : this.validOptions()) {
            HashMap<String, RandomDocument> docs = new HashMap<String, RandomDocument>();
            for (int i = 0; i < numDocs; ++i) {
                docs.put(Integer.toString(i), docFactory.newDocument(TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 1, 3), BaseTermVectorsFormatTestCase.atLeast(10), options));
            }
            BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
            IndexWriterConfig iwc = BaseTermVectorsFormatTestCase.newIndexWriterConfig();
            if (indexSort != null) {
                iwc.setIndexSort(indexSort);
            }
            RandomIndexWriter writer = new RandomIndexWriter(BaseTermVectorsFormatTestCase.random(), (Directory)dir, iwc);
            ArrayList<String> liveDocIDs = new ArrayList<String>();
            ArrayList ids = new ArrayList(docs.keySet());
            Collections.shuffle(ids, BaseTermVectorsFormatTestCase.random());
            Runnable verifyTermVectors = () -> {
                try (DirectoryReader reader = this.maybeWrapWithMergingReader(writer.getReader());){
                    for (String id : liveDocIDs) {
                        int docID = this.docID((IndexReader)reader, id);
                        this.assertEquals((RandomDocument)docs.get(id), reader.getTermVectors(docID));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
            for (String id : ids) {
                block27: {
                    Document doc = this.addId(((RandomDocument)docs.get(id)).toDocument(), id);
                    if (indexSort != null) {
                        for (SortField sortField : indexSort.getSort()) {
                            doc.add((IndexableField)new NumericDocValuesField(sortField.getField(), (long)TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 0, 1024)));
                        }
                    }
                    if (BaseTermVectorsFormatTestCase.random().nextInt(100) < 5) {
                        IndexWriterConfig otherIwc = BaseTermVectorsFormatTestCase.newIndexWriterConfig();
                        if (indexSort != null) {
                            otherIwc.setIndexSort(indexSort);
                        }
                        try (BaseDirectoryWrapper otherDir = BaseTermVectorsFormatTestCase.newDirectory();
                             RandomIndexWriter otherIw = new RandomIndexWriter(BaseTermVectorsFormatTestCase.random(), (Directory)otherDir, otherIwc);){
                            otherIw.addDocument(doc);
                            try (DirectoryReader otherReader = otherIw.getReader();){
                                TestUtil.addIndexesSlowly(writer.w, otherReader);
                                break block27;
                            }
                        }
                    }
                    writer.addDocument(doc);
                }
                liveDocIDs.add(id);
                if (allowDeletes && BaseTermVectorsFormatTestCase.random().nextInt(100) < 20) {
                    String deleteId = (String)liveDocIDs.remove(BaseTermVectorsFormatTestCase.random().nextInt(liveDocIDs.size()));
                    writer.deleteDocuments(new Term("id", deleteId));
                }
                if (BaseTermVectorsFormatTestCase.rarely()) {
                    writer.commit();
                    verifyTermVectors.run();
                }
                if (!BaseTermVectorsFormatTestCase.rarely()) continue;
                writer.forceMerge(1);
                verifyTermVectors.run();
            }
            verifyTermVectors.run();
            writer.forceMerge(1);
            verifyTermVectors.run();
            IOUtils.close((Closeable[])new Closeable[]{writer, dir});
        }
    }

    public void testMergeWithIndexSort() throws IOException {
        SortField[] sortFields = new SortField[TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 1, 2)];
        for (int i = 0; i < sortFields.length; ++i) {
            sortFields[i] = new SortField("sort_field_" + i, SortField.Type.LONG);
        }
        this.doTestMerge(new Sort(sortFields), false);
        this.doTestMerge(new Sort(sortFields), true);
    }

    public void testMergeWithoutIndexSort() throws IOException {
        this.doTestMerge(null, false);
        this.doTestMerge(null, true);
    }

    public void testClone() throws IOException, InterruptedException {
        RandomDocumentFactory docFactory = new RandomDocumentFactory(5, 20);
        final int numDocs = BaseTermVectorsFormatTestCase.atLeast(50);
        for (Options options : this.validOptions()) {
            RandomDocument[] docs = new RandomDocument[numDocs];
            for (int i = 0; i < numDocs; ++i) {
                docs[i] = docFactory.newDocument(TestUtil.nextInt(BaseTermVectorsFormatTestCase.random(), 1, 3), BaseTermVectorsFormatTestCase.atLeast(10), options);
            }
            BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
            RandomIndexWriter writer = new RandomIndexWriter(BaseTermVectorsFormatTestCase.random(), (Directory)dir);
            for (int i = 0; i < numDocs; ++i) {
                writer.addDocument(this.addId(docs[i].toDocument(), "" + i));
            }
            DirectoryReader reader = writer.getReader();
            for (int i = 0; i < numDocs; ++i) {
                int docID = this.docID((IndexReader)reader, "" + i);
                this.assertEquals(docs[i], reader.getTermVectors(docID));
            }
            AtomicReference exception = new AtomicReference();
            Thread[] threads = new Thread[2];
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = new Thread((IndexReader)reader, docs, exception){
                    final /* synthetic */ IndexReader val$reader;
                    final /* synthetic */ RandomDocument[] val$docs;
                    final /* synthetic */ AtomicReference val$exception;
                    {
                        this.val$reader = indexReader;
                        this.val$docs = randomDocumentArray;
                        this.val$exception = atomicReference;
                    }

                    @Override
                    public void run() {
                        try {
                            for (int i = 0; i < LuceneTestCase.atLeast(100); ++i) {
                                int idx = LuceneTestCase.random().nextInt(numDocs);
                                int docID = BaseTermVectorsFormatTestCase.this.docID(this.val$reader, "" + idx);
                                BaseTermVectorsFormatTestCase.this.assertEquals(this.val$docs[idx], this.val$reader.getTermVectors(docID));
                            }
                        }
                        catch (Throwable t) {
                            this.val$exception.set(t);
                        }
                    }
                };
            }
            for (Thread thread : threads) {
                thread.start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
            reader.close();
            writer.close();
            dir.close();
            BaseTermVectorsFormatTestCase.assertNull((String)"One thread threw an exception", exception.get());
        }
    }

    public void testPostingsEnumFreqs() throws Exception {
        BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        doc.add((IndexableField)new Field("foo", (CharSequence)"bar bar", (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        Terms terms = BaseTermVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader).getTermVector(0, "foo");
        TermsEnum termsEnum = terms.iterator();
        BaseTermVectorsFormatTestCase.assertNotNull((Object)termsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("bar"), (Object)termsEnum.next());
        PostingsEnum postings = termsEnum.postings(null);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        PostingsEnum postings2 = termsEnum.postings(postings);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)postings2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsOnly2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        for (int flag : new int[]{0, 8, 24, 88, 56, 120}) {
            postings = termsEnum.postings(null, flag);
            BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
            BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
            if (flag != 0) {
                BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
            }
            BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
            postings2 = termsEnum.postings(postings, flag);
            BaseTermVectorsFormatTestCase.assertNotNull((Object)postings2);
            BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
            BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
            if (flag != 0) {
                BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
            }
            BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        }
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumPositions() throws Exception {
        BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(true);
        doc.add((IndexableField)new Field("foo", (CharSequence)"bar bar", (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        Terms terms = BaseTermVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader).getTermVector(0, "foo");
        TermsEnum termsEnum = terms.iterator();
        BaseTermVectorsFormatTestCase.assertNotNull((Object)termsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("bar"), (Object)termsEnum.next());
        PostingsEnum postings = termsEnum.postings(null);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        PostingsEnum postings2 = termsEnum.postings(postings);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)postings2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsOnly2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = termsEnum.postings(null, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 88);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 56);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 120);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumOffsets() throws Exception {
        BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(true);
        ft.setStoreTermVectorOffsets(true);
        doc.add((IndexableField)new Field("foo", (CharSequence)"bar bar", (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        Terms terms = BaseTermVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader).getTermVector(0, "foo");
        TermsEnum termsEnum = terms.iterator();
        BaseTermVectorsFormatTestCase.assertNotNull((Object)termsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("bar"), (Object)termsEnum.next());
        PostingsEnum postings = termsEnum.postings(null);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        PostingsEnum postings2 = termsEnum.postings(postings);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)postings2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsOnly2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = termsEnum.postings(null, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 88);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 56);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 120);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumOffsetsWithoutPositions() throws Exception {
        BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorOffsets(true);
        doc.add((IndexableField)new Field("foo", (CharSequence)"bar bar", (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        Terms terms = BaseTermVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader).getTermVector(0, "foo");
        TermsEnum termsEnum = terms.iterator();
        BaseTermVectorsFormatTestCase.assertNotNull((Object)termsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("bar"), (Object)termsEnum.next());
        PostingsEnum postings = termsEnum.postings(null);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        PostingsEnum postings2 = termsEnum.postings(postings);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)postings2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsOnly2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = termsEnum.postings(null, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 88);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 56);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 120);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumPayloads() throws Exception {
        BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        Token token1 = new Token("bar", 0, 3);
        token1.setPayload(BaseTermVectorsFormatTestCase.newBytesRef("pay1"));
        Token token2 = new Token("bar", 4, 7);
        token2.setPayload(BaseTermVectorsFormatTestCase.newBytesRef("pay2"));
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(true);
        ft.setStoreTermVectorPayloads(true);
        doc.add((IndexableField)new Field("foo", (TokenStream)new CannedTokenStream(token1, token2), (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        Terms terms = BaseTermVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader).getTermVector(0, "foo");
        TermsEnum termsEnum = terms.iterator();
        BaseTermVectorsFormatTestCase.assertNotNull((Object)termsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("bar"), (Object)termsEnum.next());
        PostingsEnum postings = termsEnum.postings(null);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        PostingsEnum postings2 = termsEnum.postings(postings);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)postings2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsOnly2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = termsEnum.postings(null, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 88);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay1"), (Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay2"), (Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 56);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 120);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay1"), (Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay2"), (Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumAll() throws Exception {
        BaseDirectoryWrapper dir = BaseTermVectorsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        Token token1 = new Token("bar", 0, 3);
        token1.setPayload(BaseTermVectorsFormatTestCase.newBytesRef("pay1"));
        Token token2 = new Token("bar", 4, 7);
        token2.setPayload(BaseTermVectorsFormatTestCase.newBytesRef("pay2"));
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(true);
        ft.setStoreTermVectorPayloads(true);
        ft.setStoreTermVectorOffsets(true);
        doc.add((IndexableField)new Field("foo", (TokenStream)new CannedTokenStream(token1, token2), (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        Terms terms = BaseTermVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader).getTermVector(0, "foo");
        TermsEnum termsEnum = terms.iterator();
        BaseTermVectorsFormatTestCase.assertNotNull((Object)termsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("bar"), (Object)termsEnum.next());
        PostingsEnum postings = termsEnum.postings(null);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        PostingsEnum postings2 = termsEnum.postings(postings);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)postings2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsOnly2);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BaseTermVectorsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = termsEnum.postings(null, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 88);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay1"), (Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay2"), (Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 56);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || BaseTermVectorsFormatTestCase.newBytesRef("pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.postings(null, 120);
        BaseTermVectorsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay1"), (Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay2"), (Object)docsAndPositionsEnum.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        BaseTermVectorsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BaseTermVectorsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BaseTermVectorsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BaseTermVectorsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BaseTermVectorsFormatTestCase.assertEquals((Object)BaseTermVectorsFormatTestCase.newBytesRef("pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BaseTermVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    protected class RandomDocumentFactory {
        private final String[] fieldNames;
        private final String[] terms;
        private final BytesRef[] termBytes;

        protected RandomDocumentFactory(int distinctFieldNames, int disctinctTerms) {
            HashSet<String> fieldNames = new HashSet<String>();
            while (fieldNames.size() < distinctFieldNames) {
                fieldNames.add(TestUtil.randomSimpleString(LuceneTestCase.random()));
                fieldNames.remove("id");
            }
            this.fieldNames = fieldNames.toArray(new String[0]);
            this.terms = new String[disctinctTerms];
            this.termBytes = new BytesRef[disctinctTerms];
            for (int i = 0; i < disctinctTerms; ++i) {
                this.terms[i] = TestUtil.randomRealisticUnicodeString(LuceneTestCase.random());
                this.termBytes[i] = LuceneTestCase.newBytesRef(this.terms[i]);
            }
        }

        public RandomDocument newDocument(int fieldCount, int maxTermCount, Options options) {
            return new RandomDocument(fieldCount, maxTermCount, options, this.fieldNames, this.terms, this.termBytes);
        }
    }

    protected class RandomDocument {
        private final String[] fieldNames;
        private final FieldType[] fieldTypes;
        private final RandomTokenStream[] tokenStreams;

        protected RandomDocument(int fieldCount, int maxTermCount, Options options, String[] fieldNames, String[] sampleTerms, BytesRef[] sampleTermBytes) {
            if (fieldCount > fieldNames.length) {
                throw new IllegalArgumentException();
            }
            this.fieldNames = new String[fieldCount];
            this.fieldTypes = new FieldType[fieldCount];
            this.tokenStreams = new RandomTokenStream[fieldCount];
            Arrays.fill(this.fieldTypes, BaseTermVectorsFormatTestCase.this.fieldType(options));
            HashSet<String> usedFileNames = new HashSet<String>();
            for (int i = 0; i < fieldCount; ++i) {
                do {
                    this.fieldNames[i] = (String)RandomPicks.randomFrom((Random)LuceneTestCase.random(), (Object[])fieldNames);
                } while (usedFileNames.contains(this.fieldNames[i]));
                usedFileNames.add(this.fieldNames[i]);
                this.tokenStreams[i] = new RandomTokenStream(TestUtil.nextInt(LuceneTestCase.random(), 1, maxTermCount), sampleTerms, sampleTermBytes);
            }
        }

        public Document toDocument() {
            Document doc = new Document();
            for (int i = 0; i < this.fieldNames.length; ++i) {
                doc.add((IndexableField)new Field(this.fieldNames[i], (TokenStream)this.tokenStreams[i], (IndexableFieldType)this.fieldTypes[i]));
            }
            return doc;
        }
    }

    public static class RandomTokenStream
    extends TokenStream {
        final String[] terms;
        final BytesRef[] termBytes;
        final int[] positionsIncrements;
        final int[] positions;
        final int[] startOffsets;
        final int[] endOffsets;
        final BytesRef[] payloads;
        final Map<String, Integer> freqs;
        final Map<Integer, Set<Integer>> positionToTerms;
        final Map<Integer, Set<Integer>> startOffsetToTerms;
        final CharTermAttribute termAtt;
        final PositionIncrementAttribute piAtt;
        final OffsetAttribute oAtt;
        final PayloadAttribute pAtt;
        int i = 0;

        public RandomTokenStream(int len, String[] sampleTerms, BytesRef[] sampleTermBytes) {
            int i;
            this.terms = new String[len];
            this.termBytes = new BytesRef[len];
            this.positionsIncrements = new int[len];
            this.positions = new int[len];
            this.startOffsets = new int[len];
            this.endOffsets = new int[len];
            this.payloads = new BytesRef[len];
            for (i = 0; i < len; ++i) {
                int o = LuceneTestCase.random().nextInt(sampleTerms.length);
                this.terms[i] = sampleTerms[o];
                this.termBytes[i] = sampleTermBytes[o];
                this.positionsIncrements[i] = TestUtil.nextInt(LuceneTestCase.random(), i == 0 ? 1 : 0, 10);
                this.startOffsets[i] = i == 0 ? TestUtil.nextInt(LuceneTestCase.random(), 0, 65536) : this.startOffsets[i - 1] + TestUtil.nextInt(LuceneTestCase.random(), 0, LuceneTestCase.rarely() ? 65536 : 20);
                this.endOffsets[i] = this.startOffsets[i] + TestUtil.nextInt(LuceneTestCase.random(), 0, LuceneTestCase.rarely() ? 1024 : 20);
            }
            for (i = 0; i < len; ++i) {
                this.positions[i] = i == 0 ? this.positionsIncrements[i] - 1 : this.positions[i - 1] + this.positionsIncrements[i];
            }
            if (LuceneTestCase.rarely()) {
                Arrays.fill(this.payloads, this.randomPayload());
            } else {
                for (i = 0; i < len; ++i) {
                    this.payloads[i] = this.randomPayload();
                }
            }
            this.positionToTerms = new HashMap<Integer, Set<Integer>>(len);
            this.startOffsetToTerms = new HashMap<Integer, Set<Integer>>(len);
            for (i = 0; i < len; ++i) {
                if (!this.positionToTerms.containsKey(this.positions[i])) {
                    this.positionToTerms.put(this.positions[i], new HashSet(1));
                }
                this.positionToTerms.get(this.positions[i]).add(i);
                if (!this.startOffsetToTerms.containsKey(this.startOffsets[i])) {
                    this.startOffsetToTerms.put(this.startOffsets[i], new HashSet(1));
                }
                this.startOffsetToTerms.get(this.startOffsets[i]).add(i);
            }
            this.freqs = new HashMap<String, Integer>();
            for (String term : this.terms) {
                if (this.freqs.containsKey(term)) {
                    this.freqs.put(term, this.freqs.get(term) + 1);
                    continue;
                }
                this.freqs.put(term, 1);
            }
            this.addAttributeImpl(new PermissiveOffsetAttributeImpl());
            this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            this.piAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
            this.oAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
            this.pAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        }

        protected BytesRef randomPayload() {
            int len = LuceneTestCase.random().nextInt(5);
            if (len == 0) {
                return null;
            }
            BytesRef payload = new BytesRef(len);
            LuceneTestCase.random().nextBytes(payload.bytes);
            payload.length = len;
            return LuceneTestCase.newBytesRef(payload);
        }

        public boolean hasPayloads() {
            for (BytesRef payload : this.payloads) {
                if (payload == null || payload.length <= 0) continue;
                return true;
            }
            return false;
        }

        public String[] getTerms() {
            return this.terms;
        }

        public BytesRef[] getTermBytes() {
            return this.termBytes;
        }

        public int[] getPositionsIncrements() {
            return this.positionsIncrements;
        }

        public int[] getStartOffsets() {
            return this.startOffsets;
        }

        public int[] getEndOffsets() {
            return this.endOffsets;
        }

        public BytesRef[] getPayloads() {
            return this.payloads;
        }

        public void reset() throws IOException {
            this.i = 0;
            super.reset();
        }

        public final boolean incrementToken() throws IOException {
            if (this.i < this.terms.length) {
                this.clearAttributes();
                this.termAtt.setLength(0).append(this.terms[this.i]);
                this.piAtt.setPositionIncrement(this.positionsIncrements[this.i]);
                this.oAtt.setOffset(this.startOffsets[this.i], this.endOffsets[this.i]);
                this.pAtt.setPayload(this.payloads[this.i]);
                ++this.i;
                return true;
            }
            return false;
        }
    }

    private static class PermissiveOffsetAttributeImpl
    extends AttributeImpl
    implements OffsetAttribute {
        int start;
        int end;

        private PermissiveOffsetAttributeImpl() {
        }

        public int startOffset() {
            return this.start;
        }

        public int endOffset() {
            return this.end;
        }

        public void setOffset(int startOffset, int endOffset) {
            this.start = startOffset;
            this.end = endOffset;
        }

        public void clear() {
            this.end = 0;
            this.start = 0;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof PermissiveOffsetAttributeImpl) {
                PermissiveOffsetAttributeImpl o = (PermissiveOffsetAttributeImpl)((Object)other);
                return o.start == this.start && o.end == this.end;
            }
            return false;
        }

        public int hashCode() {
            return this.start + 31 * this.end;
        }

        public void copyTo(AttributeImpl target) {
            OffsetAttribute t = (OffsetAttribute)target;
            t.setOffset(this.start, this.end);
        }

        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(OffsetAttribute.class, "startOffset", (Object)this.start);
            reflector.reflect(OffsetAttribute.class, "endOffset", (Object)this.end);
        }
    }

    protected static enum Options {
        NONE(false, false, false),
        POSITIONS(true, false, false),
        OFFSETS(false, true, false),
        POSITIONS_AND_OFFSETS(true, true, false),
        POSITIONS_AND_PAYLOADS(true, false, true),
        POSITIONS_AND_OFFSETS_AND_PAYLOADS(true, true, true);

        final boolean positions;
        final boolean offsets;
        final boolean payloads;

        private Options(boolean positions, boolean offsets, boolean payloads) {
            this.positions = positions;
            this.offsets = offsets;
            this.payloads = payloads;
        }
    }
}

