/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.geo.Circle;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.SloppyMath;
import org.apache.lucene.util.TestUtil;

public class GeoTestUtil {
    public static double nextLatitude() {
        return GeoTestUtil.nextDoubleInternal(-90.0, 90.0);
    }

    public static double nextLongitude() {
        return GeoTestUtil.nextDoubleInternal(-180.0, 180.0);
    }

    private static double nextDoubleInternal(double low, double high) {
        double baseValue;
        assert (low >= -2.147483648E9);
        assert (high <= 2.147483647E9);
        assert (Double.isFinite(low));
        assert (Double.isFinite(high));
        assert (high >= low) : "low=" + low + " high=" + high;
        if (low == high) {
            return low;
        }
        int surpriseMe = GeoTestUtil.random().nextInt(17);
        if (surpriseMe == 0) {
            long lowBits = NumericUtils.doubleToSortableLong((double)low);
            long highBits = NumericUtils.doubleToSortableLong((double)high);
            baseValue = NumericUtils.sortableLongToDouble((long)TestUtil.nextLong(GeoTestUtil.random(), lowBits, highBits));
        } else if (surpriseMe == 1) {
            baseValue = low;
        } else if (surpriseMe == 2) {
            baseValue = high;
        } else if (surpriseMe == 3 && low <= 0.0 && high >= 0.0) {
            baseValue = 0.0;
        } else if (surpriseMe == 4) {
            double delta = (high - low) / 360.0;
            int block = GeoTestUtil.random().nextInt(360);
            baseValue = low + delta * (double)block;
        } else {
            baseValue = low + (high - low) * GeoTestUtil.random().nextDouble();
        }
        assert (baseValue >= low);
        assert (baseValue <= high);
        int adjustMe = GeoTestUtil.random().nextInt(17);
        if (adjustMe == 0) {
            return Math.nextAfter(adjustMe, high);
        }
        if (adjustMe == 1) {
            return Math.nextAfter(adjustMe, low);
        }
        return baseValue;
    }

    private static double nextLatitudeNear(double otherLatitude, double delta) {
        delta = Math.abs(delta);
        GeoUtils.checkLatitude((double)otherLatitude);
        int surpriseMe = GeoTestUtil.random().nextInt(97);
        if (surpriseMe == 0) {
            return GeoTestUtil.nextLatitude();
        }
        if (surpriseMe < 49) {
            return GeoTestUtil.nextDoubleInternal(otherLatitude, Math.min(90.0, otherLatitude + delta));
        }
        return GeoTestUtil.nextDoubleInternal(Math.max(-90.0, otherLatitude - delta), otherLatitude);
    }

    private static double nextLongitudeNear(double otherLongitude, double delta) {
        delta = Math.abs(delta);
        GeoUtils.checkLongitude((double)otherLongitude);
        int surpriseMe = GeoTestUtil.random().nextInt(97);
        if (surpriseMe == 0) {
            return GeoTestUtil.nextLongitude();
        }
        if (surpriseMe < 49) {
            return GeoTestUtil.nextDoubleInternal(otherLongitude, Math.min(180.0, otherLongitude + delta));
        }
        return GeoTestUtil.nextDoubleInternal(Math.max(-180.0, otherLongitude - delta), otherLongitude);
    }

    private static double nextLatitudeBetween(double minLatitude, double maxLatitude) {
        assert (maxLatitude >= minLatitude);
        GeoUtils.checkLatitude((double)minLatitude);
        GeoUtils.checkLatitude((double)maxLatitude);
        if (GeoTestUtil.random().nextInt(47) == 0) {
            return GeoTestUtil.nextLatitude();
        }
        double difference = (maxLatitude - minLatitude) / 100.0;
        double lower = Math.max(-90.0, minLatitude - difference);
        double upper = Math.min(90.0, maxLatitude + difference);
        return GeoTestUtil.nextDoubleInternal(lower, upper);
    }

    private static double nextLongitudeBetween(double minLongitude, double maxLongitude) {
        assert (maxLongitude >= minLongitude);
        GeoUtils.checkLongitude((double)minLongitude);
        GeoUtils.checkLongitude((double)maxLongitude);
        if (GeoTestUtil.random().nextInt(47) == 0) {
            return GeoTestUtil.nextLongitude();
        }
        double difference = (maxLongitude - minLongitude) / 100.0;
        double lower = Math.max(-180.0, minLongitude - difference);
        double upper = Math.min(180.0, maxLongitude + difference);
        return GeoTestUtil.nextDoubleInternal(lower, upper);
    }

    private static double[] nextPointAroundLine(double lat1, double lon1, double lat2, double lon2) {
        double x1 = lon1;
        double x2 = lon2;
        double y1 = lat1;
        double y2 = lat2;
        double minX = Math.min(x1, x2);
        double maxX = Math.max(x1, x2);
        double minY = Math.min(y1, y2);
        double maxY = Math.max(y1, y2);
        if (minX == maxX) {
            return new double[]{GeoTestUtil.nextLatitudeBetween(minY, maxY), GeoTestUtil.nextLongitudeNear(minX, 0.01 * (maxY - minY))};
        }
        if (minY == maxY) {
            return new double[]{GeoTestUtil.nextLatitudeNear(minY, 0.01 * (maxX - minX)), GeoTestUtil.nextLongitudeBetween(minX, maxX)};
        }
        double x = GeoTestUtil.nextLongitudeBetween(minX, maxX);
        double y = (y1 - y2) / (x1 - x2) * (x - x1) + y1;
        if (!Double.isFinite(y)) {
            y = Math.copySign(90.0, x1);
        }
        double delta = (maxY - minY) * 0.01;
        y = Math.min(90.0, y);
        y = Math.max(-90.0, y);
        return new double[]{GeoTestUtil.nextLatitudeNear(y, delta), x};
    }

    public static double[] nextPointNear(Rectangle rectangle) {
        if (rectangle.crossesDateline()) {
            if (GeoTestUtil.random().nextBoolean()) {
                return GeoTestUtil.nextPointNear(new Rectangle(rectangle.minLat, rectangle.maxLat, -180.0, rectangle.maxLon));
            }
            return GeoTestUtil.nextPointNear(new Rectangle(rectangle.minLat, rectangle.maxLat, rectangle.minLon, 180.0));
        }
        return GeoTestUtil.nextPointNear(GeoTestUtil.boxPolygon(rectangle));
    }

    public static double[] nextPointNear(Polygon polygon) {
        double[] polyLats = polygon.getPolyLats();
        double[] polyLons = polygon.getPolyLons();
        Polygon[] holes = polygon.getHoles();
        if (holes.length > 0 && GeoTestUtil.random().nextInt(3) == 0) {
            return GeoTestUtil.nextPointNear(holes[GeoTestUtil.random().nextInt(holes.length)]);
        }
        int surpriseMe = GeoTestUtil.random().nextInt(97);
        if (surpriseMe == 0) {
            return new double[]{GeoTestUtil.nextLatitude(), GeoTestUtil.nextLongitude()};
        }
        if (surpriseMe < 5) {
            return new double[]{GeoTestUtil.nextLatitudeBetween(polygon.minLat, polygon.maxLat), GeoTestUtil.nextLongitudeBetween(polygon.minLon, polygon.maxLon)};
        }
        if (surpriseMe < 20) {
            int vertex = GeoTestUtil.random().nextInt(polyLats.length - 1);
            return new double[]{GeoTestUtil.nextLatitudeNear(polyLats[vertex], polyLats[vertex + 1] - polyLats[vertex]), GeoTestUtil.nextLongitudeNear(polyLons[vertex], polyLons[vertex + 1] - polyLons[vertex])};
        }
        if (surpriseMe < 30) {
            Polygon container = GeoTestUtil.boxPolygon(new Rectangle(polygon.minLat, polygon.maxLat, polygon.minLon, polygon.maxLon));
            double[] containerLats = container.getPolyLats();
            double[] containerLons = container.getPolyLons();
            int startVertex = GeoTestUtil.random().nextInt(containerLats.length - 1);
            return GeoTestUtil.nextPointAroundLine(containerLats[startVertex], containerLons[startVertex], containerLats[startVertex + 1], containerLons[startVertex + 1]);
        }
        int startVertex = GeoTestUtil.random().nextInt(polyLats.length - 1);
        int endVertex = GeoTestUtil.random().nextBoolean() ? startVertex + 1 : GeoTestUtil.random().nextInt(polyLats.length - 1);
        return GeoTestUtil.nextPointAroundLine(polyLats[startVertex], polyLons[startVertex], polyLats[endVertex], polyLons[endVertex]);
    }

    public static Rectangle nextBoxNear(Polygon polygon) {
        double[] point2;
        double[] point1;
        Polygon[] holes = polygon.getHoles();
        if (holes.length > 0 && GeoTestUtil.random().nextInt(3) == 0) {
            return GeoTestUtil.nextBoxNear(holes[GeoTestUtil.random().nextInt(holes.length)]);
        }
        int surpriseMe = GeoTestUtil.random().nextInt(97);
        if (surpriseMe == 0) {
            point1 = GeoTestUtil.nextPointNear(polygon);
            point2 = GeoTestUtil.nextPointNear(polygon);
        } else {
            point1 = GeoTestUtil.nextPointNear(polygon);
            point2 = new double[2];
            double[] polyLats = polygon.getPolyLats();
            double[] polyLons = polygon.getPolyLons();
            int vertex = GeoTestUtil.random().nextInt(polyLats.length - 1);
            double deltaX = polyLons[vertex + 1] - polyLons[vertex];
            double deltaY = polyLats[vertex + 1] - polyLats[vertex];
            double edgeLength = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            point2[0] = GeoTestUtil.nextLatitudeNear(point1[0], edgeLength);
            point2[1] = GeoTestUtil.nextLongitudeNear(point1[1], edgeLength);
        }
        double minLat = Math.min(point1[0], point2[0]);
        double maxLat = Math.max(point1[0], point2[0]);
        double minLon = Math.min(point1[1], point2[1]);
        double maxLon = Math.max(point1[1], point2[1]);
        return new Rectangle(minLat, maxLat, minLon, maxLon);
    }

    public static Rectangle nextBox() {
        return GeoTestUtil.nextBoxInternal(true);
    }

    public static Rectangle nextBoxNotCrossingDateline() {
        return GeoTestUtil.nextBoxInternal(false);
    }

    public static Polygon createRegularPolygon(double centerLat, double centerLon, double radiusMeters, int gons) {
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double lon;
            double lat;
            double angle = 360.0 - (double)i * (360.0 / (double)gons);
            double x = Math.cos(Math.toRadians(angle));
            double y = Math.sin(Math.toRadians(angle));
            double factor = 2.0;
            double step = 1.0;
            int last = 0;
            while (true) {
                lat = centerLat + y * factor;
                GeoUtils.checkLatitude((double)lat);
                lon = centerLon + x * factor;
                GeoUtils.checkLongitude((double)lon);
                double distanceMeters = SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)lat, (double)lon);
                if (Math.abs(distanceMeters - radiusMeters) < 0.1) break;
                if (distanceMeters > radiusMeters) {
                    factor -= step;
                    if (last == 1) {
                        step /= 2.0;
                    }
                    last = -1;
                    continue;
                }
                if (!(distanceMeters < radiusMeters)) continue;
                factor += step;
                if (last == -1) {
                    step /= 2.0;
                }
                last = 1;
            }
            result[0][i] = lat;
            result[1][i] = lon;
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(result[0], result[1], new Polygon[0]);
    }

    public static Point nextPoint() {
        double lat = GeoTestUtil.nextLatitude();
        double lon = GeoTestUtil.nextLongitude();
        return new Point(lat, lon);
    }

    public static Line nextLine() {
        Polygon p = GeoTestUtil.nextPolygon();
        double[] lats = new double[p.numPoints() - 1];
        double[] lons = new double[lats.length];
        for (int i = 0; i < lats.length; ++i) {
            lats[i] = p.getPolyLat(i);
            lons[i] = p.getPolyLon(i);
        }
        return new Line(lats, lons);
    }

    public static Circle nextCircle() {
        double lat = GeoTestUtil.nextLatitude();
        double lon = GeoTestUtil.nextLongitude();
        double radiusMeters = GeoTestUtil.random().nextDouble() * 6371008.7714 * Math.PI / 2.0 + 1.0;
        return new Circle(lat, lon, radiusMeters);
    }

    public static Polygon nextPolygon() {
        if (GeoTestUtil.random().nextBoolean()) {
            return GeoTestUtil.surpriseMePolygon();
        }
        if (GeoTestUtil.random().nextInt(10) == 1) {
            while (true) {
                int gons = TestUtil.nextInt(GeoTestUtil.random(), 4, 500);
                double radiusMeters = GeoTestUtil.random().nextDouble() * 6371008.7714 * Math.PI / 2.0 + 1.0;
                try {
                    return GeoTestUtil.createRegularPolygon(GeoTestUtil.nextLatitude(), GeoTestUtil.nextLongitude(), radiusMeters, gons);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                break;
            }
        }
        Rectangle box = GeoTestUtil.nextBoxInternal(false);
        if (GeoTestUtil.random().nextBoolean()) {
            return GeoTestUtil.boxPolygon(box);
        }
        return GeoTestUtil.trianglePolygon(box);
    }

    private static Rectangle nextBoxInternal(boolean canCrossDateLine) {
        double x;
        double lat0 = GeoTestUtil.nextLatitude();
        double lat1 = GeoTestUtil.nextLatitude();
        while (lat0 == lat1) {
            lat1 = GeoTestUtil.nextLatitude();
        }
        double lon0 = GeoTestUtil.nextLongitude();
        double lon1 = GeoTestUtil.nextLongitude();
        while (lon0 == lon1) {
            lon1 = GeoTestUtil.nextLongitude();
        }
        if (lat1 < lat0) {
            x = lat0;
            lat0 = lat1;
            lat1 = x;
        }
        if (!canCrossDateLine && lon1 < lon0) {
            x = lon0;
            lon0 = lon1;
            lon1 = x;
        }
        return new Rectangle(lat0, lat1, lon0, lon1);
    }

    private static Polygon boxPolygon(Rectangle box) {
        assert (!box.crossesDateline());
        double[] polyLats = new double[5];
        double[] polyLons = new double[5];
        polyLats[0] = box.minLat;
        polyLons[0] = box.minLon;
        polyLats[1] = box.maxLat;
        polyLons[1] = box.minLon;
        polyLats[2] = box.maxLat;
        polyLons[2] = box.maxLon;
        polyLats[3] = box.minLat;
        polyLons[3] = box.maxLon;
        polyLats[4] = box.minLat;
        polyLons[4] = box.minLon;
        return new Polygon(polyLats, polyLons, new Polygon[0]);
    }

    private static Polygon trianglePolygon(Rectangle box) {
        assert (!box.crossesDateline());
        double[] polyLats = new double[4];
        double[] polyLons = new double[4];
        polyLats[0] = box.minLat;
        polyLons[0] = box.minLon;
        polyLats[1] = box.maxLat;
        polyLons[1] = box.minLon;
        polyLats[2] = box.maxLat;
        polyLons[2] = box.maxLon;
        polyLats[3] = box.minLat;
        polyLons[3] = box.minLon;
        return new Polygon(polyLats, polyLons, new Polygon[0]);
    }

    private static Polygon surpriseMePolygon() {
        ArrayList<Double> lons;
        ArrayList<Double> lats;
        block0: while (true) {
            double centerLat = GeoTestUtil.nextLatitude();
            double centerLon = GeoTestUtil.nextLongitude();
            double radius = 0.1 + 20.0 * GeoTestUtil.random().nextDouble();
            double radiusDelta = GeoTestUtil.random().nextDouble();
            lats = new ArrayList<Double>();
            lons = new ArrayList<Double>();
            double angle = 0.0;
            while (!((angle += GeoTestUtil.random().nextDouble() * 40.0) > 360.0)) {
                double len = radius * (1.0 - radiusDelta + radiusDelta * GeoTestUtil.random().nextDouble());
                double lat = centerLat + len * Math.cos(Math.toRadians(angle));
                double lon = centerLon + len * Math.sin(Math.toRadians(angle));
                if (lon <= -180.0 || lon >= 180.0 || lat > 90.0 || lat < -90.0) continue block0;
                lats.add(lat);
                lons.add(lon);
            }
            break;
        }
        lats.add((Double)lats.get(0));
        lons.add((Double)lons.get(0));
        double[] latsArray = new double[lats.size()];
        double[] lonsArray = new double[lons.size()];
        for (int i = 0; i < lats.size(); ++i) {
            latsArray[i] = (Double)lats.get(i);
            lonsArray[i] = (Double)lons.get(i);
        }
        return new Polygon(latsArray, lonsArray, new Polygon[0]);
    }

    private static Random random() {
        return RandomizedContext.current().getRandom();
    }

    public static String toSVG(Object ... objects) {
        ArrayList<Object> flattened = new ArrayList<Object>();
        for (Object o : objects) {
            if (o instanceof Polygon[]) {
                flattened.addAll(Arrays.asList((Polygon[])o));
                continue;
            }
            flattened.add(o);
        }
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        for (Object e : flattened) {
            if (!(e instanceof Polygon)) continue;
            Rectangle r = Rectangle.fromPolygon((Polygon[])new Polygon[]{(Polygon)e});
            minLat = Math.min(minLat, r.minLat);
            maxLat = Math.max(maxLat, r.maxLat);
            minLon = Math.min(minLon, r.minLon);
            maxLon = Math.max(maxLon, r.maxLon);
        }
        if (!(Double.isFinite(minLat) && Double.isFinite(maxLat) && Double.isFinite(minLon) && Double.isFinite(maxLon))) {
            throw new IllegalArgumentException("you must pass at least one polygon");
        }
        double xpadding = (maxLon - minLon) / 64.0;
        double ypadding = (maxLat - minLat) / 64.0;
        double pointX = xpadding * 0.1;
        double pointY = ypadding * 0.1;
        StringBuilder sb = new StringBuilder();
        sb.append("<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"640\" width=\"480\" viewBox=\"");
        sb.append(minLon - xpadding).append(" ").append(90.0 - maxLat - ypadding).append(" ").append(maxLon - minLon + 2.0 * xpadding).append(" ").append(maxLat - minLat + 2.0 * ypadding);
        sb.append("\">\n");
        for (Object e : flattened) {
            String opacity;
            String style;
            Polygon gon;
            if (e instanceof double[]) {
                double[] point = (double[])e;
                sb.append("<!-- point: ");
                sb.append(point[0]).append(',').append(point[1]);
                sb.append(" -->\n");
            } else {
                sb.append("<!-- ").append(e.getClass().getSimpleName()).append(": \n");
                sb.append(e.toString());
                sb.append("\n-->\n");
            }
            if (e instanceof Rectangle) {
                gon = GeoTestUtil.boxPolygon((Rectangle)e);
                style = "fill:lightskyblue;stroke:black;stroke-width:0.2%;stroke-dasharray:0.5%,1%;";
                opacity = "0.3";
            } else if (e instanceof double[]) {
                double[] point = (double[])e;
                gon = GeoTestUtil.boxPolygon(new Rectangle(Math.max(-90.0, point[0] - pointY), Math.min(90.0, point[0] + pointY), Math.max(-180.0, point[1] - pointX), Math.min(180.0, point[1] + pointX)));
                style = "fill:red;stroke:red;stroke-width:0.1%;";
                opacity = "0.7";
            } else {
                gon = (Polygon)e;
                style = "fill:lawngreen;stroke:black;stroke-width:0.3%;";
                opacity = "0.5";
            }
            double[] polyLats = gon.getPolyLats();
            double[] polyLons = gon.getPolyLons();
            sb.append("<polygon fill-opacity=\"").append(opacity).append("\" points=\"");
            for (int i = 0; i < polyLats.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(polyLons[i]).append(",").append(90.0 - polyLats[i]);
            }
            sb.append("\" style=\"").append(style).append("\"/>\n");
            for (Polygon hole : gon.getHoles()) {
                double[] holeLats = hole.getPolyLats();
                double[] holeLons = hole.getPolyLons();
                sb.append("<polygon points=\"");
                for (int i = 0; i < holeLats.length; ++i) {
                    if (i > 0) {
                        sb.append(" ");
                    }
                    sb.append(holeLons[i]).append(",").append(90.0 - holeLats[i]);
                }
                sb.append("\" style=\"fill:lightgray\"/>\n");
            }
        }
        sb.append("</svg>\n");
        return sb.toString();
    }

    public static boolean containsSlowly(Polygon polygon, double latitude, double longitude) {
        if (polygon.getHoles().length > 0) {
            throw new UnsupportedOperationException("this testing method does not support holes");
        }
        double[] polyLats = polygon.getPolyLats();
        double[] polyLons = polygon.getPolyLons();
        if (latitude < polygon.minLat || latitude > polygon.maxLat || longitude < polygon.minLon || longitude > polygon.maxLon) {
            return false;
        }
        boolean c = false;
        int nvert = polyLats.length;
        double[] verty = polyLats;
        double[] vertx = polyLons;
        double testy = latitude;
        double testx = longitude;
        int i = 0;
        for (int j = 1; j < nvert; ++j) {
            if (testy == verty[j] && testy == verty[i] || (testy <= verty[j] && testy >= verty[i]) != (testy >= verty[j] && testy <= verty[i])) {
                if (testx == vertx[j] && testx == vertx[i] || (testx <= vertx[j] && testx >= vertx[i]) != (testx >= vertx[j] && testx <= vertx[i]) && GeoUtils.orient((double)vertx[i], (double)verty[i], (double)vertx[j], (double)verty[j], (double)testx, (double)testy) == 0) {
                    return true;
                }
                if (verty[i] > testy != verty[j] > testy && testx < (vertx[j] - vertx[i]) * (testy - verty[i]) / (verty[j] - verty[i]) + vertx[i]) {
                    c = !c;
                }
            }
            ++i;
        }
        return c;
    }

    public static String readShape(String name) throws IOException {
        return Loader.LOADER.readShape(name);
    }

    private static class Loader {
        static Loader LOADER = new Loader();

        private Loader() {
        }

        String readShape(String name) throws IOException {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is == null) {
                throw new FileNotFoundException("classpath resource not found: " + name);
            }
            if (name.endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            return reader.readLine();
        }
    }
}

