/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;

class CrankyStoredFieldsFormat
extends StoredFieldsFormat {
    final StoredFieldsFormat delegate;
    final Random random;

    CrankyStoredFieldsFormat(StoredFieldsFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        return this.delegate.fieldsReader(directory, si, fn, context);
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from StoredFieldsFormat.fieldsWriter()");
        }
        return new CrankyStoredFieldsWriter(this.delegate.fieldsWriter(directory, si, context), this.random);
    }

    static class CrankyStoredFieldsWriter
    extends StoredFieldsWriter {
        final StoredFieldsWriter delegate;
        final Random random;

        CrankyStoredFieldsWriter(StoredFieldsWriter delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void finish(int numDocs) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from StoredFieldsWriter.finish()");
            }
            this.delegate.finish(numDocs);
        }

        public int merge(MergeState mergeState) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from StoredFieldsWriter.merge()");
            }
            return super.merge(mergeState);
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(1000) == 0) {
                throw new IOException("Fake IOException from StoredFieldsWriter.close()");
            }
        }

        public void startDocument() throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from StoredFieldsWriter.startDocument()");
            }
            this.delegate.startDocument();
        }

        public void finishDocument() throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from StoredFieldsWriter.finishDocument()");
            }
            this.delegate.finishDocument();
        }

        public void writeField(FieldInfo info, IndexableField field) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from StoredFieldsWriter.writeField()");
            }
            this.delegate.writeField(info, field);
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            return this.delegate.getChildResources();
        }
    }
}

