/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;

public class AssertingScorer
extends Scorer {
    final Random random;
    final Scorer in;
    final boolean needsScores;
    IteratorState state = IteratorState.START;
    int doc;

    public static Scorer wrap(Random random, Scorer other, boolean canScore) {
        if (other == null) {
            return null;
        }
        return new AssertingScorer(random, other, canScore);
    }

    private AssertingScorer(Random random, Scorer in, boolean needsScores) {
        super(in.weight);
        this.random = random;
        this.in = in;
        this.needsScores = needsScores;
        this.doc = in.docID();
    }

    public Scorer getIn() {
        return this.in;
    }

    boolean iterating() {
        switch (this.docID()) {
            case -1: 
            case 0x7FFFFFFF: {
                return false;
            }
        }
        return this.state != IteratorState.APPROXIMATING;
    }

    public float score() throws IOException {
        assert (this.needsScores);
        assert (this.iterating());
        float score = this.in.score();
        assert (!Float.isNaN(score)) : "NaN score for in=" + this.in;
        return score;
    }

    public Collection<Scorer.ChildScorer> getChildren() {
        return Collections.singletonList(new Scorer.ChildScorer(this.in, "SHOULD"));
    }

    public int docID() {
        return this.in.docID();
    }

    public String toString() {
        return "AssertingScorer(" + this.in + ")";
    }

    public DocIdSetIterator iterator() {
        final DocIdSetIterator in = this.in.iterator();
        assert (in != null);
        return new DocIdSetIterator(){

            public int docID() {
                assert (AssertingScorer.this.in.docID() == in.docID());
                return in.docID();
            }

            public int nextDoc() throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
                int nextDoc = in.nextDoc();
                assert (nextDoc > AssertingScorer.this.doc) : "backwards nextDoc from " + AssertingScorer.this.doc + " to " + nextDoc + " " + in;
                AssertingScorer.this.state = nextDoc == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.ITERATING;
                assert (in.docID() == nextDoc);
                assert (AssertingScorer.this.in.docID() == in.docID());
                AssertingScorer.this.doc = nextDoc;
                return AssertingScorer.this.doc;
            }

            public int advance(int target) throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                assert (target > AssertingScorer.this.doc) : "target must be > docID(), got " + target + " <= " + AssertingScorer.this.doc;
                int advanced = in.advance(target);
                assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
                AssertingScorer.this.state = advanced == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.ITERATING;
                assert (in.docID() == advanced);
                assert (AssertingScorer.this.in.docID() == in.docID());
                AssertingScorer.this.doc = advanced;
                return AssertingScorer.this.doc;
            }

            public long cost() {
                return in.cost();
            }
        };
    }

    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.in.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        assert (inApproximation.docID() == this.doc);
        DocIdSetIterator assertingApproximation = new DocIdSetIterator(){

            public int docID() {
                return inApproximation.docID();
            }

            public int nextDoc() throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                int nextDoc = inApproximation.nextDoc();
                assert (nextDoc > AssertingScorer.this.doc) : "backwards advance from: " + AssertingScorer.this.doc + " to: " + nextDoc;
                AssertingScorer.this.state = nextDoc == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.APPROXIMATING;
                assert (inApproximation.docID() == nextDoc);
                AssertingScorer.this.doc = nextDoc;
                return AssertingScorer.this.doc;
            }

            public int advance(int target) throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                assert (target > AssertingScorer.this.doc) : "target must be > docID(), got " + target + " <= " + AssertingScorer.this.doc;
                int advanced = inApproximation.advance(target);
                assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
                AssertingScorer.this.state = advanced == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.APPROXIMATING;
                assert (inApproximation.docID() == advanced);
                AssertingScorer.this.doc = advanced;
                return AssertingScorer.this.doc;
            }

            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(assertingApproximation){

            public boolean matches() throws IOException {
                assert (AssertingScorer.this.state == IteratorState.APPROXIMATING);
                boolean matches = in.matches();
                if (matches) {
                    assert (AssertingScorer.this.in.iterator().docID() == inApproximation.docID()) : "Approximation and scorer don't advance synchronously";
                    AssertingScorer.this.doc = inApproximation.docID();
                    AssertingScorer.this.state = IteratorState.ITERATING;
                }
                return matches;
            }

            public float matchCost() {
                float matchCost = in.matchCost();
                assert (!Float.isNaN(matchCost));
                assert (matchCost >= 0.0f);
                return matchCost;
            }

            public String toString() {
                return "AssertingScorer@asTwoPhaseIterator(" + in + ")";
            }
        };
    }

    static enum IteratorState {
        START,
        APPROXIMATING,
        ITERATING,
        FINISHED;

    }
}

