/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.PrintStreamInfoStream;
import org.apache.lucene.util.TestUtil;
import org.junit.Assert;

public abstract class BaseLockFactoryTestCase
extends LuceneTestCase {
    protected abstract Directory getDirectory(Path var1) throws IOException;

    public void testBasics() throws IOException {
        Path tempPath = BaseLockFactoryTestCase.createTempDir();
        Directory dir = this.getDirectory(tempPath);
        Lock l = dir.obtainLock("commit");
        BaseLockFactoryTestCase.expectThrows(LockObtainFailedException.class, () -> dir.obtainLock("commit"));
        l.close();
        l = dir.obtainLock("commit");
        l.close();
        dir.close();
    }

    public void testDoubleClose() throws IOException {
        Path tempPath = BaseLockFactoryTestCase.createTempDir();
        Directory dir = this.getDirectory(tempPath);
        Lock l = dir.obtainLock("commit");
        l.close();
        l.close();
        dir.close();
    }

    public void testValidAfterAcquire() throws IOException {
        Path tempPath = BaseLockFactoryTestCase.createTempDir();
        Directory dir = this.getDirectory(tempPath);
        Lock l = dir.obtainLock("commit");
        l.ensureValid();
        l.close();
        dir.close();
    }

    public void testInvalidAfterClose() throws IOException {
        Path tempPath = BaseLockFactoryTestCase.createTempDir();
        Directory dir = this.getDirectory(tempPath);
        Lock l = dir.obtainLock("commit");
        l.close();
        BaseLockFactoryTestCase.expectThrows(AlreadyClosedException.class, () -> l.ensureValid());
        dir.close();
    }

    public void testObtainConcurrently() throws InterruptedException, IOException {
        int i;
        Path tempPath = BaseLockFactoryTestCase.createTempDir();
        final Directory directory = this.getDirectory(tempPath);
        final AtomicBoolean running = new AtomicBoolean(true);
        final AtomicInteger atomicCounter = new AtomicInteger(0);
        final ReentrantLock assertingLock = new ReentrantLock();
        int numThreads = 2 + BaseLockFactoryTestCase.random().nextInt(10);
        final int runs = BaseLockFactoryTestCase.atLeast(10000);
        final CyclicBarrier barrier = new CyclicBarrier(numThreads);
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    while (running.get()) {
                        try (Lock lock = directory.obtainLock("foo.lock");){
                            Assert.assertFalse((boolean)assertingLock.isLocked());
                            if (assertingLock.tryLock()) {
                                assertingLock.unlock();
                            } else {
                                Assert.fail();
                            }
                            assert (lock != null);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (atomicCounter.incrementAndGet() <= runs) continue;
                        running.set(false);
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        directory.close();
    }

    public void testStressLocks() throws Exception {
        Path tempPath = BaseLockFactoryTestCase.createTempDir();
        BaseLockFactoryTestCase.assumeFalse("cannot handle buggy Files.delete", TestUtil.hasWindowsFS(tempPath));
        Directory dir = this.getDirectory(tempPath);
        IndexWriter w = new IndexWriter(dir, new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseLockFactoryTestCase.random())).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        this.addDoc(w);
        w.close();
        WriterThread writer = new WriterThread(100, dir);
        SearcherThread searcher = new SearcherThread(100, dir);
        writer.start();
        searcher.start();
        while (writer.isAlive() || searcher.isAlive()) {
            Thread.sleep(1000L);
        }
        BaseLockFactoryTestCase.assertTrue((String)"IndexWriter hit unexpected exceptions", (!writer.hitException ? 1 : 0) != 0);
        BaseLockFactoryTestCase.assertTrue((String)"IndexSearcher hit unexpected exceptions", (!searcher.hitException ? 1 : 0) != 0);
        dir.close();
    }

    private void addDoc(IndexWriter writer) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)BaseLockFactoryTestCase.newTextField("content", "aaa", Field.Store.NO));
        writer.addDocument((Iterable)doc);
    }

    private class SearcherThread
    extends Thread {
        private Directory dir;
        private int numIteration;
        public boolean hitException = false;

        public SearcherThread(int numIteration, Directory dir) {
            this.numIteration = numIteration;
            this.dir = dir;
        }

        @Override
        public void run() {
            DirectoryReader reader = null;
            IndexSearcher searcher = null;
            TermQuery query = new TermQuery(new Term("content", "aaa"));
            for (int i = 0; i < this.numIteration; ++i) {
                try {
                    reader = DirectoryReader.open((Directory)this.dir);
                    searcher = LuceneTestCase.newSearcher((IndexReader)reader);
                }
                catch (Exception e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Searcher: create hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
                try {
                    searcher.search((Query)query, 1000);
                }
                catch (IOException e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Searcher: search hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
                try {
                    reader.close();
                    continue;
                }
                catch (IOException e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Searcher: close hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
            }
        }
    }

    private class WriterThread
    extends Thread {
        private Directory dir;
        private int numIteration;
        public boolean hitException = false;

        public WriterThread(int numIteration, Directory dir) {
            this.numIteration = numIteration;
            this.dir = dir;
        }

        private String toString(ByteArrayOutputStream baos) {
            try {
                return baos.toString("UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }

        @Override
        public void run() {
            IndexWriter writer = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int i = 0; i < this.numIteration; ++i) {
                PrintStream printStream;
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: WriterThread iter=" + i);
                }
                IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new MockAnalyzer(LuceneTestCase.random()));
                try {
                    printStream = new PrintStream((OutputStream)baos, true, "UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RuntimeException(uee);
                }
                iwc.setInfoStream((InfoStream)new PrintStreamInfoStream(printStream));
                printStream.println("\nTEST: WriterThread iter=" + i);
                iwc.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
                try {
                    writer = new IndexWriter(this.dir, iwc);
                }
                catch (Throwable t) {
                    if (Constants.WINDOWS && t instanceof AccessDeniedException) {
                        printStream.println("TEST: AccessDeniedException on init witer");
                        t.printStackTrace(printStream);
                        break;
                    }
                    this.hitException = true;
                    System.out.println("Stress Test Index Writer: creation hit unexpected exception: " + t.toString());
                    t.printStackTrace(System.out);
                    System.out.println(this.toString(baos));
                    break;
                }
                if (writer == null) continue;
                try {
                    BaseLockFactoryTestCase.this.addDoc(writer);
                }
                catch (Throwable t) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Writer: addDoc hit unexpected exception: " + t.toString());
                    t.printStackTrace(System.out);
                    System.out.println(this.toString(baos));
                    break;
                }
                try {
                    writer.close();
                }
                catch (Throwable t) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Writer: close hit unexpected exception: " + t.toString());
                    t.printStackTrace(System.out);
                    System.out.println(this.toString(baos));
                    break;
                }
                writer = null;
            }
        }
    }
}

