/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

class CrankyPointsFormat
extends PointsFormat {
    PointsFormat delegate;
    Random random;

    CrankyPointsFormat(PointsFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public PointsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new CrankyPointsWriter(this.delegate.fieldsWriter(state), this.random);
    }

    public PointsReader fieldsReader(SegmentReadState state) throws IOException {
        return new CrankyPointsReader(this.delegate.fieldsReader(state), this.random);
    }

    static class CrankyPointsReader
    extends PointsReader {
        final PointsReader delegate;
        final Random random;

        public CrankyPointsReader(PointsReader delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void checkIntegrity() throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.checkIntegrity();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.intersect(fieldName, visitor);
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public byte[] getMinPackedValue(String fieldName) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            return this.delegate.getMinPackedValue(fieldName);
        }

        public byte[] getMaxPackedValue(String fieldName) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            return this.delegate.getMaxPackedValue(fieldName);
        }

        public int getNumDimensions(String fieldName) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            return this.delegate.getNumDimensions(fieldName);
        }

        public int getBytesPerDimension(String fieldName) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            return this.delegate.getBytesPerDimension(fieldName);
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }

        public long size(String fieldName) {
            return this.delegate.size(fieldName);
        }

        public int getDocCount(String fieldName) {
            return this.delegate.getDocCount(fieldName);
        }
    }

    static class CrankyPointsWriter
    extends PointsWriter {
        final PointsWriter delegate;
        final Random random;

        public CrankyPointsWriter(PointsWriter delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void writeField(FieldInfo fieldInfo, PointsReader values) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.writeField(fieldInfo, values);
        }

        public void finish() throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.finish();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public void merge(MergeState mergeState) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.merge(mergeState);
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }
    }
}

