/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VirtualMethod;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class AssertingLeafReader
extends FilterLeafReader {
    static final VirtualMethod<TermsEnum> SEEK_EXACT = new VirtualMethod(TermsEnum.class, "seekExact", new Class[]{BytesRef.class});

    private static void assertThread(String object, Thread creationThread) {
        if (creationThread != Thread.currentThread()) {
            throw new AssertionError((Object)(object + " are only supposed to be consumed in " + "the thread in which they have been acquired. But was acquired in " + creationThread + " and consumed in " + Thread.currentThread() + "."));
        }
    }

    public AssertingLeafReader(LeafReader in) {
        super(in);
        assert (in.maxDoc() >= 0);
        assert (in.numDocs() <= in.maxDoc());
        assert (in.numDeletedDocs() + in.numDocs() == in.maxDoc());
        assert (!in.hasDeletions() || in.numDeletedDocs() > 0 && in.numDocs() < in.maxDoc());
        this.addCoreClosedListener(new LeafReader.CoreClosedListener(){

            public void onClose(Object ownerCoreCacheKey) throws IOException {
                Object expectedKey = AssertingLeafReader.this.getCoreCacheKey();
                assert (expectedKey == ownerCoreCacheKey) : "Core closed listener called on a different key " + expectedKey + " <> " + ownerCoreCacheKey;
            }
        });
    }

    public Fields fields() throws IOException {
        return new AssertingFields(super.fields());
    }

    public Fields getTermVectors(int docID) throws IOException {
        Fields fields = super.getTermVectors(docID);
        return fields == null ? null : new AssertingFields(fields);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        NumericDocValues dv = super.getNumericDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.NUMERIC);
            return new AssertingNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.NUMERIC);
        return null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        BinaryDocValues dv = super.getBinaryDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.BINARY);
            return new AssertingBinaryDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.BINARY);
        return null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        SortedDocValues dv = super.getSortedDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.SORTED);
            return new AssertingSortedDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.SORTED);
        return null;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        SortedNumericDocValues dv = super.getSortedNumericDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.SORTED_NUMERIC);
            return new AssertingSortedNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.SORTED_NUMERIC);
        return null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        SortedSetDocValues dv = super.getSortedSetDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == DocValuesType.SORTED_SET);
            if (dv instanceof RandomAccessOrds) {
                return new AssertingRandomAccessOrds((RandomAccessOrds)dv, this.maxDoc());
            }
            return new AssertingSortedSetDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != DocValuesType.SORTED_SET);
        return null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        NumericDocValues dv = super.getNormValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.hasNorms());
            return new AssertingNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || !fi.hasNorms());
        return null;
    }

    public Bits getLiveDocs() {
        Bits liveDocs = super.getLiveDocs();
        if (liveDocs != null) {
            assert (this.maxDoc() == liveDocs.length());
            liveDocs = new AssertingBits(liveDocs);
        } else {
            assert (this.maxDoc() == this.numDocs());
            assert (!this.hasDeletions());
        }
        return liveDocs;
    }

    public Bits getDocsWithField(String field) throws IOException {
        Bits docsWithField = super.getDocsWithField(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (docsWithField != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() != DocValuesType.NONE);
            assert (this.maxDoc() == docsWithField.length());
            docsWithField = new AssertingBits(docsWithField);
        } else assert (fi == null || fi.getDocValuesType() == DocValuesType.NONE);
        return docsWithField;
    }

    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    public Object getCombinedCoreAndDeletesKey() {
        return this.in.getCombinedCoreAndDeletesKey();
    }

    public static class AssertingBits
    implements Bits {
        private final Thread creationThread = Thread.currentThread();
        final Bits in;

        public AssertingBits(Bits in) {
            this.in = in;
        }

        public boolean get(int index) {
            AssertingLeafReader.assertThread("Bits", this.creationThread);
            assert (index >= 0 && index < this.length());
            return this.in.get(index);
        }

        public int length() {
            AssertingLeafReader.assertThread("Bits", this.creationThread);
            return this.in.length();
        }
    }

    public static class AssertingSortedSetDocValues
    extends SortedSetDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final SortedSetDocValues in;
        private final int maxDoc;
        private final long valueCount;
        long lastOrd = -1L;

        public AssertingSortedSetDocValues(SortedSetDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.valueCount = in.getValueCount();
            assert (this.valueCount >= 0L);
        }

        public long nextOrd() {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (this.lastOrd != -1L);
            long ord = this.in.nextOrd();
            assert (ord < this.valueCount);
            assert (ord == -1L || ord > this.lastOrd);
            this.lastOrd = ord;
            return ord;
        }

        public void setDocument(int docID) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (docID >= 0 && docID < this.maxDoc) : "docid=" + docID + ",maxDoc=" + this.maxDoc;
            this.in.setDocument(docID);
            this.lastOrd = -2L;
        }

        public BytesRef lookupOrd(long ord) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (ord >= 0L && ord < this.valueCount);
            BytesRef result = this.in.lookupOrd(ord);
            assert (result.isValid());
            return result;
        }

        public long getValueCount() {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            long valueCount = this.in.getValueCount();
            assert (valueCount == this.valueCount);
            return valueCount;
        }

        public long lookupTerm(BytesRef key) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (key.isValid());
            long result = this.in.lookupTerm(key);
            assert (result < this.valueCount);
            assert (key.isValid());
            return result;
        }
    }

    public static class AssertingRandomAccessOrds
    extends RandomAccessOrds {
        private final Thread creationThread = Thread.currentThread();
        private final RandomAccessOrds in;
        private final int maxDoc;
        private final long valueCount;
        long lastOrd = -1L;

        public AssertingRandomAccessOrds(RandomAccessOrds in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.valueCount = in.getValueCount();
            assert (this.valueCount >= 0L);
        }

        public long nextOrd() {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (this.lastOrd != -1L);
            long ord = this.in.nextOrd();
            assert (ord < this.valueCount);
            assert (ord == -1L || ord > this.lastOrd);
            this.lastOrd = ord;
            return ord;
        }

        public void setDocument(int docID) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (docID >= 0 && docID < this.maxDoc) : "docid=" + docID + ",maxDoc=" + this.maxDoc;
            this.in.setDocument(docID);
            this.lastOrd = -2L;
        }

        public BytesRef lookupOrd(long ord) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (ord >= 0L && ord < this.valueCount);
            BytesRef result = this.in.lookupOrd(ord);
            assert (result.isValid());
            return result;
        }

        public long getValueCount() {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            long valueCount = this.in.getValueCount();
            assert (valueCount == this.valueCount);
            return valueCount;
        }

        public long lookupTerm(BytesRef key) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (key.isValid());
            long result = this.in.lookupTerm(key);
            assert (result < this.valueCount);
            assert (key.isValid());
            return result;
        }

        public long ordAt(int index) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (index < this.in.cardinality());
            long ord = this.in.ordAt(index);
            assert (ord >= 0L && ord < this.valueCount);
            return ord;
        }

        public int cardinality() {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            int cardinality = this.in.cardinality();
            assert (cardinality >= 0);
            return cardinality;
        }
    }

    public static class AssertingSortedNumericDocValues
    extends SortedNumericDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final SortedNumericDocValues in;
        private final int maxDoc;

        public AssertingSortedNumericDocValues(SortedNumericDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void setDocument(int doc) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (doc >= 0 && doc < this.maxDoc);
            this.in.setDocument(doc);
            long previous = Long.MIN_VALUE;
            for (int i = 0; i < this.in.count(); ++i) {
                long v = this.in.valueAt(i);
                assert (v >= previous);
                previous = v;
            }
        }

        public long valueAt(int index) {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            assert (index < this.in.count());
            return this.in.valueAt(index);
        }

        public int count() {
            AssertingLeafReader.assertThread("Sorted numeric doc values", this.creationThread);
            return this.in.count();
        }
    }

    public static class AssertingSortedDocValues
    extends SortedDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final SortedDocValues in;
        private final int maxDoc;
        private final int valueCount;

        public AssertingSortedDocValues(SortedDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.valueCount = in.getValueCount();
            assert (this.valueCount >= 0 && this.valueCount <= maxDoc);
        }

        public int getOrd(int docID) {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            assert (docID >= 0 && docID < this.maxDoc);
            int ord = this.in.getOrd(docID);
            assert (ord >= -1 && ord < this.valueCount);
            return ord;
        }

        public BytesRef lookupOrd(int ord) {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            assert (ord >= 0 && ord < this.valueCount);
            BytesRef result = this.in.lookupOrd(ord);
            assert (result.isValid());
            return result;
        }

        public int getValueCount() {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            int valueCount = this.in.getValueCount();
            assert (valueCount == this.valueCount);
            return valueCount;
        }

        public BytesRef get(int docID) {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            assert (docID >= 0 && docID < this.maxDoc);
            BytesRef result = this.in.get(docID);
            assert (result.isValid());
            return result;
        }

        public int lookupTerm(BytesRef key) {
            AssertingLeafReader.assertThread("Sorted doc values", this.creationThread);
            assert (key.isValid());
            int result = this.in.lookupTerm(key);
            assert (result < this.valueCount);
            assert (key.isValid());
            return result;
        }
    }

    public static class AssertingBinaryDocValues
    extends BinaryDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final BinaryDocValues in;
        private final int maxDoc;

        public AssertingBinaryDocValues(BinaryDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public BytesRef get(int docID) {
            AssertingLeafReader.assertThread("Binary doc values", this.creationThread);
            assert (docID >= 0 && docID < this.maxDoc);
            BytesRef result = this.in.get(docID);
            assert (result.isValid());
            return result;
        }
    }

    public static class AssertingNumericDocValues
    extends NumericDocValues {
        private final Thread creationThread = Thread.currentThread();
        private final NumericDocValues in;
        private final int maxDoc;

        public AssertingNumericDocValues(NumericDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public long get(int docID) {
            AssertingLeafReader.assertThread("Numeric doc values", this.creationThread);
            assert (docID >= 0 && docID < this.maxDoc);
            return this.in.get(docID);
        }
    }

    public static class AssertingPostingsEnum
    extends FilterLeafReader.FilterPostingsEnum {
        private final Thread creationThread = Thread.currentThread();
        private DocsEnumState state = DocsEnumState.START;
        int positionCount = 0;
        int positionMax = 0;
        private int doc;

        public AssertingPostingsEnum(PostingsEnum in) {
            super(in);
            this.doc = in.docID();
        }

        public int nextDoc() throws IOException {
            AssertingLeafReader.assertThread("Docs enums", this.creationThread);
            assert (this.state != DocsEnumState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
            int nextDoc = super.nextDoc();
            assert (nextDoc > this.doc) : "backwards nextDoc from " + this.doc + " to " + nextDoc + " " + this.in;
            if (nextDoc == Integer.MAX_VALUE) {
                this.state = DocsEnumState.FINISHED;
                this.positionMax = 0;
            } else {
                this.state = DocsEnumState.ITERATING;
                this.positionMax = super.freq();
            }
            this.positionCount = 0;
            assert (super.docID() == nextDoc);
            this.doc = nextDoc;
            return this.doc;
        }

        public int advance(int target) throws IOException {
            AssertingLeafReader.assertThread("Docs enums", this.creationThread);
            assert (this.state != DocsEnumState.FINISHED) : "advance() called after NO_MORE_DOCS";
            assert (target > this.doc) : "target must be > docID(), got " + target + " <= " + this.doc;
            int advanced = super.advance(target);
            assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
            if (advanced == Integer.MAX_VALUE) {
                this.state = DocsEnumState.FINISHED;
                this.positionMax = 0;
            } else {
                this.state = DocsEnumState.ITERATING;
                this.positionMax = super.freq();
            }
            this.positionCount = 0;
            assert (super.docID() == advanced);
            this.doc = advanced;
            return this.doc;
        }

        public int docID() {
            AssertingLeafReader.assertThread("Docs enums", this.creationThread);
            assert (this.doc == super.docID()) : " invalid docID() in " + this.in.getClass() + " " + super.docID() + " instead of " + this.doc;
            return this.doc;
        }

        public int freq() throws IOException {
            AssertingLeafReader.assertThread("Docs enums", this.creationThread);
            assert (this.state != DocsEnumState.START) : "freq() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "freq() called after NO_MORE_DOCS";
            int freq = super.freq();
            assert (freq > 0);
            return freq;
        }

        public int nextPosition() throws IOException {
            assert (this.state != DocsEnumState.START) : "nextPosition() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "nextPosition() called after NO_MORE_DOCS";
            assert (this.positionCount < this.positionMax) : "nextPosition() called more than freq() times!";
            int position = super.nextPosition();
            assert (position >= 0 || position == -1) : "invalid position: " + position;
            ++this.positionCount;
            return position;
        }

        public int startOffset() throws IOException {
            assert (this.state != DocsEnumState.START) : "startOffset() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "startOffset() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "startOffset() called before nextPosition()!";
            return super.startOffset();
        }

        public int endOffset() throws IOException {
            assert (this.state != DocsEnumState.START) : "endOffset() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "endOffset() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "endOffset() called before nextPosition()!";
            return super.endOffset();
        }

        public BytesRef getPayload() throws IOException {
            assert (this.state != DocsEnumState.START) : "getPayload() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "getPayload() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "getPayload() called before nextPosition()!";
            BytesRef payload = super.getPayload();
            assert (payload == null || payload.length > 0) : "getPayload() returned payload with invalid length!";
            return payload;
        }

        void reset() {
            this.state = DocsEnumState.START;
            this.doc = this.in.docID();
            this.positionMax = 0;
            this.positionCount = 0;
        }
    }

    static enum DocsEnumState {
        START,
        ITERATING,
        FINISHED;

    }

    static class AssertingTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private final Thread creationThread = Thread.currentThread();
        private State state = State.INITIAL;
        private final boolean delegateOverridesSeekExact;

        public AssertingTermsEnum(TermsEnum in) {
            super(in);
            this.delegateOverridesSeekExact = SEEK_EXACT.isOverriddenAsOf(in.getClass());
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "docs(...) called on unpositioned TermsEnum";
            PostingsEnum actualReuse = reuse instanceof AssertingPostingsEnum ? ((AssertingPostingsEnum)reuse).in : null;
            PostingsEnum docs = super.postings(actualReuse, flags);
            assert (docs != null);
            if (docs == actualReuse) {
                ((AssertingPostingsEnum)reuse).reset();
                return reuse;
            }
            return new AssertingPostingsEnum(docs);
        }

        public BytesRef next() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.INITIAL || this.state == State.POSITIONED) : "next() called on unpositioned TermsEnum";
            BytesRef result = super.next();
            if (result == null) {
                this.state = State.UNPOSITIONED;
            } else {
                assert (result.isValid());
                this.state = State.POSITIONED;
            }
            return result;
        }

        public long ord() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "ord() called on unpositioned TermsEnum";
            return super.ord();
        }

        public int docFreq() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "docFreq() called on unpositioned TermsEnum";
            return super.docFreq();
        }

        public long totalTermFreq() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "totalTermFreq() called on unpositioned TermsEnum";
            return super.totalTermFreq();
        }

        public BytesRef term() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "term() called on unpositioned TermsEnum";
            BytesRef ret = super.term();
            assert (ret == null || ret.isValid());
            return ret;
        }

        public void seekExact(long ord) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            super.seekExact(ord);
            this.state = State.POSITIONED;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (term.isValid());
            TermsEnum.SeekStatus result = super.seekCeil(term);
            this.state = result == TermsEnum.SeekStatus.END ? State.UNPOSITIONED : State.POSITIONED;
            return result;
        }

        public boolean seekExact(BytesRef text) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (text.isValid());
            boolean result = this.delegateOverridesSeekExact ? this.in.seekExact(text) : super.seekExact(text);
            this.state = result ? State.POSITIONED : State.UNPOSITIONED;
            return result;
        }

        public TermState termState() throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (this.state == State.POSITIONED) : "termState() called on unpositioned TermsEnum";
            return this.in.termState();
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            AssertingLeafReader.assertThread("Terms enums", this.creationThread);
            assert (term.isValid());
            this.in.seekExact(term, state);
            this.state = State.POSITIONED;
        }

        public String toString() {
            return "AssertingTermsEnum(" + this.in + ")";
        }

        void reset() {
            this.state = State.INITIAL;
        }

        private static enum State {
            INITIAL,
            POSITIONED,
            UNPOSITIONED;

        }
    }

    public static class AssertingTerms
    extends FilterLeafReader.FilterTerms {
        public AssertingTerms(Terms in) {
            super(in);
        }

        public TermsEnum intersect(CompiledAutomaton automaton, BytesRef bytes) throws IOException {
            TermsEnum termsEnum = this.in.intersect(automaton, bytes);
            assert (termsEnum != null);
            assert (bytes == null || bytes.isValid());
            return new AssertingTermsEnum(termsEnum);
        }

        public BytesRef getMin() throws IOException {
            BytesRef v = this.in.getMin();
            assert (v == null || v.isValid());
            return v;
        }

        public BytesRef getMax() throws IOException {
            BytesRef v = this.in.getMax();
            assert (v == null || v.isValid());
            return v;
        }

        public TermsEnum iterator() throws IOException {
            TermsEnum termsEnum = super.iterator();
            assert (termsEnum != null);
            return new AssertingTermsEnum(termsEnum);
        }
    }

    public static class AssertingFields
    extends FilterLeafReader.FilterFields {
        public AssertingFields(Fields in) {
            super(in);
        }

        public Iterator<String> iterator() {
            Iterator iterator = super.iterator();
            assert (iterator != null);
            return iterator;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = super.terms(field);
            return terms == null ? null : new AssertingTerms(terms);
        }
    }
}

