/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.util.SloppyMath;

public class EarthDebugger {
    final StringBuilder b = new StringBuilder();
    private int nextShape;
    private boolean finished;
    private static double MAX_KM_PER_STEP = 100.0;

    public EarthDebugger() {
        this.b.append("<!DOCTYPE HTML>\n");
        this.b.append("<html>\n");
        this.b.append("  <head>\n");
        this.b.append("    <script src=\"http://www.webglearth.com/v2/api.js\"></script>\n");
        this.b.append("    <script>\n");
        this.b.append("      function initialize() {\n");
        this.b.append("        var earth = new WE.map('earth_div');\n");
    }

    public EarthDebugger(double centerLat, double centerLon, double altitudeMeters) {
        this.b.append("<!DOCTYPE HTML>\n");
        this.b.append("<html>\n");
        this.b.append("  <head>\n");
        this.b.append("    <script src=\"http://www.webglearth.com/v2/api.js\"></script>\n");
        this.b.append("    <script>\n");
        this.b.append("      function initialize() {\n");
        this.b.append("        var earth = new WE.map('earth_div', {center: [" + centerLat + ", " + centerLon + "], altitude: " + altitudeMeters + "});\n");
    }

    public void addPolygon(Polygon poly) {
        this.addPolygon(poly, "#00ff00");
    }

    public void addPolygon(Polygon poly, String color) {
        String name = "poly" + this.nextShape;
        ++this.nextShape;
        this.b.append("        var " + name + " = WE.polygon([\n");
        double[] polyLats = poly.getPolyLats();
        double[] polyLons = poly.getPolyLons();
        for (int i = 0; i < polyLats.length; ++i) {
            this.b.append("          [" + polyLats[i] + ", " + polyLons[i] + "],\n");
        }
        this.b.append("        ], {color: '" + color + "', fillColor: \"#000000\", fillOpacity: 0.0001});\n");
        this.b.append("        " + name + ".addTo(earth);\n");
        for (Polygon hole : poly.getHoles()) {
            this.addPolygon(hole, "#ffffff");
        }
    }

    private int getStepCount(double minLat, double maxLat, double minLon, double maxLon) {
        double distanceMeters = SloppyMath.haversinMeters((double)minLat, (double)minLon, (double)maxLat, (double)maxLon);
        return Math.max(1, (int)Math.round(distanceMeters / 1000.0 / MAX_KM_PER_STEP));
    }

    private void drawSegment(double minLat, double maxLat, double minLon, double maxLon) {
        int steps = this.getStepCount(minLat, maxLat, minLon, maxLon);
        for (int i = 0; i < steps; ++i) {
            this.b.append("          [" + (minLat + (maxLat - minLat) * (double)i / (double)steps) + ", " + (minLon + (maxLon - minLon) * (double)i / (double)steps) + "],\n");
        }
    }

    public void addRect(double minLat, double maxLat, double minLon, double maxLon) {
        this.addRect(minLat, maxLat, minLon, maxLon, "#ff0000");
    }

    public void addRect(double minLat, double maxLat, double minLon, double maxLon, String color) {
        String name = "rect" + this.nextShape;
        ++this.nextShape;
        this.b.append("        // lat: " + minLat + " TO " + maxLat + "; lon: " + minLon + " TO " + maxLon + "\n");
        this.b.append("        var " + name + " = WE.polygon([\n");
        this.b.append("          // min -> max lat, min lon\n");
        this.drawSegment(minLat, maxLat, minLon, minLon);
        this.b.append("          // max lat, min -> max lon\n");
        this.drawSegment(maxLat, maxLat, minLon, maxLon);
        this.b.append("          // max -> min lat, max lon\n");
        this.drawSegment(maxLat, minLat, maxLon, maxLon);
        this.b.append("          // min lat, max -> min lon\n");
        this.drawSegment(minLat, minLat, maxLon, minLon);
        this.b.append("          // min lat, min lon\n");
        this.b.append("          [" + minLat + ", " + minLon + "]\n");
        this.b.append("        ], {color: \"" + color + "\", fillColor: \"" + color + "\"});\n");
        this.b.append("        " + name + ".addTo(earth);\n");
    }

    public void addLatLine(double lat, double minLon, double maxLon) {
        double lon;
        String name = "latline" + this.nextShape;
        ++this.nextShape;
        this.b.append("        var " + name + " = WE.polygon([\n");
        int steps = this.getStepCount(lat, minLon, lat, maxLon);
        for (lon = minLon; lon <= maxLon; lon += (maxLon - minLon) / (double)steps) {
            this.b.append("          [" + lat + ", " + lon + "],\n");
        }
        this.b.append("          [" + lat + ", " + maxLon + "],\n");
        lon -= (maxLon - minLon) / (double)steps;
        while (lon >= minLon) {
            this.b.append("          [" + lat + ", " + lon + "],\n");
            lon -= (maxLon - minLon) / (double)steps;
        }
        this.b.append("        ], {color: \"#ff0000\", fillColor: \"#ffffff\", opacity: 1, fillOpacity: 0.0001});\n");
        this.b.append("        " + name + ".addTo(earth);\n");
    }

    public void addLonLine(double minLat, double maxLat, double lon) {
        double lat;
        String name = "lonline" + this.nextShape;
        ++this.nextShape;
        this.b.append("        var " + name + " = WE.polygon([\n");
        int steps = this.getStepCount(minLat, lon, maxLat, lon);
        for (lat = minLat; lat <= maxLat; lat += (maxLat - minLat) / (double)steps) {
            this.b.append("          [" + lat + ", " + lon + "],\n");
        }
        this.b.append("          [" + maxLat + ", " + lon + "],\n");
        lat -= (maxLat - minLat) / 36.0;
        while (lat >= minLat) {
            this.b.append("          [" + lat + ", " + lon + "],\n");
            lat -= (maxLat - minLat) / (double)steps;
        }
        this.b.append("        ], {color: \"#ff0000\", fillColor: \"#ffffff\", opacity: 1, fillOpacity: 0.0001});\n");
        this.b.append("        " + name + ".addTo(earth);\n");
    }

    public void addPoint(double lat, double lon) {
        this.b.append("        WE.marker([" + lat + ", " + lon + "]).addTo(earth);\n");
    }

    public void addCircle(double centerLat, double centerLon, double radiusMeters, boolean alsoAddBBox) {
        this.addPoint(centerLat, centerLon);
        String name = "circle" + this.nextShape;
        ++this.nextShape;
        this.b.append("        var " + name + " = WE.polygon([\n");
        EarthDebugger.inverseHaversin(this.b, centerLat, centerLon, radiusMeters);
        this.b.append("        ], {color: '#00ff00', fillColor: \"#000000\", fillOpacity: 0.0001 });\n");
        this.b.append("        " + name + ".addTo(earth);\n");
        if (alsoAddBBox) {
            Rectangle box = Rectangle.fromPointDistance((double)centerLat, (double)centerLon, (double)radiusMeters);
            this.addRect(box.minLat, box.maxLat, box.minLon, box.maxLon);
            this.addLatLine(Rectangle.axisLat((double)centerLat, (double)radiusMeters), box.minLon, box.maxLon);
        }
    }

    public String finish() {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.b.append("        WE.tileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',{\n");
        this.b.append("          attribution: '\u00a9 OpenStreetMap contributors'\n");
        this.b.append("        }).addTo(earth);\n");
        this.b.append("      }\n");
        this.b.append("    </script>\n");
        this.b.append("    <style>\n");
        this.b.append("      html, body{padding: 0; margin: 0;}\n");
        this.b.append("      #earth_div{top: 0; right: 0; bottom: 0; left: 0; position: absolute !important;}\n");
        this.b.append("    </style>\n");
        this.b.append("    <title>WebGL Earth API: Hello World</title>\n");
        this.b.append("  </head>\n");
        this.b.append("  <body onload=\"initialize()\">\n");
        this.b.append("    <div id=\"earth_div\"></div>\n");
        this.b.append("  </body>\n");
        this.b.append("</html>\n");
        return this.b.toString();
    }

    private static void inverseHaversin(StringBuilder b, double centerLat, double centerLon, double radiusMeters) {
        double angle = 0.0;
        int steps = 100;
        block0: while (angle < 360.0) {
            double lon;
            double lat;
            double x = Math.cos(Math.toRadians(angle));
            double y = Math.sin(Math.toRadians(angle));
            double factor = 2.0;
            double step = 1.0;
            int last = 0;
            double lastDistanceMeters = 0.0;
            while (true) {
                lat = EarthDebugger.wrapLat(centerLat + y * factor);
                lon = EarthDebugger.wrapLon(centerLon + x * factor);
                double distanceMeters = SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)lat, (double)lon);
                if (last == 1 && distanceMeters < lastDistanceMeters) {
                    angle += 360.0 / (double)steps;
                    continue block0;
                }
                if (last == -1 && distanceMeters > lastDistanceMeters) {
                    angle += 360.0 / (double)steps;
                    continue block0;
                }
                lastDistanceMeters = distanceMeters;
                if (Math.abs(distanceMeters - radiusMeters) < 0.1) break;
                if (distanceMeters > radiusMeters) {
                    factor -= step;
                    if (last == 1) {
                        step /= 2.0;
                    }
                    last = -1;
                    continue;
                }
                if (!(distanceMeters < radiusMeters)) continue;
                factor += step;
                if (last == -1) {
                    step /= 2.0;
                }
                last = 1;
            }
            b.append("          [" + lat + ", " + lon + "],\n");
            angle += 360.0 / (double)steps;
        }
    }

    private static double wrapLat(double lat) {
        if (lat > 90.0) {
            return 180.0 - lat;
        }
        if (lat < -90.0) {
            return -180.0 - lat;
        }
        return lat;
    }

    private static double wrapLon(double lon) {
        if (lon > 180.0) {
            return lon - 360.0;
        }
        if (lon < -180.0) {
            return lon + 360.0;
        }
        return lon;
    }
}

