/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import com.carrotsearch.randomizedtesting.generators.RandomInts;
import java.util.Random;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsFormat;
import org.apache.lucene.codecs.compressing.CompressingTermVectorsFormat;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.FastCompressingCodec;
import org.apache.lucene.codecs.compressing.FastDecompressionCompressingCodec;
import org.apache.lucene.codecs.compressing.HighCompressionCompressingCodec;
import org.apache.lucene.codecs.compressing.dummy.DummyCompressingCodec;
import org.apache.lucene.util.TestUtil;

public abstract class CompressingCodec
extends FilterCodec {
    private final CompressingStoredFieldsFormat storedFieldsFormat;
    private final CompressingTermVectorsFormat termVectorsFormat;

    public static CompressingCodec randomInstance(Random random, int chunkSize, int maxDocsPerChunk, boolean withSegmentSuffix, int blockSize) {
        switch (random.nextInt(4)) {
            case 0: {
                return new FastCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockSize);
            }
            case 1: {
                return new FastDecompressionCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockSize);
            }
            case 2: {
                return new HighCompressionCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockSize);
            }
            case 3: {
                return new DummyCompressingCodec(chunkSize, maxDocsPerChunk, withSegmentSuffix, blockSize);
            }
        }
        throw new AssertionError();
    }

    public static CompressingCodec randomInstance(Random random) {
        int chunkSize = random.nextBoolean() ? RandomInts.randomIntBetween((Random)random, (int)1, (int)10) : RandomInts.randomIntBetween((Random)random, (int)1, (int)32768);
        int chunkDocs = random.nextBoolean() ? RandomInts.randomIntBetween((Random)random, (int)1, (int)10) : RandomInts.randomIntBetween((Random)random, (int)64, (int)1024);
        int blockSize = random.nextBoolean() ? RandomInts.randomIntBetween((Random)random, (int)1, (int)10) : RandomInts.randomIntBetween((Random)random, (int)1, (int)1024);
        return CompressingCodec.randomInstance(random, chunkSize, chunkDocs, false, blockSize);
    }

    public static CompressingCodec reasonableInstance(Random random) {
        int chunkSize = TestUtil.nextInt(random, 8192, 131072);
        int chunkDocs = TestUtil.nextInt(random, 64, 1024);
        int blockSize = TestUtil.nextInt(random, 512, 2048);
        return CompressingCodec.randomInstance(random, chunkSize, chunkDocs, false, blockSize);
    }

    public static CompressingCodec randomInstance(Random random, boolean withSegmentSuffix) {
        return CompressingCodec.randomInstance(random, RandomInts.randomIntBetween((Random)random, (int)1, (int)32768), RandomInts.randomIntBetween((Random)random, (int)64, (int)1024), withSegmentSuffix, RandomInts.randomIntBetween((Random)random, (int)1, (int)1024));
    }

    public CompressingCodec(String name, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockSize) {
        super(name, TestUtil.getDefaultCodec());
        this.storedFieldsFormat = new CompressingStoredFieldsFormat(name, segmentSuffix, compressionMode, chunkSize, maxDocsPerChunk, blockSize);
        this.termVectorsFormat = new CompressingTermVectorsFormat(name, segmentSuffix, compressionMode, chunkSize, blockSize);
    }

    public CompressingCodec(String name, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockSize) {
        this(name, "", compressionMode, chunkSize, maxDocsPerChunk, blockSize);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public TermVectorsFormat termVectorsFormat() {
        return this.termVectorsFormat;
    }

    public String toString() {
        return this.getName() + "(storedFieldsFormat=" + this.storedFieldsFormat + ", termVectorsFormat=" + this.termVectorsFormat + ")";
    }
}

