/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.AssertingLeafReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.TestUtil;

public class AssertingNormsFormat
extends NormsFormat {
    private final NormsFormat in = TestUtil.getDefaultCodec().normsFormat();

    public NormsConsumer normsConsumer(SegmentWriteState state) throws IOException {
        NormsConsumer consumer = this.in.normsConsumer(state);
        assert (consumer != null);
        return new AssertingNormsConsumer(consumer, state.segmentInfo.maxDoc());
    }

    public NormsProducer normsProducer(SegmentReadState state) throws IOException {
        assert (state.fieldInfos.hasNorms());
        NormsProducer producer = this.in.normsProducer(state);
        assert (producer != null);
        return new AssertingNormsProducer(producer, state.segmentInfo.maxDoc());
    }

    static class AssertingNormsProducer
    extends NormsProducer {
        private final NormsProducer in;
        private final int maxDoc;

        AssertingNormsProducer(NormsProducer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            assert (this.toString() != null);
            assert (this.ramBytesUsed() >= 0L);
            assert (this.getChildResources() != null);
        }

        public NumericDocValues getNorms(FieldInfo field) throws IOException {
            assert (field.hasNorms());
            NumericDocValues values = this.in.getNorms(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingNumericDocValues(values, this.maxDoc);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public long ramBytesUsed() {
            long v = this.in.ramBytesUsed();
            assert (v >= 0L);
            return v;
        }

        public Collection<Accountable> getChildResources() {
            Collection res = this.in.getChildResources();
            TestUtil.checkReadOnly(res);
            return res;
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public NormsProducer getMergeInstance() throws IOException {
            return new AssertingNormsProducer(this.in.getMergeInstance(), this.maxDoc);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }
    }

    static class AssertingNormsConsumer
    extends NormsConsumer {
        private final NormsConsumer in;
        private final int maxDoc;

        AssertingNormsConsumer(NormsConsumer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void addNormsField(FieldInfo field, Iterable<Number> values) throws IOException {
            int count = 0;
            for (Number v : values) {
                assert (v != null);
                ++count;
            }
            assert (count == this.maxDoc);
            TestUtil.checkIterator(values.iterator(), this.maxDoc, false);
            this.in.addNormsField(field, values);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }
    }
}

