/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.asserting.AssertingCodec;
import org.apache.lucene.codecs.cheapbastard.CheapBastardCodec;
import org.apache.lucene.codecs.compressing.CompressingCodec;
import org.apache.lucene.codecs.lucene3x.PreFlexRWCodec;
import org.apache.lucene.codecs.lucene40.Lucene40RWCodec;
import org.apache.lucene.codecs.lucene40.Lucene40RWPostingsFormat;
import org.apache.lucene.codecs.lucene41.Lucene41RWCodec;
import org.apache.lucene.codecs.lucene42.Lucene42RWCodec;
import org.apache.lucene.codecs.lucene45.Lucene45RWCodec;
import org.apache.lucene.codecs.lucene46.Lucene46RWCodec;
import org.apache.lucene.codecs.lucene49.Lucene49Codec;
import org.apache.lucene.codecs.mockrandom.MockRandomPostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextCodec;
import org.apache.lucene.index.RandomCodec;
import org.apache.lucene.search.RandomSimilarityProvider;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.AbstractBeforeAfterRule;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NullInfoStream;
import org.apache.lucene.util.PrintStreamInfoStream;
import org.junit.internal.AssumptionViolatedException;

final class TestRuleSetupAndRestoreClassEnv
extends AbstractBeforeAfterRule {
    private HashMap<String, String> restoreProperties = new HashMap();
    private Codec savedCodec;
    private Locale savedLocale;
    private TimeZone savedTimeZone;
    private InfoStream savedInfoStream;
    Locale locale;
    TimeZone timeZone;
    Similarity similarity;
    Codec codec;
    HashSet<String> avoidCodecs;

    TestRuleSetupAndRestoreClassEnv() {
    }

    @Override
    protected void before() throws Exception {
        LuceneTestCase.LiveIWCFlushMode flushMode;
        this.restoreProperties.put("solr.directoryFactory", System.getProperty("solr.directoryFactory"));
        if (System.getProperty("solr.directoryFactory") == null) {
            System.setProperty("solr.directoryFactory", "org.apache.solr.core.MockDirectoryFactory");
        }
        this.restoreProperties.put("solr.solr.home", System.getProperty("solr.solr.home"));
        this.restoreProperties.put("solr.data.dir", System.getProperty("solr.data.dir"));
        if (LuceneTestCase.VERBOSE) {
            Set codecs = Codec.availableCodecs();
            for (Object codec : codecs) {
                System.out.println("Loaded codec: '" + (String)codec + "': " + Codec.forName((String)codec).getClass().getName());
            }
            Set postingsFormats = PostingsFormat.availablePostingsFormats();
            for (String postingsFormat : postingsFormats) {
                System.out.println("Loaded postingsFormat: '" + postingsFormat + "': " + PostingsFormat.forName((String)postingsFormat).getClass().getName());
            }
        }
        this.savedInfoStream = InfoStream.getDefault();
        Random random = RandomizedContext.current().getRandom();
        boolean v = random.nextBoolean();
        if (LuceneTestCase.INFOSTREAM) {
            InfoStream.setDefault((InfoStream)new ThreadNameFixingPrintStreamInfoStream(System.out));
        } else if (v) {
            InfoStream.setDefault((InfoStream)new NullInfoStream());
        }
        Class targetClass = RandomizedContext.current().getTargetClass();
        this.avoidCodecs = new HashSet();
        if (targetClass.isAnnotationPresent(LuceneTestCase.SuppressCodecs.class)) {
            LuceneTestCase.SuppressCodecs a = targetClass.getAnnotation(LuceneTestCase.SuppressCodecs.class);
            this.avoidCodecs.addAll(Arrays.asList(a.value()));
        }
        LuceneTestCase.OLD_FORMAT_IMPERSONATION_IS_ACTIVE = false;
        this.savedCodec = Codec.getDefault();
        int randomVal = random.nextInt(12);
        if ("Lucene3x".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && "random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) && "random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT) && randomVal == 10 && !this.shouldAvoidCodec("Lucene3x")) {
            this.codec = Codec.forName((String)"Lucene3x");
            assert (this.codec instanceof PreFlexRWCodec) : "fix your classpath to have tests-framework.jar before lucene-core.jar";
            LuceneTestCase.OLD_FORMAT_IMPERSONATION_IS_ACTIVE = true;
        } else if ("Lucene40".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && "random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) && randomVal == 0 && !this.shouldAvoidCodec("Lucene40")) {
            this.codec = Codec.forName((String)"Lucene40");
            LuceneTestCase.OLD_FORMAT_IMPERSONATION_IS_ACTIVE = true;
            assert (this.codec instanceof Lucene40RWCodec) : "fix your classpath to have tests-framework.jar before lucene-core.jar";
            assert (PostingsFormat.forName((String)"Lucene40") instanceof Lucene40RWPostingsFormat) : "fix your classpath to have tests-framework.jar before lucene-core.jar";
        } else if ("Lucene41".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && "random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) && "random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT) && randomVal == 1 && !this.shouldAvoidCodec("Lucene41")) {
            this.codec = Codec.forName((String)"Lucene41");
            LuceneTestCase.OLD_FORMAT_IMPERSONATION_IS_ACTIVE = true;
            assert (this.codec instanceof Lucene41RWCodec) : "fix your classpath to have tests-framework.jar before lucene-core.jar";
        } else if ("Lucene42".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && "random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) && "random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT) && randomVal == 2 && !this.shouldAvoidCodec("Lucene42")) {
            this.codec = Codec.forName((String)"Lucene42");
            LuceneTestCase.OLD_FORMAT_IMPERSONATION_IS_ACTIVE = true;
            assert (this.codec instanceof Lucene42RWCodec) : "fix your classpath to have tests-framework.jar before lucene-core.jar";
        } else if ("Lucene45".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && "random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) && "random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT) && randomVal == 3 && !this.shouldAvoidCodec("Lucene45")) {
            this.codec = Codec.forName((String)"Lucene45");
            LuceneTestCase.OLD_FORMAT_IMPERSONATION_IS_ACTIVE = true;
            assert (this.codec instanceof Lucene45RWCodec) : "fix your classpath to have tests-framework.jar before lucene-core.jar";
        } else if ("Lucene46".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && "random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) && "random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT) && randomVal == 4 && !this.shouldAvoidCodec("Lucene46")) {
            this.codec = Codec.forName((String)"Lucene46");
            LuceneTestCase.OLD_FORMAT_IMPERSONATION_IS_ACTIVE = true;
            assert (this.codec instanceof Lucene46RWCodec) : "fix your classpath to have tests-framework.jar before lucene-core.jar";
        } else if (!"random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) || !"random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT)) {
            Object format = "random".equals(LuceneTestCase.TEST_POSTINGSFORMAT) ? PostingsFormat.forName((String)"Lucene41") : ("MockRandom".equals(LuceneTestCase.TEST_POSTINGSFORMAT) ? new MockRandomPostingsFormat(new Random(random.nextLong())) : PostingsFormat.forName((String)LuceneTestCase.TEST_POSTINGSFORMAT));
            DocValuesFormat dvFormat = "random".equals(LuceneTestCase.TEST_DOCVALUESFORMAT) ? DocValuesFormat.forName((String)"Lucene49") : DocValuesFormat.forName((String)LuceneTestCase.TEST_DOCVALUESFORMAT);
            this.codec = new Lucene49Codec((PostingsFormat)format, dvFormat){
                final /* synthetic */ PostingsFormat val$format;
                final /* synthetic */ DocValuesFormat val$dvFormat;
                {
                    this.val$format = postingsFormat;
                    this.val$dvFormat = docValuesFormat;
                }

                public PostingsFormat getPostingsFormatForField(String field) {
                    return this.val$format;
                }

                public DocValuesFormat getDocValuesFormatForField(String field) {
                    return this.val$dvFormat;
                }

                public String toString() {
                    return super.toString() + ": " + this.val$format.toString() + ", " + this.val$dvFormat.toString();
                }
            };
        } else if ("SimpleText".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 9 && LuceneTestCase.rarely(random) && !this.shouldAvoidCodec("SimpleText")) {
            this.codec = new SimpleTextCodec();
        } else if ("CheapBastard".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 8 && !this.shouldAvoidCodec("CheapBastard") && !this.shouldAvoidCodec("Lucene41")) {
            this.codec = new CheapBastardCodec();
        } else if ("Asserting".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 6 && !this.shouldAvoidCodec("Asserting")) {
            this.codec = new AssertingCodec();
        } else if ("Compressing".equals(LuceneTestCase.TEST_CODEC) || "random".equals(LuceneTestCase.TEST_CODEC) && randomVal == 5 && !this.shouldAvoidCodec("Compressing")) {
            this.codec = CompressingCodec.randomInstance(random);
        } else if (!"random".equals(LuceneTestCase.TEST_CODEC)) {
            this.codec = Codec.forName((String)LuceneTestCase.TEST_CODEC);
        } else if ("random".equals(LuceneTestCase.TEST_POSTINGSFORMAT)) {
            this.codec = new RandomCodec(random, this.avoidCodecs);
        } else assert (false);
        Codec.setDefault((Codec)this.codec);
        String testLocale = System.getProperty("tests.locale", "random");
        String testTimeZone = System.getProperty("tests.timezone", "random");
        this.savedLocale = Locale.getDefault();
        Locale randomLocale = LuceneTestCase.randomLocale(random);
        this.locale = testLocale.equals("random") ? randomLocale : LuceneTestCase.localeForName(testLocale);
        Locale.setDefault(this.locale);
        this.restoreProperties.put("user.timezone", System.getProperty("user.timezone"));
        this.savedTimeZone = TimeZone.getDefault();
        TimeZone randomTimeZone = LuceneTestCase.randomTimeZone(LuceneTestCase.random());
        this.timeZone = testTimeZone.equals("random") ? randomTimeZone : TimeZone.getTimeZone(testTimeZone);
        TimeZone.setDefault(this.timeZone);
        this.similarity = LuceneTestCase.random().nextBoolean() ? new DefaultSimilarity() : new RandomSimilarityProvider(LuceneTestCase.random());
        try {
            this.checkCodecRestrictions(this.codec);
        }
        catch (AssumptionViolatedException e) {
            System.err.println("NOTE: " + e.getMessage() + " Suppressed codecs: " + Arrays.toString(this.avoidCodecs.toArray()));
            throw e;
        }
        switch (LuceneTestCase.random().nextInt(3)) {
            case 0: {
                flushMode = LuceneTestCase.LiveIWCFlushMode.BY_RAM;
                break;
            }
            case 1: {
                flushMode = LuceneTestCase.LiveIWCFlushMode.BY_DOCS;
                break;
            }
            case 2: {
                flushMode = LuceneTestCase.LiveIWCFlushMode.EITHER;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        LuceneTestCase.setLiveIWCFlushMode(flushMode);
    }

    private void checkCodecRestrictions(Codec codec) {
        LuceneTestCase.assumeFalse("Class not allowed to use codec: " + codec.getName() + ".", this.shouldAvoidCodec(codec.getName()));
        if (codec instanceof RandomCodec && !this.avoidCodecs.isEmpty()) {
            for (String name : ((RandomCodec)codec).formatNames) {
                LuceneTestCase.assumeFalse("Class not allowed to use postings format: " + name + ".", this.shouldAvoidCodec(name));
            }
        }
        PostingsFormat pf = codec.postingsFormat();
        LuceneTestCase.assumeFalse("Class not allowed to use postings format: " + pf.getName() + ".", this.shouldAvoidCodec(pf.getName()));
        LuceneTestCase.assumeFalse("Class not allowed to use postings format: " + LuceneTestCase.TEST_POSTINGSFORMAT + ".", this.shouldAvoidCodec(LuceneTestCase.TEST_POSTINGSFORMAT));
    }

    @Override
    protected void after() throws Exception {
        for (Map.Entry<String, String> e : this.restoreProperties.entrySet()) {
            if (e.getValue() == null) {
                System.clearProperty(e.getKey());
                continue;
            }
            System.setProperty(e.getKey(), e.getValue());
        }
        this.restoreProperties.clear();
        Codec.setDefault((Codec)this.savedCodec);
        InfoStream.setDefault((InfoStream)this.savedInfoStream);
        if (this.savedLocale != null) {
            Locale.setDefault(this.savedLocale);
        }
        if (this.savedTimeZone != null) {
            TimeZone.setDefault(this.savedTimeZone);
        }
    }

    private boolean shouldAvoidCodec(String codec) {
        return !this.avoidCodecs.isEmpty() && this.avoidCodecs.contains(codec);
    }

    static class ThreadNameFixingPrintStreamInfoStream
    extends PrintStreamInfoStream {
        public ThreadNameFixingPrintStreamInfoStream(PrintStream out) {
            super(out);
        }

        public void message(String component, String message) {
            if ("TP".equals(component)) {
                return;
            }
            String name = Thread.currentThread().getName().startsWith("TEST-") ? "main" : Thread.currentThread().getName();
            this.stream.println(component + " " + this.messageID + " [" + new Date() + "; " + name + "]: " + message);
        }
    }
}

