/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;

public class TestRuleLimitSysouts
extends TestRuleAdapter {
    public static final int DEFAULT_SYSOUT_BYTES_THRESHOLD = 8192;
    private static final AtomicInteger bytesWritten = new AtomicInteger();
    private static final DelegateStream capturedSystemOut;
    private static final DelegateStream capturedSystemErr;
    private final TestRuleMarkFailure failureMarker;

    public TestRuleLimitSysouts(TestRuleMarkFailure failureMarker) {
        this.failureMarker = failureMarker;
    }

    protected void before() throws Throwable {
        if (this.isEnforced()) {
            TestRuleLimitSysouts.checkCaptureStreams();
        }
        this.resetCaptureState();
        this.validateClassAnnotations();
    }

    private void validateClassAnnotations() {
        int bytes;
        Class target = RandomizedTest.getContext().getTargetClass();
        if (target.isAnnotationPresent(Limit.class) && ((bytes = target.getAnnotation(Limit.class).bytes()) < 0 || bytes > 0x100000)) {
            throw new AssertionError((Object)("The sysout limit is insane. Did you want to use @" + LuceneTestCase.SuppressSysoutChecks.class.getName() + " annotation to " + "avoid sysout checks entirely?"));
        }
    }

    public static void checkCaptureStreams() {
        if (System.out != TestRuleLimitSysouts.capturedSystemOut.printStream) {
            throw new AssertionError((Object)("Something has changed System.out to: " + System.out.getClass().getName()));
        }
        if (System.err != TestRuleLimitSysouts.capturedSystemErr.printStream) {
            throw new AssertionError((Object)("Something has changed System.err to: " + System.err.getClass().getName()));
        }
    }

    protected boolean isEnforced() {
        Class target = RandomizedTest.getContext().getTargetClass();
        if (LuceneTestCase.VERBOSE || LuceneTestCase.INFOSTREAM || target.isAnnotationPresent(LuceneTestCase.SuppressSysoutChecks.class)) {
            return false;
        }
        return target.isAnnotationPresent(Limit.class);
    }

    protected void afterIfSuccessful() throws Throwable {
        if (this.isEnforced()) {
            TestRuleLimitSysouts.checkCaptureStreams();
            TestRuleLimitSysouts.capturedSystemOut.printStream.flush();
            TestRuleLimitSysouts.capturedSystemErr.printStream.flush();
            int limit = RandomizedTest.getContext().getTargetClass().getAnnotation(Limit.class).bytes();
            if (bytesWritten.get() >= limit && this.failureMarker.wasSuccessful()) {
                throw new AssertionError((Object)String.format(Locale.ENGLISH, "The test or suite printed %d bytes to stdout and stderr, even though the limit was set to %d bytes. Increase the limit with @%s, ignore it completely with @%s or run with -Dtests.verbose=true", bytesWritten.get(), limit, Limit.class.getSimpleName(), LuceneTestCase.SuppressSysoutChecks.class.getSimpleName()));
            }
        }
    }

    protected void afterAlways(List<Throwable> errors) throws Throwable {
        this.resetCaptureState();
    }

    private void resetCaptureState() {
        TestRuleLimitSysouts.capturedSystemOut.printStream.flush();
        TestRuleLimitSysouts.capturedSystemErr.printStream.flush();
        bytesWritten.set(0);
    }

    static {
        System.out.flush();
        System.err.flush();
        String csn = Charset.defaultCharset().name();
        capturedSystemOut = new DelegateStream(System.out, csn, bytesWritten);
        capturedSystemErr = new DelegateStream(System.err, csn, bytesWritten);
        System.setOut(TestRuleLimitSysouts.capturedSystemOut.printStream);
        System.setErr(TestRuleLimitSysouts.capturedSystemErr.printStream);
    }

    static class DelegateStream
    extends FilterOutputStream {
        final PrintStream printStream;
        final AtomicInteger bytesCounter;

        public DelegateStream(OutputStream delegate, String charset, AtomicInteger bytesCounter) {
            super(delegate);
            try {
                this.printStream = new PrintStream((OutputStream)this, true, charset);
                this.bytesCounter = bytesCounter;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (b.length > 0) {
                this.bytesCounter.addAndGet(b.length);
            }
            super.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                this.bytesCounter.addAndGet(len);
            }
            super.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.bytesCounter.incrementAndGet();
            super.write(b);
        }
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Limit {
        public int bytes();
    }
}

