/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

final class PreFlexRWStoredFieldsWriter
extends StoredFieldsWriter {
    private final Directory directory;
    private final String segment;
    private IndexOutput fieldsStream;
    private IndexOutput indexStream;
    private final RAMOutputStream fieldsBuffer = new RAMOutputStream();
    int numStoredFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreFlexRWStoredFieldsWriter(Directory directory, String segment, IOContext context) throws IOException {
        assert (directory != null);
        this.directory = directory;
        this.segment = segment;
        boolean success = false;
        try {
            this.fieldsStream = directory.createOutput(IndexFileNames.segmentFileName((String)segment, (String)"", (String)"fdt"), context);
            this.indexStream = directory.createOutput(IndexFileNames.segmentFileName((String)segment, (String)"", (String)"fdx"), context);
            this.fieldsStream.writeInt(3);
            this.indexStream.writeInt(3);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    public void startDocument() throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
    }

    public void finishDocument() throws IOException {
        this.fieldsStream.writeVInt(this.numStoredFields);
        this.fieldsBuffer.writeTo((DataOutput)this.fieldsStream);
        this.fieldsBuffer.reset();
        this.numStoredFields = 0;
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.fieldsStream, this.indexStream});
        }
        finally {
            this.indexStream = null;
            this.fieldsStream = null;
        }
    }

    public void abort() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IOUtils.deleteFilesIgnoringExceptions((Directory)this.directory, (String[])new String[]{IndexFileNames.segmentFileName((String)this.segment, (String)"", (String)"fdt"), IndexFileNames.segmentFileName((String)this.segment, (String)"", (String)"fdx")});
    }

    public void writeField(FieldInfo info, IndexableField field) throws IOException {
        BytesRef bytes;
        String string;
        ++this.numStoredFields;
        this.fieldsBuffer.writeVInt(info.number);
        int bits = 0;
        Number number = field.numericValue();
        if (number != null) {
            if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
                bits |= 8;
            } else if (number instanceof Long) {
                bits |= 0x10;
            } else if (number instanceof Float) {
                bits |= 0x18;
            } else if (number instanceof Double) {
                bits |= 0x20;
            } else {
                throw new IllegalArgumentException("cannot store numeric type " + number.getClass());
            }
            string = null;
            bytes = null;
        } else {
            bytes = field.binaryValue();
            if (bytes != null) {
                bits |= 2;
                string = null;
            } else {
                string = field.stringValue();
                if (string == null) {
                    throw new IllegalArgumentException("field " + field.name() + " is stored but does not have binaryValue, stringValue nor numericValue");
                }
            }
        }
        this.fieldsBuffer.writeByte((byte)bits);
        if (bytes != null) {
            this.fieldsBuffer.writeVInt(bytes.length);
            this.fieldsBuffer.writeBytes(bytes.bytes, bytes.offset, bytes.length);
        } else if (string != null) {
            this.fieldsBuffer.writeString(field.stringValue());
        } else if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            this.fieldsBuffer.writeInt(number.intValue());
        } else if (number instanceof Long) {
            this.fieldsBuffer.writeLong(number.longValue());
        } else if (number instanceof Float) {
            this.fieldsBuffer.writeInt(Float.floatToIntBits(number.floatValue()));
        } else if (number instanceof Double) {
            this.fieldsBuffer.writeLong(Double.doubleToLongBits(number.doubleValue()));
        } else assert (false);
    }

    public void finish(FieldInfos fis, int numDocs) throws IOException {
        if (4L + (long)numDocs * 8L != this.indexStream.getFilePointer()) {
            throw new RuntimeException("fdx size mismatch: docCount is " + numDocs + " but fdx file size is " + this.indexStream.getFilePointer() + " file=" + this.indexStream.toString() + "; now aborting this merge to prevent index corruption");
        }
    }
}

