/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.asserting.AssertingDocValuesFormat;
import org.apache.lucene.codecs.asserting.AssertingPostingsFormat;
import org.apache.lucene.codecs.bloom.TestBloomFilteredLucene41Postings;
import org.apache.lucene.codecs.diskdv.DiskDocValuesFormat;
import org.apache.lucene.codecs.lucene41.Lucene41PostingsFormat;
import org.apache.lucene.codecs.lucene41ords.Lucene41WithOrds;
import org.apache.lucene.codecs.lucene45.Lucene45DocValuesFormat;
import org.apache.lucene.codecs.lucene46.Lucene46Codec;
import org.apache.lucene.codecs.memory.DirectPostingsFormat;
import org.apache.lucene.codecs.memory.FSTOrdPostingsFormat;
import org.apache.lucene.codecs.memory.FSTOrdPulsing41PostingsFormat;
import org.apache.lucene.codecs.memory.FSTPostingsFormat;
import org.apache.lucene.codecs.memory.FSTPulsing41PostingsFormat;
import org.apache.lucene.codecs.memory.MemoryDocValuesFormat;
import org.apache.lucene.codecs.memory.MemoryPostingsFormat;
import org.apache.lucene.codecs.mockintblock.MockFixedIntBlockPostingsFormat;
import org.apache.lucene.codecs.mockintblock.MockVariableIntBlockPostingsFormat;
import org.apache.lucene.codecs.mockrandom.MockRandomPostingsFormat;
import org.apache.lucene.codecs.mocksep.MockSepPostingsFormat;
import org.apache.lucene.codecs.nestedpulsing.NestedPulsingPostingsFormat;
import org.apache.lucene.codecs.pulsing.Pulsing41PostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextPostingsFormat;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public class RandomCodec
extends Lucene46Codec {
    private List<PostingsFormat> formats = new ArrayList<PostingsFormat>();
    private List<DocValuesFormat> dvFormats = new ArrayList<DocValuesFormat>();
    public Set<String> formatNames = new HashSet<String>();
    public Set<String> dvFormatNames = new HashSet<String>();
    private Map<String, PostingsFormat> previousMappings = Collections.synchronizedMap(new HashMap());
    private Map<String, DocValuesFormat> previousDVMappings = Collections.synchronizedMap(new HashMap());
    private final int perFieldSeed;

    public PostingsFormat getPostingsFormatForField(String name) {
        PostingsFormat codec = this.previousMappings.get(name);
        if (codec == null) {
            codec = this.formats.get(Math.abs(this.perFieldSeed ^ name.hashCode()) % this.formats.size());
            if (codec instanceof SimpleTextPostingsFormat && this.perFieldSeed % 5 != 0) {
                codec = this.formats.get(Math.abs(this.perFieldSeed ^ name.toUpperCase(Locale.ROOT).hashCode()) % this.formats.size());
            }
            this.previousMappings.put(name, codec);
            assert (this.previousMappings.size() < 10000) : "test went insane";
        }
        return codec;
    }

    public DocValuesFormat getDocValuesFormatForField(String name) {
        DocValuesFormat codec = this.previousDVMappings.get(name);
        if (codec == null) {
            codec = this.dvFormats.get(Math.abs(this.perFieldSeed ^ name.hashCode()) % this.dvFormats.size());
            if (codec instanceof SimpleTextDocValuesFormat && this.perFieldSeed % 5 != 0) {
                codec = this.dvFormats.get(Math.abs(this.perFieldSeed ^ name.toUpperCase(Locale.ROOT).hashCode()) % this.dvFormats.size());
            }
            this.previousDVMappings.put(name, codec);
            assert (this.previousDVMappings.size() < 10000) : "test went insane";
        }
        return codec;
    }

    public RandomCodec(Random random, Set<String> avoidCodecs) {
        this.perFieldSeed = random.nextInt();
        int minItemsPerBlock = TestUtil.nextInt(random, 2, 100);
        int maxItemsPerBlock = 2 * Math.max(2, minItemsPerBlock - 1) + random.nextInt(100);
        int lowFreqCutoff = TestUtil.nextInt(random, 2, 100);
        this.add(avoidCodecs, new PostingsFormat[]{new Lucene41PostingsFormat(minItemsPerBlock, maxItemsPerBlock), new FSTPostingsFormat(), new FSTOrdPostingsFormat(), new FSTPulsing41PostingsFormat(1 + random.nextInt(20)), new FSTOrdPulsing41PostingsFormat(1 + random.nextInt(20)), new DirectPostingsFormat(LuceneTestCase.rarely(random) ? 1 : (LuceneTestCase.rarely(random) ? Integer.MAX_VALUE : maxItemsPerBlock), LuceneTestCase.rarely(random) ? 1 : (LuceneTestCase.rarely(random) ? Integer.MAX_VALUE : lowFreqCutoff)), new Pulsing41PostingsFormat(1 + random.nextInt(20), minItemsPerBlock, maxItemsPerBlock), new Pulsing41PostingsFormat(1 + random.nextInt(20), minItemsPerBlock, maxItemsPerBlock), new TestBloomFilteredLucene41Postings(), new MockSepPostingsFormat(), new MockFixedIntBlockPostingsFormat(TestUtil.nextInt(random, 1, 2000)), new MockVariableIntBlockPostingsFormat(TestUtil.nextInt(random, 1, 127)), new MockRandomPostingsFormat(random), new NestedPulsingPostingsFormat(), new Lucene41WithOrds(), new SimpleTextPostingsFormat(), new AssertingPostingsFormat(), new MemoryPostingsFormat(true, random.nextFloat()), new MemoryPostingsFormat(false, random.nextFloat())});
        this.addDocValues(avoidCodecs, new DocValuesFormat[]{new Lucene45DocValuesFormat(), new DiskDocValuesFormat(), new MemoryDocValuesFormat(), new SimpleTextDocValuesFormat(), new AssertingDocValuesFormat()});
        Collections.shuffle(this.formats, random);
        Collections.shuffle(this.dvFormats, random);
        if (this.formats.size() > 4) {
            this.formats = this.formats.subList(0, 4);
        }
        if (this.dvFormats.size() > 4) {
            this.dvFormats = this.dvFormats.subList(0, 4);
        }
    }

    public RandomCodec(Random random) {
        this(random, Collections.emptySet());
    }

    private final void add(Set<String> avoidCodecs, PostingsFormat ... postings) {
        for (PostingsFormat p : postings) {
            if (avoidCodecs.contains(p.getName())) continue;
            this.formats.add(p);
            this.formatNames.add(p.getName());
        }
    }

    private final void addDocValues(Set<String> avoidCodecs, DocValuesFormat ... docvalues) {
        for (DocValuesFormat d : docvalues) {
            if (avoidCodecs.contains(d.getName())) continue;
            this.dvFormats.add(d);
            this.dvFormatNames.add(d.getName());
        }
    }

    public String toString() {
        return super.toString() + ": " + this.previousMappings.toString() + ", docValues:" + this.previousDVMappings.toString();
    }
}

