/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util._TestUtil;

public class BaseDirectoryWrapper
extends Directory {
    protected final Directory delegate;
    private boolean checkIndexOnClose = true;
    private boolean crossCheckTermVectorsOnClose = true;

    public BaseDirectoryWrapper(Directory delegate) {
        this.delegate = delegate;
    }

    public void close() throws IOException {
        this.isOpen = false;
        if (this.checkIndexOnClose && DirectoryReader.indexExists((Directory)this)) {
            _TestUtil.checkIndex(this, this.crossCheckTermVectorsOnClose);
        }
        this.delegate.close();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setCheckIndexOnClose(boolean value) {
        this.checkIndexOnClose = value;
    }

    public boolean getCheckIndexOnClose() {
        return this.checkIndexOnClose;
    }

    public void setCrossCheckTermVectorsOnClose(boolean value) {
        this.crossCheckTermVectorsOnClose = value;
    }

    public boolean getCrossCheckTermVectorsOnClose() {
        return this.crossCheckTermVectorsOnClose;
    }

    public String[] listAll() throws IOException {
        return this.delegate.listAll();
    }

    public boolean fileExists(String name) throws IOException {
        return this.delegate.fileExists(name);
    }

    public void deleteFile(String name) throws IOException {
        this.delegate.deleteFile(name);
    }

    public long fileLength(String name) throws IOException {
        return this.delegate.fileLength(name);
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.delegate.createOutput(name, context);
    }

    public void sync(Collection<String> names) throws IOException {
        this.delegate.sync(names);
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        return this.delegate.openInput(name, context);
    }

    public Lock makeLock(String name) {
        return this.delegate.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        this.delegate.clearLock(name);
    }

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.delegate.setLockFactory(lockFactory);
    }

    public LockFactory getLockFactory() {
        return this.delegate.getLockFactory();
    }

    public String getLockID() {
        return this.delegate.getLockID();
    }

    public String toString() {
        return "BaseDirectoryWrapper(" + this.delegate.toString() + ")";
    }

    public void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        this.delegate.copy(to, src, dest, context);
    }

    public Directory.IndexInputSlicer createSlicer(String name, IOContext context) throws IOException {
        return this.delegate.createSlicer(name, context);
    }
}

