/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.AssertingAtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryUtils;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.VirtualMethod;
import org.apache.lucene.util._TestUtil;

public class AssertingIndexSearcher
extends IndexSearcher {
    final Random random;

    public AssertingIndexSearcher(Random random, IndexReader r) {
        super(r);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReaderContext context) {
        super(context);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReader r, ExecutorService ex) {
        super(r, ex);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReaderContext context, ExecutorService ex) {
        super(context, ex);
        this.random = new Random(random.nextLong());
    }

    public Weight createNormalizedWeight(Query query) throws IOException {
        Weight w = super.createNormalizedWeight(query);
        return new AssertingWeight(this.random, w){

            @Override
            public void normalize(float norm, float topLevelBoost) {
                throw new IllegalStateException("Weight already normalized.");
            }

            @Override
            public float getValueForNormalization() {
                throw new IllegalStateException("Weight already normalized.");
            }
        };
    }

    public Query rewrite(Query original) throws IOException {
        QueryUtils.check(original);
        Query rewritten = super.rewrite(original);
        QueryUtils.check(rewritten);
        return rewritten;
    }

    protected Query wrapFilter(Query query, Filter filter) {
        if (this.random.nextBoolean()) {
            return super.wrapFilter(query, filter);
        }
        return filter == null ? query : new FilteredQuery(query, filter, _TestUtil.randomFilterStrategy(this.random));
    }

    protected void search(List<AtomicReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        super.search(leaves, AssertingWeight.wrap(this.random, weight), collector);
    }

    static class AssertingCollector
    extends Collector {
        final Random random;
        final Collector in;
        final boolean inOrder;
        int lastCollected;

        static Collector wrap(Random random, Collector other, boolean inOrder) {
            return other instanceof AssertingCollector ? other : new AssertingCollector(random, other, inOrder);
        }

        AssertingCollector(Random random, Collector in, boolean inOrder) {
            this.random = random;
            this.in = in;
            this.inOrder = inOrder;
            this.lastCollected = -1;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.in.setScorer(AssertingScorer.getAssertingScorer(this.random, scorer));
        }

        public void collect(int doc) throws IOException {
            if (this.inOrder || !this.acceptsDocsOutOfOrder()) assert (doc > this.lastCollected) : "Out of order : " + this.lastCollected + " " + doc;
            this.in.collect(doc);
            this.lastCollected = doc;
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.lastCollected = -1;
        }

        public boolean acceptsDocsOutOfOrder() {
            return this.in.acceptsDocsOutOfOrder();
        }
    }

    public static class AssertingScorer
    extends Scorer {
        private static final VirtualMethod<Scorer> SCORE_COLLECTOR = new VirtualMethod(Scorer.class, "score", new Class[]{Collector.class});
        private static final VirtualMethod<Scorer> SCORE_COLLECTOR_RANGE = new VirtualMethod(Scorer.class, "score", new Class[]{Collector.class, Integer.TYPE, Integer.TYPE});
        private static Map<Scorer, WeakReference<AssertingScorer>> ASSERTING_INSTANCES = Collections.synchronizedMap(new WeakHashMap());
        final Random random;
        final Scorer in;
        final AssertingAtomicReader.AssertingDocsEnum docsEnumIn;
        final TopScorer topScorer;
        final boolean inOrder;
        final boolean canCallNextDoc;

        private static Scorer wrap(Random random, Scorer other, TopScorer topScorer, boolean inOrder) {
            if (other == null || other instanceof AssertingScorer) {
                return other;
            }
            AssertingScorer assertScorer = new AssertingScorer(random, other, topScorer, inOrder);
            ASSERTING_INSTANCES.put(other, new WeakReference<AssertingScorer>(assertScorer));
            return assertScorer;
        }

        static Scorer wrap(Random random, Scorer other, boolean topScorer, boolean inOrder) {
            return AssertingScorer.wrap(random, other, topScorer ? TopScorer.YES : TopScorer.NO, inOrder);
        }

        static Scorer getAssertingScorer(Random random, Scorer other) {
            AssertingScorer assertingScorer;
            if (other == null || other instanceof AssertingScorer) {
                return other;
            }
            WeakReference<AssertingScorer> assertingScorerRef = ASSERTING_INSTANCES.get(other);
            AssertingScorer assertingScorer2 = assertingScorer = assertingScorerRef == null ? null : (AssertingScorer)((Object)assertingScorerRef.get());
            if (assertingScorer == null) {
                return new AssertingScorer(random, other, TopScorer.UNKNOWN, false);
            }
            return assertingScorer;
        }

        private AssertingScorer(Random random, Scorer in, TopScorer topScorer, boolean inOrder) {
            super(in.weight);
            this.random = random;
            this.in = in;
            this.topScorer = topScorer;
            this.inOrder = inOrder;
            this.docsEnumIn = new AssertingAtomicReader.AssertingDocsEnum((DocsEnum)in, topScorer == TopScorer.NO);
            this.canCallNextDoc = topScorer != TopScorer.YES || !SCORE_COLLECTOR_RANGE.isOverriddenAsOf(in.getClass()) || !SCORE_COLLECTOR.isOverriddenAsOf(in.getClass());
        }

        public Scorer getIn() {
            return this.in;
        }

        boolean iterating() {
            switch (this.docID()) {
                case -1: 
                case 0x7FFFFFFF: {
                    return false;
                }
            }
            return true;
        }

        public float score() throws IOException {
            assert (this.iterating());
            float score = this.in.score();
            assert (!Float.isNaN(score));
            assert (!Float.isNaN(score));
            return score;
        }

        public void score(Collector collector) throws IOException {
            assert (this.topScorer != TopScorer.NO);
            if (SCORE_COLLECTOR.isOverriddenAsOf(this.in.getClass())) {
                if (this.random.nextBoolean()) {
                    try {
                        boolean remaining = this.in.score(collector, Integer.MAX_VALUE, this.in.nextDoc());
                        assert (!remaining);
                    }
                    catch (UnsupportedOperationException e) {
                        this.in.score(collector);
                    }
                } else {
                    this.in.score(collector);
                }
            } else {
                super.score(collector);
            }
        }

        public boolean score(Collector collector, int max, int firstDocID) throws IOException {
            assert (this.topScorer != TopScorer.NO);
            if (SCORE_COLLECTOR_RANGE.isOverriddenAsOf(this.in.getClass())) {
                return this.in.score(collector, max, firstDocID);
            }
            return super.score(collector, max, firstDocID);
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            return this.in.getChildren();
        }

        public int freq() throws IOException {
            assert (this.iterating());
            return this.in.freq();
        }

        public int docID() {
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            assert (this.canCallNextDoc) : "top scorers should not call nextDoc()";
            return this.docsEnumIn.nextDoc();
        }

        public int advance(int target) throws IOException {
            assert (this.canCallNextDoc) : "top scorers should not call advance(target)";
            return this.docsEnumIn.advance(target);
        }

        public long cost() {
            return this.in.cost();
        }
    }

    static enum TopScorer {
        YES,
        NO,
        UNKNOWN;

    }

    static class AssertingWeight
    extends Weight {
        final Random random;
        final Weight in;

        static Weight wrap(Random random, Weight other) {
            return other instanceof AssertingWeight ? other : new AssertingWeight(random, other);
        }

        AssertingWeight(Random random, Weight in) {
            this.random = random;
            this.in = in;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return this.in.explain(context, doc);
        }

        public Query getQuery() {
            return this.in.getQuery();
        }

        public float getValueForNormalization() throws IOException {
            return this.in.getValueForNormalization();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.in.normalize(norm, topLevelBoost);
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            boolean inOrder = scoreDocsInOrder || !this.scoresDocsOutOfOrder();
            Scorer inScorer = this.in.scorer(context, scoreDocsInOrder, topScorer, acceptDocs);
            return AssertingScorer.wrap(new Random(this.random.nextLong()), inScorer, topScorer, inOrder);
        }

        public boolean scoresDocsOutOfOrder() {
            return this.in.scoresDocsOutOfOrder();
        }
    }
}

