/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CheckHits;
import org.apache.lucene.search.FieldCacheTermsFilter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;

@LuceneTestCase.SuppressCodecs(value={"Lucene3x"})
public abstract class BaseExplanationTestCase
extends LuceneTestCase {
    protected static IndexSearcher searcher;
    protected static IndexReader reader;
    protected static Directory directory;
    public static final String KEY = "KEY";
    public static final String FIELD = "field";
    public static final String ALTFIELD = "alt";
    protected static final String[] docFields;

    @AfterClass
    public static void afterClassTestExplanations() throws Exception {
        searcher = null;
        reader.close();
        reader = null;
        directory.close();
        directory = null;
    }

    @BeforeClass
    public static void beforeClassTestExplanations() throws Exception {
        directory = BaseExplanationTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseExplanationTestCase.random(), directory, BaseExplanationTestCase.newIndexWriterConfig(new MockAnalyzer(BaseExplanationTestCase.random())).setMergePolicy((MergePolicy)BaseExplanationTestCase.newLogMergePolicy()));
        for (int i = 0; i < docFields.length; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)BaseExplanationTestCase.newStringField(KEY, "" + i, Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField(KEY, new BytesRef((CharSequence)("" + i))));
            Field f = BaseExplanationTestCase.newTextField(FIELD, docFields[i], Field.Store.NO);
            f.setBoost((float)i);
            doc.add((IndexableField)f);
            doc.add((IndexableField)BaseExplanationTestCase.newTextField(ALTFIELD, docFields[i], Field.Store.NO));
            writer.addDocument(doc);
        }
        reader = writer.getReader();
        writer.close();
        searcher = BaseExplanationTestCase.newSearcher(reader);
    }

    public void qtest(Query q, int[] expDocNrs) throws Exception {
        CheckHits.checkHitCollector(BaseExplanationTestCase.random(), q, FIELD, searcher, expDocNrs);
    }

    public void bqtest(Query q, int[] expDocNrs) throws Exception {
        this.qtest(this.reqB(q), expDocNrs);
        this.qtest(this.optB(q), expDocNrs);
    }

    public static Term[] ta(String[] s) {
        Term[] t = new Term[s.length];
        for (int i = 0; i < s.length; ++i) {
            t[i] = new Term(FIELD, s[i]);
        }
        return t;
    }

    public SpanTermQuery st(String s) {
        return new SpanTermQuery(new Term(FIELD, s));
    }

    public SpanNotQuery snot(SpanQuery i, SpanQuery e) {
        return new SpanNotQuery(i, e);
    }

    public SpanOrQuery sor(String s, String e) {
        return this.sor((SpanQuery)this.st(s), (SpanQuery)this.st(e));
    }

    public SpanOrQuery sor(SpanQuery s, SpanQuery e) {
        return new SpanOrQuery(new SpanQuery[]{s, e});
    }

    public SpanOrQuery sor(String s, String m, String e) {
        return this.sor((SpanQuery)this.st(s), (SpanQuery)this.st(m), (SpanQuery)this.st(e));
    }

    public SpanOrQuery sor(SpanQuery s, SpanQuery m, SpanQuery e) {
        return new SpanOrQuery(new SpanQuery[]{s, m, e});
    }

    public SpanNearQuery snear(String s, String e, int slop, boolean inOrder) {
        return this.snear((SpanQuery)this.st(s), (SpanQuery)this.st(e), slop, inOrder);
    }

    public SpanNearQuery snear(SpanQuery s, SpanQuery e, int slop, boolean inOrder) {
        return new SpanNearQuery(new SpanQuery[]{s, e}, slop, inOrder);
    }

    public SpanNearQuery snear(String s, String m, String e, int slop, boolean inOrder) {
        return this.snear((SpanQuery)this.st(s), (SpanQuery)this.st(m), (SpanQuery)this.st(e), slop, inOrder);
    }

    public SpanNearQuery snear(SpanQuery s, SpanQuery m, SpanQuery e, int slop, boolean inOrder) {
        return new SpanNearQuery(new SpanQuery[]{s, m, e}, slop, inOrder);
    }

    public SpanFirstQuery sf(String s, int b) {
        return new SpanFirstQuery((SpanQuery)this.st(s), b);
    }

    public Query optB(Query q) throws Exception {
        BooleanQuery bq = new BooleanQuery(true);
        bq.add(q, BooleanClause.Occur.SHOULD);
        bq.add((Query)new TermQuery(new Term("NEVER", "MATCH")), BooleanClause.Occur.MUST_NOT);
        return bq;
    }

    public Query reqB(Query q) throws Exception {
        BooleanQuery bq = new BooleanQuery(true);
        bq.add(q, BooleanClause.Occur.MUST);
        bq.add((Query)new TermQuery(new Term(FIELD, "w1")), BooleanClause.Occur.SHOULD);
        return bq;
    }

    static {
        docFields = new String[]{"w1 w2 w3 w4 w5", "w1 w3 w2 w3 zz", "w1 xx w2 yy w3", "w1 w3 xx w2 yy w3 zz"};
    }

    public static class ItemizedFilter
    extends FieldCacheTermsFilter {
        private static String[] int2str(int[] terms) {
            String[] out = new String[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                out[i] = "" + terms[i];
            }
            return out;
        }

        public ItemizedFilter(int[] keys) {
            super(BaseExplanationTestCase.KEY, ItemizedFilter.int2str(keys));
        }
    }
}

