/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.util.VirtualMethod;

public class AssertingBulkScorer
extends BulkScorer {
    private static final VirtualMethod<BulkScorer> SCORE_COLLECTOR = new VirtualMethod(BulkScorer.class, "score", new Class[]{Collector.class});
    private static final VirtualMethod<BulkScorer> SCORE_COLLECTOR_RANGE = new VirtualMethod(BulkScorer.class, "score", new Class[]{Collector.class, Integer.TYPE});
    final Random random;
    final BulkScorer in;

    public static BulkScorer wrap(Random random, BulkScorer other) {
        if (other == null || other instanceof AssertingBulkScorer) {
            return other;
        }
        return new AssertingBulkScorer(random, other);
    }

    public static boolean shouldWrap(BulkScorer inScorer) {
        return SCORE_COLLECTOR.isOverriddenAsOf(inScorer.getClass()) || SCORE_COLLECTOR_RANGE.isOverriddenAsOf(inScorer.getClass());
    }

    private AssertingBulkScorer(Random random, BulkScorer in) {
        this.random = random;
        this.in = in;
    }

    public BulkScorer getIn() {
        return this.in;
    }

    public void score(Collector collector) throws IOException {
        if (this.random.nextBoolean()) {
            try {
                boolean remaining = this.in.score(collector, Integer.MAX_VALUE);
                assert (!remaining);
            }
            catch (UnsupportedOperationException e) {
                this.in.score(collector);
            }
        } else {
            this.in.score(collector);
        }
    }

    public boolean score(Collector collector, int max) throws IOException {
        return this.in.score(collector, max);
    }

    public String toString() {
        return "AssertingBulkScorer(" + this.in + ")";
    }
}

