/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.PerDocConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;

class PreFlexRWNormsConsumer
extends PerDocConsumer {
    private static final byte[] NORMS_HEADER = new byte[]{78, 82, 77, -1};
    private static final String NORMS_EXTENSION = "nrm";
    @Deprecated
    private static final String SEPARATE_NORMS_EXTENSION = "s";
    private final Directory directory;
    private final String segment;
    private final IOContext context;
    private NormsWriter writer;

    public PreFlexRWNormsConsumer(Directory directory, String segment, IOContext context) {
        this.directory = directory;
        this.segment = segment;
        this.context = context;
    }

    public void merge(MergeState mergeState) throws IOException {
        this.getNormsWriter().merge(mergeState);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.finish();
        }
    }

    protected boolean canMerge(FieldInfo info) {
        return info.hasNorms();
    }

    protected DocValues.Type getDocValuesType(FieldInfo info) {
        return info.getNormType();
    }

    public DocValuesConsumer addValuesField(DocValues.Type type, FieldInfo fieldInfo) throws IOException {
        if (type != DocValues.Type.FIXED_INTS_8) {
            throw new UnsupportedOperationException("Codec only supports single byte norm values. Type give: " + type);
        }
        return new Lucene3xNormsDocValuesConsumer(fieldInfo);
    }

    public NormsWriter getNormsWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new NormsWriter(this.directory, this.segment, this.context);
        }
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        try {
            try {
                if (this.writer != null) {
                    this.writer.abort();
                }
            }
            finally {
                this.directory.deleteFile(IndexFileNames.segmentFileName((String)this.segment, (String)"", (String)NORMS_EXTENSION));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class NormsWriter {
        private final IndexOutput output;
        private int normCount = 0;
        private int numTotalDocs = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NormsWriter(Directory directory, String segment, IOContext context) throws IOException {
            String normsFileName = IndexFileNames.segmentFileName((String)segment, (String)"", (String)PreFlexRWNormsConsumer.NORMS_EXTENSION);
            boolean success = false;
            IndexOutput out = null;
            try {
                this.output = out = directory.createOutput(normsFileName, context);
                this.output.writeBytes(NORMS_HEADER, 0, NORMS_HEADER.length);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
                throw throwable;
            }
        }

        public void setNumTotalDocs(int numTotalDocs) {
            assert (this.numTotalDocs == 0 || numTotalDocs == this.numTotalDocs);
            this.numTotalDocs = numTotalDocs;
        }

        public void startField(FieldInfo info) throws IOException {
            assert (!info.omitsNorms());
            ++this.normCount;
        }

        public void writeNorm(byte norm) throws IOException {
            this.output.writeByte(norm);
        }

        public void abort() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.output});
        }

        public void finish() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.output});
            if (4L + (long)this.normCount * (long)this.numTotalDocs != this.output.getFilePointer()) {
                throw new IOException(".nrm file size mismatch: expected=" + (4L + (long)this.normCount * (long)this.numTotalDocs) + " actual=" + this.output.getFilePointer());
            }
        }

        public void merge(MergeState mergeState) throws IOException {
            int numMergedDocs = 0;
            for (FieldInfo fi : mergeState.fieldInfos) {
                if (!fi.hasNorms()) continue;
                this.startField(fi);
                int numMergedDocsForField = 0;
                for (MergeState.IndexReaderAndLiveDocs reader : mergeState.readers) {
                    byte[] normBuffer;
                    int maxDoc = reader.reader.maxDoc();
                    DocValues normValues = reader.reader.normValues(fi.name);
                    if (normValues == null) {
                        normBuffer = new byte[maxDoc];
                        Arrays.fill(normBuffer, (byte)0);
                    } else {
                        DocValues.Source directSource = normValues.getDirectSource();
                        assert (directSource.hasArray());
                        normBuffer = (byte[])directSource.getArray();
                    }
                    if (reader.liveDocs == null) {
                        this.output.writeBytes(normBuffer, maxDoc);
                        numMergedDocsForField += maxDoc;
                    } else {
                        Bits liveDocs = reader.liveDocs;
                        for (int k = 0; k < maxDoc; ++k) {
                            if (!liveDocs.get(k)) continue;
                            ++numMergedDocsForField;
                            this.output.writeByte(normBuffer[k]);
                        }
                    }
                    mergeState.checkAbort.work((double)maxDoc);
                }
                assert (numMergedDocs == 0 || numMergedDocs == numMergedDocsForField);
                numMergedDocs = numMergedDocsForField;
            }
            this.numTotalDocs = numMergedDocs;
        }
    }

    class Lucene3xNormsDocValuesConsumer
    extends DocValuesConsumer {
        private int[] docIDs = new int[1];
        private byte[] norms = new byte[1];
        private int upto;
        private final FieldInfo fi;

        Lucene3xNormsDocValuesConsumer(FieldInfo fieldInfo) {
            this.fi = fieldInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish(int docCount) throws IOException {
            NormsWriter normsWriter = PreFlexRWNormsConsumer.this.getNormsWriter();
            boolean success = false;
            try {
                int uptoDoc = 0;
                normsWriter.setNumTotalDocs(docCount);
                if (this.upto > 0) {
                    normsWriter.startField(this.fi);
                    for (int docID = 0; docID < docCount; ++docID) {
                        if (uptoDoc < this.upto && this.docIDs[uptoDoc] == docID) {
                            normsWriter.writeNorm(this.norms[uptoDoc]);
                            ++uptoDoc;
                            continue;
                        }
                        normsWriter.writeNorm((byte)0);
                    }
                    assert (uptoDoc == this.upto);
                } else {
                    normsWriter.startField(this.fi);
                    while (this.upto < docCount) {
                        normsWriter.writeNorm((byte)0);
                        ++this.upto;
                    }
                }
                success = true;
            }
            finally {
                if (!success) {
                    normsWriter.abort();
                }
            }
        }

        public void add(int docID, IndexableField docValue) throws IOException {
            this.add(docID, docValue.numericValue().longValue());
        }

        protected void add(int docID, long value) {
            if (this.docIDs.length <= this.upto) {
                assert (this.docIDs.length == this.upto);
                this.docIDs = ArrayUtil.grow((int[])this.docIDs, (int)(1 + this.upto));
            }
            if (this.norms.length <= this.upto) {
                assert (this.norms.length == this.upto);
                this.norms = ArrayUtil.grow((byte[])this.norms, (int)(1 + this.upto));
            }
            this.norms[this.upto] = (byte)value;
            this.docIDs[this.upto] = docID;
            ++this.upto;
        }

        protected DocValues.Type getType() {
            return DocValues.Type.FIXED_INTS_8;
        }

        public int getValueSize() {
            return 1;
        }
    }
}

