/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IndexableBinaryStringTools;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;
import org.junit.Assert;

public abstract class CollationTestBase
extends LuceneTestCase {
    protected String firstRangeBeginningOriginal = "\u062f";
    protected String firstRangeEndOriginal = "\u0698";
    protected String secondRangeBeginningOriginal = "\u0633";
    protected String secondRangeEndOriginal = "\u0638";

    @Deprecated
    protected String encodeCollationKey(byte[] keyBits) {
        int encodedLength = IndexableBinaryStringTools.getEncodedLength((byte[])keyBits, (int)0, (int)keyBits.length);
        char[] encodedBegArray = new char[encodedLength];
        IndexableBinaryStringTools.encode((byte[])keyBits, (int)0, (int)keyBits.length, (char[])encodedBegArray, (int)0, (int)encodedLength);
        return new String(encodedBegArray);
    }

    public void testFarsiRangeFilterCollating(Analyzer analyzer, BytesRef firstBeg, BytesRef firstEnd, BytesRef secondBeg, BytesRef secondEnd) throws Exception {
        MockDirectoryWrapper dir = CollationTestBase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)dir, new IndexWriterConfig(TEST_VERSION_CURRENT, analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new TextField("content", "\u0633\u0627\u0628", Field.Store.YES));
        doc.add((IndexableField)new StringField("body", "body", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        TermQuery query = new TermQuery(new Term("body", "body"));
        ScoreDoc[] result = searcher.search((Query)query, (Filter)new TermRangeFilter((String)"content", (BytesRef)firstBeg, (BytesRef)firstEnd, (boolean)true, (boolean)true), (int)1).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)result.length);
        result = searcher.search((Query)query, (Filter)new TermRangeFilter((String)"content", (BytesRef)secondBeg, (BytesRef)secondEnd, (boolean)true, (boolean)true), (int)1).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)result.length);
        reader.close();
        dir.close();
    }

    public void testFarsiRangeQueryCollating(Analyzer analyzer, BytesRef firstBeg, BytesRef firstEnd, BytesRef secondBeg, BytesRef secondEnd) throws Exception {
        MockDirectoryWrapper dir = CollationTestBase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)dir, new IndexWriterConfig(TEST_VERSION_CURRENT, analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new TextField("content", "\u0633\u0627\u0628", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        TermRangeQuery query = new TermRangeQuery("content", firstBeg, firstEnd, true, true);
        ScoreDoc[] hits = searcher.search((Query)query, null, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)hits.length);
        query = new TermRangeQuery("content", secondBeg, secondEnd, true, true);
        hits = searcher.search((Query)query, null, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)hits.length);
        reader.close();
        dir.close();
    }

    public void testFarsiTermRangeQuery(Analyzer analyzer, BytesRef firstBeg, BytesRef firstEnd, BytesRef secondBeg, BytesRef secondEnd) throws Exception {
        MockDirectoryWrapper farsiIndex = CollationTestBase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)farsiIndex, new IndexWriterConfig(TEST_VERSION_CURRENT, analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new TextField("content", "\u0633\u0627\u0628", Field.Store.YES));
        doc.add((IndexableField)new StringField("body", "body", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)farsiIndex);
        IndexSearcher search = CollationTestBase.newSearcher((IndexReader)reader);
        TermRangeQuery csrq = new TermRangeQuery("content", firstBeg, firstEnd, true, true);
        ScoreDoc[] result = search.search((Query)csrq, null, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)result.length);
        csrq = new TermRangeQuery("content", secondBeg, secondEnd, true, true);
        result = search.search((Query)csrq, null, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)result.length);
        reader.close();
        farsiIndex.close();
    }

    public void testCollationKeySort(Analyzer usAnalyzer, Analyzer franceAnalyzer, Analyzer swedenAnalyzer, Analyzer denmarkAnalyzer, String usResult, String frResult, String svResult, String dkResult) throws Exception {
        MockDirectoryWrapper indexStore = CollationTestBase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)indexStore, new IndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(CollationTestBase.random(), MockTokenizer.WHITESPACE, false)));
        String[][] sortData = new String[][]{{"A", "x", "p\u00eache", "p\u00eache", "p\u00eache", "p\u00eache"}, {"B", "y", "HAT", "HAT", "HAT", "HAT"}, {"C", "x", "p\u00e9ch\u00e9", "p\u00e9ch\u00e9", "p\u00e9ch\u00e9", "p\u00e9ch\u00e9"}, {"D", "y", "HUT", "HUT", "HUT", "HUT"}, {"E", "x", "peach", "peach", "peach", "peach"}, {"F", "y", "H\u00c5T", "H\u00c5T", "H\u00c5T", "H\u00c5T"}, {"G", "x", "sin", "sin", "sin", "sin"}, {"H", "y", "H\u00d8T", "H\u00d8T", "H\u00d8T", "H\u00d8T"}, {"I", "x", "s\u00edn", "s\u00edn", "s\u00edn", "s\u00edn"}, {"J", "y", "HOT", "HOT", "HOT", "HOT"}};
        FieldType customType = new FieldType();
        customType.setStored(true);
        for (int i = 0; i < sortData.length; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new Field("tracer", sortData[i][0], customType));
            doc.add((IndexableField)new TextField("contents", sortData[i][1], Field.Store.NO));
            if (sortData[i][2] != null) {
                doc.add((IndexableField)new TextField("US", usAnalyzer.tokenStream("US", (Reader)new StringReader(sortData[i][2]))));
            }
            if (sortData[i][3] != null) {
                doc.add((IndexableField)new TextField("France", franceAnalyzer.tokenStream("France", (Reader)new StringReader(sortData[i][3]))));
            }
            if (sortData[i][4] != null) {
                doc.add((IndexableField)new TextField("Sweden", swedenAnalyzer.tokenStream("Sweden", (Reader)new StringReader(sortData[i][4]))));
            }
            if (sortData[i][5] != null) {
                doc.add((IndexableField)new TextField("Denmark", denmarkAnalyzer.tokenStream("Denmark", (Reader)new StringReader(sortData[i][5]))));
            }
            writer.addDocument((Iterable)doc);
        }
        writer.forceMerge(1);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)indexStore);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        Sort sort = new Sort();
        TermQuery queryX = new TermQuery(new Term("contents", "x"));
        TermQuery queryY = new TermQuery(new Term("contents", "y"));
        sort.setSort(new SortField("US", SortField.Type.STRING));
        this.assertMatches(searcher, (Query)queryY, sort, usResult);
        sort.setSort(new SortField("France", SortField.Type.STRING));
        this.assertMatches(searcher, (Query)queryX, sort, frResult);
        sort.setSort(new SortField("Sweden", SortField.Type.STRING));
        this.assertMatches(searcher, (Query)queryY, sort, svResult);
        sort.setSort(new SortField("Denmark", SortField.Type.STRING));
        this.assertMatches(searcher, (Query)queryY, sort, dkResult);
        reader.close();
        indexStore.close();
    }

    private void assertMatches(IndexSearcher searcher, Query query, Sort sort, String expectedResult) throws IOException {
        ScoreDoc[] result = searcher.search((Query)query, null, (int)1000, (Sort)sort).scoreDocs;
        StringBuilder buff = new StringBuilder(10);
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            Document doc = searcher.doc(result[i].doc);
            IndexableField[] v = doc.getFields("tracer");
            for (int j = 0; j < v.length; ++j) {
                buff.append(v[j].stringValue());
            }
        }
        CollationTestBase.assertEquals((Object)expectedResult, (Object)buff.toString());
    }

    public void assertThreadSafe(final Analyzer analyzer) throws Exception {
        int i;
        int numTestPoints = 100;
        int numThreads = _TestUtil.nextInt(CollationTestBase.random(), 3, 5);
        final HashMap<String, BytesRef> map = new HashMap<String, BytesRef>();
        for (int i2 = 0; i2 < numTestPoints; ++i2) {
            String term = _TestUtil.randomSimpleString(CollationTestBase.random());
            TokenStream ts = analyzer.tokenStream("fake", (Reader)new StringReader(term));
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)ts.addAttribute(TermToBytesRefAttribute.class);
            BytesRef bytes = termAtt.getBytesRef();
            ts.reset();
            CollationTestBase.assertTrue((boolean)ts.incrementToken());
            termAtt.fillBytesRef();
            map.put(term, BytesRef.deepCopyOf((BytesRef)bytes));
        }
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        for (Map.Entry mapping : map.entrySet()) {
                            String term = (String)mapping.getKey();
                            BytesRef expected = (BytesRef)mapping.getValue();
                            TokenStream ts = analyzer.tokenStream("fake", (Reader)new StringReader(term));
                            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)ts.addAttribute(TermToBytesRefAttribute.class);
                            BytesRef bytes = termAtt.getBytesRef();
                            ts.reset();
                            Assert.assertTrue((boolean)ts.incrementToken());
                            termAtt.fillBytesRef();
                            Assert.assertEquals((Object)expected, (Object)bytes);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }
}

