/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;

public abstract class BaseTokenStreamTestCase
extends LuceneTestCase {
    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertNotNull((Object)output);
        CheckClearAttributesAttribute checkClearAtt = (CheckClearAttributesAttribute)ts.addAttribute(CheckClearAttributesAttribute.class);
        BaseTokenStreamTestCase.assertTrue((String)"has no CharTermAttribute", (boolean)ts.hasAttribute(CharTermAttribute.class));
        CharTermAttribute termAtt = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = null;
        if (startOffsets != null || endOffsets != null || finalOffset != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no OffsetAttribute", (boolean)ts.hasAttribute(OffsetAttribute.class));
            offsetAtt = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
        }
        TypeAttribute typeAtt = null;
        if (types != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no TypeAttribute", (boolean)ts.hasAttribute(TypeAttribute.class));
            typeAtt = (TypeAttribute)ts.getAttribute(TypeAttribute.class);
        }
        PositionIncrementAttribute posIncrAtt = null;
        if (posIncrements != null) {
            BaseTokenStreamTestCase.assertTrue((String)"has no PositionIncrementAttribute", (boolean)ts.hasAttribute(PositionIncrementAttribute.class));
            posIncrAtt = (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class);
        }
        ts.reset();
        for (int i = 0; i < output.length; ++i) {
            ts.clearAttributes();
            termAtt.setEmpty().append("bogusTerm");
            if (offsetAtt != null) {
                offsetAtt.setOffset(14584724, 24683243);
            }
            if (typeAtt != null) {
                typeAtt.setType("bogusType");
            }
            if (posIncrAtt != null) {
                posIncrAtt.setPositionIncrement(45987657);
            }
            checkClearAtt.getAndResetClearCalled();
            BaseTokenStreamTestCase.assertTrue((String)("token " + i + " does not exist"), (boolean)ts.incrementToken());
            BaseTokenStreamTestCase.assertTrue((String)"clearAttributes() was not called correctly in TokenStream chain", (boolean)checkClearAtt.getAndResetClearCalled());
            BaseTokenStreamTestCase.assertEquals((String)("term " + i), (Object)output[i], (Object)termAtt.toString());
            if (startOffsets != null) {
                BaseTokenStreamTestCase.assertEquals((String)("startOffset " + i), (long)startOffsets[i], (long)offsetAtt.startOffset());
            }
            if (endOffsets != null) {
                BaseTokenStreamTestCase.assertEquals((String)("endOffset " + i), (long)endOffsets[i], (long)offsetAtt.endOffset());
            }
            if (types != null) {
                BaseTokenStreamTestCase.assertEquals((String)("type " + i), (Object)types[i], (Object)typeAtt.type());
            }
            if (posIncrements != null) {
                BaseTokenStreamTestCase.assertEquals((String)("posIncrement " + i), (long)posIncrements[i], (long)posIncrAtt.getPositionIncrement());
            }
            if (offsetAtt != null) {
                BaseTokenStreamTestCase.assertTrue((String)"startOffset must be >= 0", (offsetAtt.startOffset() >= 0 ? 1 : 0) != 0);
                BaseTokenStreamTestCase.assertTrue((String)"endOffset must be >= 0", (offsetAtt.endOffset() >= 0 ? 1 : 0) != 0);
                BaseTokenStreamTestCase.assertTrue((String)"endOffset must be >= startOffset", (offsetAtt.endOffset() >= offsetAtt.startOffset() ? 1 : 0) != 0);
            }
            if (posIncrAtt == null) continue;
            BaseTokenStreamTestCase.assertTrue((String)"posIncrement must be >= 0", (posIncrAtt.getPositionIncrement() >= 0 ? 1 : 0) != 0);
        }
        BaseTokenStreamTestCase.assertFalse((String)"end of stream", (boolean)ts.incrementToken());
        ts.end();
        if (finalOffset != null) {
            BaseTokenStreamTestCase.assertEquals((String)"finalOffset ", (long)finalOffset.intValue(), (long)offsetAtt.endOffset());
        }
        if (offsetAtt != null) {
            BaseTokenStreamTestCase.assertTrue((String)"finalOffset must be >= 0", (offsetAtt.endOffset() >= 0 ? 1 : 0) != 0);
        }
        ts.close();
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, types, posIncrements, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, null, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, String[] types) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, types, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, null, null, null, posIncrements, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, null, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, null, finalOffset);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, posIncrements, null);
    }

    public static void assertTokenStreamContents(TokenStream ts, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements, Integer finalOffset) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(ts, output, startOffsets, endOffsets, null, posIncrements, finalOffset);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(a.tokenStream("dummy", (Reader)new StringReader(input)), output, startOffsets, endOffsets, types, posIncrements, input.length());
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, null, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, String[] types) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, types, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, null, null, null, posIncrements);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, startOffsets, endOffsets, null, null);
    }

    public static void assertAnalyzesTo(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, output, startOffsets, endOffsets, null, posIncrements);
    }

    public static void assertAnalyzesToReuse(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, String[] types, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertTokenStreamContents(a.reusableTokenStream("dummy", (Reader)new StringReader(input)), output, startOffsets, endOffsets, types, posIncrements, input.length());
    }

    public static void assertAnalyzesToReuse(Analyzer a, String input, String[] output) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesToReuse(a, input, output, null, null, null, null);
    }

    public static void assertAnalyzesToReuse(Analyzer a, String input, String[] output, String[] types) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesToReuse(a, input, output, null, null, types, null);
    }

    public static void assertAnalyzesToReuse(Analyzer a, String input, String[] output, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesToReuse(a, input, output, null, null, null, posIncrements);
    }

    public static void assertAnalyzesToReuse(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesToReuse(a, input, output, startOffsets, endOffsets, null, null);
    }

    public static void assertAnalyzesToReuse(Analyzer a, String input, String[] output, int[] startOffsets, int[] endOffsets, int[] posIncrements) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesToReuse(a, input, output, startOffsets, endOffsets, null, posIncrements);
    }

    public static void checkOneTerm(Analyzer a, String input, String expected) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesTo(a, input, new String[]{expected});
    }

    public static void checkOneTermReuse(Analyzer a, String input, String expected) throws IOException {
        BaseTokenStreamTestCase.assertAnalyzesToReuse(a, input, new String[]{expected});
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations) throws IOException {
        BaseTokenStreamTestCase.checkRandomData(random, a, iterations, 20);
    }

    public static void checkRandomData(Random random, Analyzer a, int iterations, int maxWordLength) throws IOException {
        for (int i = 0; i < iterations; ++i) {
            String text;
            switch (_TestUtil.nextInt(random, 0, 3)) {
                case 0: {
                    text = _TestUtil.randomSimpleString(random);
                    break;
                }
                case 1: {
                    text = _TestUtil.randomRealisticUnicodeString(random, maxWordLength);
                    break;
                }
                default: {
                    text = _TestUtil.randomUnicodeString(random, maxWordLength);
                }
            }
            TokenStream ts = a.reusableTokenStream("dummy", (Reader)new StringReader(text));
            BaseTokenStreamTestCase.assertTrue((String)"has no CharTermAttribute", (boolean)ts.hasAttribute(CharTermAttribute.class));
            CharTermAttribute termAtt = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
            ArrayList<String> tokens = new ArrayList<String>();
            ts.reset();
            while (ts.incrementToken()) {
                tokens.add(termAtt.toString());
            }
            ts.end();
            ts.close();
            if (tokens.isEmpty()) continue;
            BaseTokenStreamTestCase.assertAnalyzesToReuse(a, text, tokens.toArray(new String[tokens.size()]));
        }
    }

    public static final class CheckClearAttributesAttributeImpl
    extends AttributeImpl
    implements CheckClearAttributesAttribute {
        private boolean clearCalled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getAndResetClearCalled() {
            try {
                boolean bl = this.clearCalled;
                return bl;
            }
            finally {
                this.clearCalled = false;
            }
        }

        public void clear() {
            this.clearCalled = true;
        }

        public boolean equals(Object other) {
            return other instanceof CheckClearAttributesAttributeImpl && ((CheckClearAttributesAttributeImpl)other).clearCalled == this.clearCalled;
        }

        public int hashCode() {
            return 0x489C2FD ^ Boolean.valueOf(this.clearCalled).hashCode();
        }

        public void copyTo(AttributeImpl target) {
            ((CheckClearAttributesAttributeImpl)target).clear();
        }
    }

    public static interface CheckClearAttributesAttribute
    extends Attribute {
        public boolean getAndResetClearCalled();
    }
}

