/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import org.apache.lucene.tests.mockfile.FilterFileSystem;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.Unwrappable;

public class FilterPath
implements Path,
Unwrappable<Path> {
    protected final Path delegate;
    protected final FilterFileSystem fileSystem;

    public FilterPath(Path delegate, FilterFileSystem fileSystem) {
        this.delegate = delegate;
        this.fileSystem = fileSystem;
    }

    public Path getDelegate() {
        return this.delegate;
    }

    public Path unwrap() {
        return this.delegate;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    @Override
    public Path getRoot() {
        Path root = this.delegate.getRoot();
        if (root == null) {
            return null;
        }
        return this.wrap(root);
    }

    @Override
    public Path getFileName() {
        Path fileName = this.delegate.getFileName();
        if (fileName == null) {
            return null;
        }
        return this.wrap(fileName);
    }

    @Override
    public Path getParent() {
        Path parent = this.delegate.getParent();
        if (parent == null) {
            return null;
        }
        return this.wrap(parent);
    }

    @Override
    public int getNameCount() {
        return this.delegate.getNameCount();
    }

    @Override
    public Path getName(int index) {
        return this.wrap(this.delegate.getName(index));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return this.wrap(this.delegate.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        return this.delegate.startsWith(this.toDelegate(other));
    }

    @Override
    public final boolean startsWith(String other) {
        return Path.super.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return this.delegate.endsWith(this.toDelegate(other));
    }

    @Override
    public final boolean endsWith(String other) {
        return Path.super.endsWith(other);
    }

    @Override
    public Path normalize() {
        return this.wrap(this.delegate.normalize());
    }

    @Override
    public Path resolve(Path other) {
        return this.wrap(this.delegate.resolve(this.toDelegate(other)));
    }

    @Override
    public final Path resolve(String other) {
        return Path.super.resolve(other);
    }

    @Override
    public Path resolveSibling(Path other) {
        return this.wrap(this.delegate.resolveSibling(this.toDelegate(other)));
    }

    @Override
    public final Path resolveSibling(String other) {
        return Path.super.resolveSibling(other);
    }

    @Override
    public Path relativize(Path other) {
        return this.wrap(this.delegate.relativize(this.toDelegate(other)));
    }

    @Override
    public URI toUri() {
        return this.delegate.toUri();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Path toAbsolutePath() {
        return this.wrap(this.delegate.toAbsolutePath());
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.wrap(this.delegate.toRealPath(options));
    }

    @Override
    @SuppressForbidden(reason="Abstract API requires to use java.io.File")
    public File toFile() {
        return this.delegate.toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.delegate.register(watcher, events, modifiers);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.delegate.register(watcher, events);
    }

    @Override
    public Iterator<Path> iterator() {
        final Iterator<Path> iterator = this.delegate.iterator();
        return new Iterator<Path>(this){
            final /* synthetic */ FilterPath this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Path next() {
                return this.this$0.wrap((Path)iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        return this.delegate.compareTo(this.toDelegate(other));
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterPath other = (FilterPath)obj;
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        return !(this.fileSystem == null ? other.fileSystem != null : !this.fileSystem.equals(other.fileSystem));
    }

    public static Path unwrap(Path path) {
        return (Path)Unwrappable.unwrapAll((Object)path);
    }

    protected final Path wrap(Path other) {
        return this.fileSystem.parent.wrapPath(other);
    }

    protected Path toDelegate(Path path) {
        if (path instanceof FilterPath) {
            FilterPath fp = (FilterPath)path;
            if (fp.fileSystem != this.fileSystem) {
                throw new ProviderMismatchException("mismatch, expected: " + String.valueOf(this.fileSystem.provider().getClass()) + ", got: " + String.valueOf(fp.fileSystem.provider().getClass()));
            }
            return fp.delegate;
        }
        throw new ProviderMismatchException("mismatch, expected: FilterPath, got: " + String.valueOf(path.getClass()));
    }
}

