/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util;

import java.io.IOException;
import java.util.BitSet;
import java.util.Random;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.tests.util.BaseBitSetTestCase;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.RamUsageTester;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.FixedBitSet;

public abstract class BaseDocIdSetTestCase<T extends DocIdSet>
extends LuceneTestCase {
    public abstract T copyOf(BitSet var1, int var2) throws IOException;

    public void testNoBit() throws IOException {
        BitSet bs = new BitSet(1);
        T copy = this.copyOf(bs, 1);
        this.assertEquals(1, bs, copy);
    }

    public void test1Bit() throws IOException {
        BitSet bs = new BitSet(1);
        if (BaseDocIdSetTestCase.random().nextBoolean()) {
            bs.set(0);
        }
        T copy = this.copyOf(bs, 1);
        this.assertEquals(1, bs, copy);
    }

    public void test2Bits() throws IOException {
        BitSet bs = new BitSet(2);
        if (BaseDocIdSetTestCase.random().nextBoolean()) {
            bs.set(0);
        }
        if (BaseDocIdSetTestCase.random().nextBoolean()) {
            bs.set(1);
        }
        T copy = this.copyOf(bs, 2);
        this.assertEquals(2, bs, copy);
    }

    public void testAgainstBitSet() throws IOException {
        Random random = BaseDocIdSetTestCase.random();
        int numBits = TestUtil.nextInt(random, 100, 0x100000);
        for (float percentSet : new float[]{0.0f, 1.0E-4f, random.nextFloat(), 0.9f, 1.0f}) {
            BitSet set = BaseBitSetTestCase.randomSet(numBits, percentSet);
            T copy = this.copyOf(set, numBits);
            this.assertEquals(numBits, set, copy);
        }
        BitSet set = new BitSet(numBits);
        set.set(0);
        T copy = this.copyOf(set, numBits);
        this.assertEquals(numBits, set, copy);
        set.clear(0);
        set.set(random.nextInt(numBits));
        copy = this.copyOf(set, numBits);
        this.assertEquals(numBits, set, copy);
        int maxIterations = TEST_NIGHTLY ? Integer.MAX_VALUE : 10;
        int iterations = 0;
        for (int inc = 2; inc < 1000 && iterations < maxIterations; inc += TestUtil.nextInt(random, 1, 100)) {
            ++iterations;
            set = new BitSet(numBits);
            for (int d = random.nextInt(10); d < numBits; d += inc) {
                set.set(d);
            }
            copy = this.copyOf(set, numBits);
            this.assertEquals(numBits, set, copy);
        }
    }

    public void testRamBytesUsed() throws IOException {
        Random random = BaseDocIdSetTestCase.random();
        int iters = 100;
        for (int i = 0; i < 100; ++i) {
            int pow = random.nextInt(20);
            int maxDoc = TestUtil.nextInt(random, 1, 1 << pow);
            int numDocs = TestUtil.nextInt(random, 0, Math.min(maxDoc, 1 << TestUtil.nextInt(random, 0, pow)));
            BitSet set = BaseBitSetTestCase.randomSet(maxDoc, numDocs);
            T copy = this.copyOf(set, maxDoc);
            long actualBytes = this.ramBytesUsed((DocIdSet)copy, maxDoc);
            long expectedBytes = copy.ramBytesUsed();
            BaseDocIdSetTestCase.assertEquals((long)expectedBytes, (long)actualBytes);
        }
    }

    public void assertEquals(int numBits, BitSet ds1, T ds2) throws IOException {
        int doc;
        Random random = BaseDocIdSetTestCase.random();
        DocIdSetIterator it2 = ds2.iterator();
        if (it2 == null) {
            BaseDocIdSetTestCase.assertEquals((long)-1L, (long)ds1.nextSetBit(0));
        } else {
            BaseDocIdSetTestCase.assertEquals((long)-1L, (long)it2.docID());
            doc = ds1.nextSetBit(0);
            while (doc != -1) {
                BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.nextDoc());
                BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.docID());
                doc = ds1.nextSetBit(doc + 1);
            }
            BaseDocIdSetTestCase.assertEquals((long)Integer.MAX_VALUE, (long)it2.nextDoc());
            BaseDocIdSetTestCase.assertEquals((long)Integer.MAX_VALUE, (long)it2.docID());
        }
        it2 = ds2.iterator();
        if (it2 == null) {
            BaseDocIdSetTestCase.assertEquals((long)-1L, (long)ds1.nextSetBit(0));
        } else {
            doc = -1;
            while (doc != Integer.MAX_VALUE) {
                if (random.nextBoolean()) {
                    if ((doc = ds1.nextSetBit(doc + 1)) == -1) {
                        doc = Integer.MAX_VALUE;
                    }
                    BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.nextDoc());
                    BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.docID());
                    continue;
                }
                int target = doc + 1 + random.nextInt(random.nextBoolean() ? 64 : Math.max(numBits / 8, 1));
                if ((doc = ds1.nextSetBit(target)) == -1) {
                    doc = Integer.MAX_VALUE;
                }
                BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.advance(target));
                BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.docID());
            }
        }
    }

    private long ramBytesUsed(DocIdSet set, int length) throws IOException {
        Dummy dummy = new Dummy();
        dummy.o1 = this.copyOf(new BitSet(length), length);
        dummy.o2 = set;
        long bytes1 = RamUsageTester.ramUsed(dummy);
        dummy.o2 = null;
        long bytes2 = RamUsageTester.ramUsed(dummy);
        return bytes1 - bytes2;
    }

    public void testIntoBitSet() throws IOException {
        Random random = BaseDocIdSetTestCase.random();
        int numBits = TestUtil.nextInt(random, 100, 0x100000);
        for (float percentSet : new float[]{0.0f, 1.0E-4f, random.nextFloat(), 0.9f, 1.0f}) {
            BitSet set = BaseBitSetTestCase.randomSet(numBits, percentSet);
            T copy = this.copyOf(set, numBits);
            int from = TestUtil.nextInt(BaseDocIdSetTestCase.random(), 0, numBits - 1);
            int to = TestUtil.nextInt(BaseDocIdSetTestCase.random(), from, numBits + 5);
            FixedBitSet actual = new FixedBitSet(to - from);
            DocIdSetIterator it1 = copy.iterator();
            if (it1 == null) continue;
            int fromDoc = it1.advance(from);
            it1.intoBitSet(from, actual, from);
            BaseDocIdSetTestCase.assertTrue((boolean)actual.scanIsEmpty());
            BaseDocIdSetTestCase.assertEquals((long)fromDoc, (long)it1.docID());
            it1.intoBitSet(to, actual, from);
            FixedBitSet expected = new FixedBitSet(to - from);
            DocIdSetIterator it2 = copy.iterator();
            int doc = it2.advance(from);
            while (doc < to) {
                expected.set(doc - from);
                doc = it2.nextDoc();
            }
            BaseDocIdSetTestCase.assertEquals((Object)expected, (Object)actual);
            BaseDocIdSetTestCase.assertEquals((long)it2.docID(), (long)it1.docID());
            if (it2.docID() == Integer.MAX_VALUE) continue;
            BaseDocIdSetTestCase.assertEquals((long)it2.nextDoc(), (long)it1.nextDoc());
        }
    }

    public void testIntoBitSetBoundChecks() throws IOException {
        BitSet set = new BitSet();
        set.set(20);
        set.set(42);
        T copy = this.copyOf(set, 256);
        int from = TestUtil.nextInt(BaseDocIdSetTestCase.random(), 0, 20);
        int to = TestUtil.nextInt(BaseDocIdSetTestCase.random(), 43, 256);
        int offset = TestUtil.nextInt(BaseDocIdSetTestCase.random(), 0, from);
        FixedBitSet dest1 = new FixedBitSet(42 - offset + 1);
        DocIdSetIterator it1 = copy.iterator();
        it1.advance(from);
        it1.intoBitSet(to, dest1, offset);
        for (int i = 0; i < dest1.length(); ++i) {
            BaseDocIdSetTestCase.assertEquals((Object)(offset + i == 20 || offset + i == 42 ? 1 : 0), (Object)dest1.get(i));
        }
        FixedBitSet dest2 = new FixedBitSet(42 - offset);
        DocIdSetIterator it2 = copy.iterator();
        it2.advance(from);
        BaseDocIdSetTestCase.expectThrows(Throwable.class, () -> it2.intoBitSet(to, dest2, offset));
        FixedBitSet dest3 = new FixedBitSet(42 - offset + 1);
        DocIdSetIterator it3 = copy.iterator();
        it3.advance(from);
        BaseDocIdSetTestCase.expectThrows(Throwable.class, () -> it3.intoBitSet(to, dest3, 21));
    }

    private static class Dummy {
        Object o1;
        Object o2;

        private Dummy() {
        }
    }
}

