/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

class CrankyPostingsFormat
extends PostingsFormat {
    final PostingsFormat delegate;
    final Random random;

    CrankyPostingsFormat(PostingsFormat delegate, Random random) {
        super(delegate.getName());
        this.delegate = delegate;
        this.random = random;
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from PostingsFormat.fieldsConsumer()");
        }
        return new CrankyFieldsConsumer(this.delegate.fieldsConsumer(state), this.random);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return this.delegate.fieldsProducer(state);
    }

    static class CrankyFieldsConsumer
    extends FieldsConsumer {
        final FieldsConsumer delegate;
        final Random random;

        CrankyFieldsConsumer(FieldsConsumer delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void write(Fields fields, NormsProducer norms) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from FieldsConsumer.write()");
            }
            this.delegate.write(fields, norms);
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from FieldsConsumer.close()");
            }
        }
    }
}

