/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.store;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.internal.hppc.LongHashSet;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.Constants;

public class SerialIOCountingDirectory
extends FilterDirectory {
    private static final long PAGE_SHIFT = 12L;
    private static final int PAGE_READAHEAD = 4;
    private final LongAdder counter = new LongAdder();
    private final CloseableThreadLocal<Boolean> pendingFetch = new CloseableThreadLocal<Boolean>(this){

        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public SerialIOCountingDirectory(Directory in) {
        super(in);
    }

    public void close() throws IOException {
        this.pendingFetch.close();
        super.close();
    }

    public long count() {
        return this.counter.sum();
    }

    public ChecksumIndexInput openChecksumInput(String name) throws IOException {
        this.counter.increment();
        return super.openChecksumInput(name);
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        ReadAdvice readAdvice = context.readAdvice().orElse(Constants.DEFAULT_READADVICE);
        if (readAdvice == ReadAdvice.NORMAL) {
            this.counter.increment();
            return super.openInput(name, context);
        }
        return new SerializedIOCountingIndexInput(super.openInput(name, context), readAdvice);
    }

    private class SerializedIOCountingIndexInput
    extends IndexInput {
        private final IndexInput in;
        private final long sliceOffset;
        private final long sliceLength;
        private final ReadAdvice readAdvice;
        private final LongHashSet pendingPages;
        private long currentPage;

        public SerializedIOCountingIndexInput(IndexInput in, ReadAdvice readAdvice) {
            this(in, readAdvice, 0L, in.length());
        }

        public SerializedIOCountingIndexInput(IndexInput in, ReadAdvice readAdvice, long offset, long length) {
            super(in.toString());
            this.pendingPages = new LongHashSet();
            this.currentPage = Long.MIN_VALUE;
            this.in = in;
            this.sliceOffset = offset;
            this.sliceLength = length;
            this.readAdvice = readAdvice;
        }

        private void onRead(long offset, int len) {
            if (len == 0) {
                return;
            }
            long firstPage = this.sliceOffset + offset >> 12;
            long lastPage = this.sliceOffset + offset + (long)len - 1L >> 12;
            long page = firstPage;
            while (page <= lastPage) {
                long readAheadUpto = this.readAdvice == ReadAdvice.RANDOM ? this.currentPage : this.currentPage + 4L;
                if (!(this.pendingPages.contains(page) || page >= this.currentPage && page <= readAheadUpto)) {
                    SerialIOCountingDirectory.this.counter.increment();
                }
                this.currentPage = page++;
            }
            SerialIOCountingDirectory.this.pendingFetch.set((Object)false);
        }

        public void prefetch(long offset, long length) throws IOException {
            long firstPage = this.sliceOffset + offset >> 12;
            long lastPage = this.sliceOffset + offset + length - 1L >> 12;
            long readAheadUpto = this.readAdvice == ReadAdvice.RANDOM ? this.currentPage : this.currentPage + 4L;
            if (!(firstPage >= this.currentPage && lastPage <= readAheadUpto || ((Boolean)SerialIOCountingDirectory.this.pendingFetch.get()).booleanValue())) {
                SerialIOCountingDirectory.this.counter.increment();
                this.pendingPages.clear();
                SerialIOCountingDirectory.this.pendingFetch.set((Object)true);
            }
            for (long page = firstPage; page <= lastPage; ++page) {
                this.pendingPages.add(page);
            }
        }

        public byte readByte() throws IOException {
            this.onRead(this.getFilePointer(), 1);
            return this.in.readByte();
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            this.onRead(this.getFilePointer(), len);
            this.in.readBytes(b, offset, len);
        }

        public void close() throws IOException {
            this.in.close();
        }

        public long getFilePointer() {
            return this.in.getFilePointer() - this.sliceOffset;
        }

        public void seek(long pos) throws IOException {
            this.in.seek(this.sliceOffset + pos);
        }

        public long length() {
            return this.sliceLength;
        }

        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            return this.slice(offset, length, this.readAdvice);
        }

        public IndexInput slice(String sliceDescription, long offset, long length, IOContext context) throws IOException {
            return this.slice(offset, length, context.readAdvice().orElse(Constants.DEFAULT_READADVICE));
        }

        private IndexInput slice(long offset, long length, ReadAdvice readAdvice) throws IOException {
            if ((length | offset) < 0L || length > this.sliceLength - offset) {
                throw new IllegalArgumentException();
            }
            IndexInput clone = this.in.clone();
            clone.seek(this.sliceOffset + offset);
            return new SerializedIOCountingIndexInput(clone, readAdvice, this.sliceOffset + offset, length);
        }

        public IndexInput clone() {
            IndexInput clone = this.in.clone();
            return new SerializedIOCountingIndexInput(clone, this.readAdvice, this.sliceOffset, this.sliceLength);
        }

        public Optional<Boolean> isLoaded() {
            return this.in.isLoaded();
        }
    }
}

