/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

class CrankyPointsFormat
extends PointsFormat {
    PointsFormat delegate;
    Random random;

    CrankyPointsFormat(PointsFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public PointsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new CrankyPointsWriter(this.delegate.fieldsWriter(state), this.random);
    }

    public PointsReader fieldsReader(SegmentReadState state) throws IOException {
        return new CrankyPointsReader(this.delegate.fieldsReader(state), this.random);
    }

    static class CrankyPointsWriter
    extends PointsWriter {
        final PointsWriter delegate;
        final Random random;

        public CrankyPointsWriter(PointsWriter delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void writeField(FieldInfo fieldInfo, PointsReader values) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.writeField(fieldInfo, values);
        }

        public void finish() throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.finish();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public void merge(MergeState mergeState) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.merge(mergeState);
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }
    }

    static class CrankyPointsReader
    extends PointsReader {
        final PointsReader delegate;
        final Random random;

        public CrankyPointsReader(PointsReader delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void checkIntegrity() throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.checkIntegrity();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public PointValues getValues(String fieldName) throws IOException {
            final PointValues delegate = this.delegate.getValues(fieldName);
            if (delegate == null) {
                return null;
            }
            return new PointValues(this){
                final /* synthetic */ CrankyPointsReader this$0;
                {
                    this.this$0 = this$0;
                }

                public PointValues.PointTree getPointTree() throws IOException {
                    final PointValues.PointTree pointTree = delegate.getPointTree();
                    return new PointValues.PointTree(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public PointValues.PointTree clone() {
                            return pointTree.clone();
                        }

                        public boolean moveToChild() throws IOException {
                            return pointTree.moveToChild();
                        }

                        public boolean moveToSibling() throws IOException {
                            return pointTree.moveToSibling();
                        }

                        public boolean moveToParent() throws IOException {
                            return pointTree.moveToParent();
                        }

                        public byte[] getMinPackedValue() {
                            return pointTree.getMinPackedValue();
                        }

                        public byte[] getMaxPackedValue() {
                            return pointTree.getMaxPackedValue();
                        }

                        public long size() {
                            return pointTree.size();
                        }

                        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
                            if (this.this$1.this$0.random.nextInt(100) == 0) {
                                throw new IOException("Fake IOException");
                            }
                            pointTree.visitDocIDs(visitor);
                            if (this.this$1.this$0.random.nextInt(100) == 0) {
                                throw new IOException("Fake IOException");
                            }
                        }

                        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
                            if (this.this$1.this$0.random.nextInt(100) == 0) {
                                throw new IOException("Fake IOException");
                            }
                            pointTree.visitDocValues(visitor);
                            if (this.this$1.this$0.random.nextInt(100) == 0) {
                                throw new IOException("Fake IOException");
                            }
                        }
                    };
                }

                public byte[] getMinPackedValue() throws IOException {
                    if (this.this$0.random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getMinPackedValue();
                }

                public byte[] getMaxPackedValue() throws IOException {
                    if (this.this$0.random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getMaxPackedValue();
                }

                public int getNumDimensions() throws IOException {
                    if (this.this$0.random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getNumDimensions();
                }

                public int getNumIndexDimensions() throws IOException {
                    if (this.this$0.random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getNumIndexDimensions();
                }

                public int getBytesPerDimension() throws IOException {
                    if (this.this$0.random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getBytesPerDimension();
                }

                public long size() {
                    return delegate.size();
                }

                public int getDocCount() {
                    return delegate.getDocCount();
                }
            };
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }
    }
}

