/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SuppressForbidden;

public final class RamUsageTester {
    private static final Map<Class<?>, ToLongFunction<Object>> SIMPLE_TYPES = Collections.unmodifiableMap(new IdentityHashMap<Class<?>, ToLongFunction<Object>>(){
        {
            this.init();
        }

        @SuppressForbidden(reason="We measure some forbidden classes")
        private void init() {
            this.a(String.class, v -> this.charArraySize(v.length()));
            this.a(StringBuilder.class, v -> this.charArraySize(v.capacity()));
            this.a(StringBuffer.class, v -> this.charArraySize(v.capacity()));
            this.a(BitSet.class, v -> v.size() / 8);
            this.a(ByteArrayOutputStream.class, v -> RamUsageTester.byteArraySize(v.size()));
            this.a(File.class, v -> this.charArraySize(v.toString().length()));
            this.a(Path.class, v -> this.charArraySize(v.toString().length()));
            this.a(ByteOrder.class, byteOrder -> 0L);
        }

        private <T> void a(Class<T> clazz, ToLongFunction<T> func) {
            this.put(clazz, func);
        }

        private long charArraySize(int len) {
            return RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 2L * (long)len));
        }
    });

    public static long ramUsed(Object obj, Accumulator accumulator) {
        return RamUsageTester.measureObjectSize(obj, accumulator);
    }

    public static long ramUsed(Object obj) {
        return RamUsageTester.ramUsed(obj, new Accumulator());
    }

    public static String humanSizeOf(Object object) {
        return RamUsageEstimator.humanReadableUnits((long)RamUsageTester.ramUsed(object));
    }

    private static long measureObjectSize(Object root, Accumulator accumulator) {
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        IdentityHashMap classCache = new IdentityHashMap();
        ArrayList<Object> stack = new ArrayList<Object>();
        stack.add(root);
        long totalSize = 0L;
        while (!stack.isEmpty()) {
            Object ob = stack.remove(stack.size() - 1);
            if (ob == null || seen.contains(ob)) continue;
            seen.add(ob);
            Class<?> obClazz = ob.getClass();
            assert (obClazz != null) : "jvm bug detected (Object.getClass() == null). please report this to your vendor";
            long obSize = obClazz.isArray() ? RamUsageTester.handleArray(accumulator, stack, ob, obClazz) : RamUsageTester.handleOther(accumulator, classCache, stack, ob, obClazz);
            totalSize += obSize;
        }
        seen.clear();
        stack.clear();
        classCache.clear();
        return totalSize;
    }

    private static long handleOther(Accumulator accumulator, IdentityHashMap<Class<?>, ClassCache> classCache, ArrayList<Object> stack, Object ob, Class<?> obClazz) {
        Predicate<Object> isIgnorable = clazz -> clazz instanceof CharsetEncoder || clazz instanceof CharsetDecoder || clazz instanceof ReentrantReadWriteLock || clazz instanceof AtomicReference;
        if (isIgnorable.test(ob)) {
            return accumulator.accumulateObject(ob, 0L, Collections.emptyMap(), stack);
        }
        try {
            long alignedShallowInstanceSize = RamUsageEstimator.shallowSizeOf((Object)ob);
            Predicate<Class> isJavaModule = clazz -> clazz.getName().startsWith("java.");
            ToLongFunction<Object> func = SIMPLE_TYPES.get(obClazz);
            if (func != null) {
                return accumulator.accumulateObject(ob, alignedShallowInstanceSize + func.applyAsLong(ob), Collections.emptyMap(), stack);
            }
            if (ob instanceof Enum) {
                return alignedShallowInstanceSize;
            }
            if (ob instanceof ByteBuffer) {
                return RamUsageTester.byteArraySize(((ByteBuffer)ob).capacity());
            }
            if (isJavaModule.test(obClazz) && ob instanceof Map) {
                List<Object> values = ((Map)ob).entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).toList();
                return accumulator.accumulateArray(ob, alignedShallowInstanceSize + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER, values, stack) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
            }
            if (isJavaModule.test(obClazz) && ob instanceof Iterable) {
                List<Object> values = StreamSupport.stream(((Iterable)ob).spliterator(), false).collect(Collectors.toList());
                return accumulator.accumulateArray(ob, alignedShallowInstanceSize + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER, values, stack) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
            }
            ClassCache cachedInfo = classCache.get(obClazz);
            if (cachedInfo == null) {
                cachedInfo = RamUsageTester.createCacheEntry(obClazz);
                classCache.put(obClazz, cachedInfo);
            }
            HashMap<Field, Object> fieldValues = new HashMap<Field, Object>();
            for (Field f : cachedInfo.referenceFields) {
                fieldValues.put(f, f.get(ob));
            }
            return accumulator.accumulateObject(ob, cachedInfo.alignedShallowInstanceSize, fieldValues, stack);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException("Reflective field access failed?", e2);
        }
    }

    private static long handleArray(Accumulator accumulator, ArrayList<Object> stack, final Object ob, Class<?> obClazz) {
        long shallowSize = RamUsageEstimator.shallowSizeOf((Object)ob);
        final int len = Array.getLength(ob);
        Class<?> componentClazz = obClazz.getComponentType();
        AbstractList<Object> values = componentClazz.isPrimitive() ? Collections.emptyList() : new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                return Array.get(ob, index);
            }

            @Override
            public int size() {
                return len;
            }
        };
        return accumulator.accumulateArray(ob, shallowSize, (List<Object>)values, stack);
    }

    @SuppressForbidden(reason="We need to access private fields of measured objects.")
    private static ClassCache createCacheEntry(Class<?> clazz) {
        ClassCache classCache = AccessController.doPrivileged(() -> {
            long shallowInstanceSize = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
            ArrayList<Field> referenceFields = new ArrayList<Field>(32);
            for (Class c = clazz; c != null; c = c.getSuperclass()) {
                Field[] fields;
                if (c == Class.class) continue;
                for (Field f : fields = c.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    shallowInstanceSize = RamUsageEstimator.adjustForField((long)shallowInstanceSize, (Field)f);
                    if (f.getType().isPrimitive()) continue;
                    try {
                        f.setAccessible(true);
                        referenceFields.add(f);
                    }
                    catch (RuntimeException re) {
                        throw new RuntimeException(String.format(Locale.ROOT, "Can't access field '%s' of class '%s' for RAM estimation.", f.getName(), clazz.getName()), re);
                    }
                }
            }
            ClassCache cachedInfo = new ClassCache(RamUsageEstimator.alignObjectSize((long)shallowInstanceSize), referenceFields.toArray(new Field[0]));
            return cachedInfo;
        });
        return classCache;
    }

    private static long byteArraySize(int len) {
        return RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)len));
    }

    public static class Accumulator {
        public long accumulateObject(Object o, long shallowSize, Map<Field, Object> fieldValues, Collection<Object> queue) {
            queue.addAll(fieldValues.values());
            return shallowSize;
        }

        public long accumulateArray(Object array, long shallowSize, List<Object> values, Collection<Object> queue) {
            queue.addAll(values);
            return shallowSize;
        }
    }

    private record ClassCache(long alignedShallowInstanceSize, Field[] referenceFields) {
    }
}

