/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;

class AssertingMatchesIterator
implements MatchesIterator {
    private final MatchesIterator in;
    private State state = State.UNPOSITIONED;

    AssertingMatchesIterator(MatchesIterator in) {
        this.in = in;
    }

    public boolean next() throws IOException {
        assert (this.state != State.EXHAUSTED) : this.state;
        boolean more = this.in.next();
        this.state = !more ? State.EXHAUSTED : State.ITERATING;
        return more;
    }

    public int startPosition() {
        assert (this.state == State.ITERATING) : this.state;
        return this.in.startPosition();
    }

    public int endPosition() {
        assert (this.state == State.ITERATING) : this.state;
        return this.in.endPosition();
    }

    public int startOffset() throws IOException {
        assert (this.state == State.ITERATING) : this.state;
        return this.in.startOffset();
    }

    public int endOffset() throws IOException {
        assert (this.state == State.ITERATING) : this.state;
        return this.in.endOffset();
    }

    public MatchesIterator getSubMatches() throws IOException {
        assert (this.state == State.ITERATING) : this.state;
        return this.in.getSubMatches();
    }

    public Query getQuery() {
        assert (this.state == State.ITERATING) : this.state;
        return this.in.getQuery();
    }

    private static enum State {
        UNPOSITIONED,
        ITERATING,
        EXHAUSTED;

    }
}

