/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.tests.search.AssertingLeafCollector;
import org.apache.lucene.util.Bits;

final class AssertingBulkScorer
extends BulkScorer {
    final Random random;
    final BulkScorer in;
    final int maxDoc;
    final ScoreMode scoreMode;
    int max = 0;

    public static BulkScorer wrap(Random random, BulkScorer other, int maxDoc, ScoreMode scoreMode) {
        if (other == null || other instanceof AssertingBulkScorer) {
            return other;
        }
        return new AssertingBulkScorer(random, other, maxDoc, scoreMode);
    }

    private AssertingBulkScorer(Random random, BulkScorer in, int maxDoc, ScoreMode scoreMode) {
        this.random = random;
        this.in = in;
        this.maxDoc = maxDoc;
        this.scoreMode = scoreMode;
    }

    public BulkScorer getIn() {
        return this.in;
    }

    public long cost() {
        return this.in.cost();
    }

    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int upTo;
        assert (min >= this.max) : "Scoring backward: min=" + min + " while previous max was max=" + this.max;
        assert (min <= max) : "max must be greater than min, got min=" + min + ", and max=" + max;
        this.max = max;
        collector = new AssertingLeafCollector((LeafCollector)collector, min, max);
        int next = min;
        do {
            if (this.random.nextBoolean()) {
                upTo = max;
                continue;
            }
            long interval = this.random.nextInt(100) <= 5 ? (long)(1 + this.random.nextInt(10)) : (long)(1 + this.random.nextInt(this.random.nextBoolean() ? 100 : 5000));
            upTo = Math.toIntExact(Math.min((long)next + interval, (long)max));
        } while ((next = this.in.score((LeafCollector)new AssertingLeafCollector((LeafCollector)collector, next, upTo), acceptDocs, next, upTo)) < max);
        if (max >= this.maxDoc || next >= this.maxDoc) {
            assert (next == Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
        return RandomNumbers.randomIntBetween((Random)this.random, (int)max, (int)next);
    }

    public String toString() {
        return "AssertingBulkScorer(" + String.valueOf(this.in) + ")";
    }
}

