/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class ScorerIndexSearcher
extends IndexSearcher {
    public ScorerIndexSearcher(IndexReader r, Executor executor) {
        super(r, executor);
    }

    public ScorerIndexSearcher(IndexReader r) {
        super(r);
    }

    protected void searchLeaf(LeafReaderContext ctx, int minDocId, int maxDocId, Weight weight, Collector collector) throws IOException {
        if (minDocId != 0 || maxDocId != Integer.MAX_VALUE) {
            throw new IllegalStateException("intra-segment concurrency is not supported by this searcher");
        }
        Scorer scorer = weight.scorer(ctx);
        if (scorer != null) {
            DocIdSetIterator iterator = scorer.iterator();
            LeafCollector leafCollector = collector.getLeafCollector(ctx);
            leafCollector.setScorer((Scorable)scorer);
            Bits liveDocs = ctx.reader().getLiveDocs();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    leafCollector.collect(doc);
                }
                doc = iterator.nextDoc();
            }
        }
    }
}

