/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.CompoundDirectory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.tests.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;
import org.junit.Assert;

public abstract class BaseCompoundFormatTestCase
extends BaseIndexFileFormatTestCase {
    public void testEmpty() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        si.setFiles(Collections.emptySet());
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        BaseCompoundFormatTestCase.assertEquals((long)0L, (long)cfs.listAll().length);
        cfs.close();
        dir.close();
    }

    public void testSingleFile() throws IOException {
        int[] data = new int[]{0, 1, 10, 100};
        for (int i = 0; i < data.length; ++i) {
            String testfile = "_" + i + ".test";
            BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
            SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_" + i);
            BaseCompoundFormatTestCase.createSequenceFile((Directory)dir, testfile, (byte)0, data[i], si.getId(), "suffix");
            si.setFiles(Collections.singleton(testfile));
            si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
            CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
            IndexInput expected = dir.openInput(testfile, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
            IndexInput actual = cfs.openInput(testfile, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
            BaseCompoundFormatTestCase.assertSameStreams(testfile, expected, actual);
            BaseCompoundFormatTestCase.assertSameSeekBehavior(testfile, expected, actual);
            expected.close();
            actual.close();
            cfs.close();
            dir.close();
        }
    }

    public void testTwoFiles() throws IOException {
        String[] files = new String[]{"_123.d1", "_123.d2"};
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        BaseCompoundFormatTestCase.createSequenceFile((Directory)dir, files[0], (byte)0, 15, si.getId(), "suffix");
        BaseCompoundFormatTestCase.createSequenceFile((Directory)dir, files[1], (byte)0, 114, si.getId(), "suffix");
        si.setFiles(Arrays.asList(files));
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        for (String file : files) {
            IndexInput expected = dir.openInput(file, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
            IndexInput actual = cfs.openInput(file, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
            BaseCompoundFormatTestCase.assertSameStreams(file, expected, actual);
            BaseCompoundFormatTestCase.assertSameSeekBehavior(file, expected, actual);
            expected.close();
            actual.close();
        }
        cfs.close();
        dir.close();
    }

    public void testDoubleClose() throws IOException {
        String testfile = "_123.test";
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        try (IndexOutput out = dir.createOutput("_123.test", IOContext.DEFAULT);){
            CodecUtil.writeIndexHeader((DataOutput)out, (String)"Foo", (int)0, (byte[])si.getId(), (String)"suffix");
            out.writeInt(3);
            CodecUtil.writeFooter((IndexOutput)out);
        }
        si.setFiles(Collections.singleton("_123.test"));
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        BaseCompoundFormatTestCase.assertEquals((long)1L, (long)cfs.listAll().length);
        cfs.close();
        cfs.close();
        dir.close();
    }

    public void testPassIOContext() throws IOException {
        String testfile = "_123.test";
        final IOContext myContext = IOContext.DEFAULT;
        FilterDirectory dir = new FilterDirectory(this, (Directory)BaseCompoundFormatTestCase.newDirectory()){

            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                Assert.assertSame((Object)myContext, (Object)context);
                return super.createOutput(name, context);
            }
        };
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        try (IndexOutput out = dir.createOutput("_123.test", myContext);){
            CodecUtil.writeIndexHeader((DataOutput)out, (String)"Foo", (int)0, (byte[])si.getId(), (String)"suffix");
            out.writeInt(3);
            CodecUtil.writeFooter((IndexOutput)out);
        }
        si.setFiles(Collections.singleton("_123.test"));
        si.getCodec().compoundFormat().write((Directory)dir, si, myContext);
        dir.close();
    }

    public void testLargeCFS() throws IOException {
        String testfile = "_123.test";
        IOContext context = new IOContext(new FlushInfo(0, 0x20000000L));
        NRTCachingDirectory dir = new NRTCachingDirectory((Directory)BaseCompoundFormatTestCase.newFSDirectory(BaseCompoundFormatTestCase.createTempDir()), 2.0, 25.0);
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        try (IndexOutput out = dir.createOutput("_123.test", context);){
            CodecUtil.writeIndexHeader((DataOutput)out, (String)"Foo", (int)0, (byte[])si.getId(), (String)"suffix");
            byte[] bytes = new byte[512];
            for (int i = 0; i < 0x100000; ++i) {
                out.writeBytes(bytes, 0, bytes.length);
            }
            CodecUtil.writeFooter((IndexOutput)out);
        }
        si.setFiles(Collections.singleton("_123.test"));
        si.getCodec().compoundFormat().write((Directory)dir, si, context);
        dir.close();
    }

    public void testListAll() throws Exception {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        RandomIndexWriter riw = new RandomIndexWriter(BaseCompoundFormatTestCase.random(), (Directory)dir);
        Document doc = new Document();
        Field idField = BaseCompoundFormatTestCase.newStringField("id", "", Field.Store.NO);
        Field bodyField = BaseCompoundFormatTestCase.newTextField("body", "", Field.Store.NO);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)bodyField);
        for (int i = 0; i < 100; ++i) {
            idField.setStringValue(Integer.toString(i));
            bodyField.setStringValue(TestUtil.randomUnicodeString(BaseCompoundFormatTestCase.random()));
            riw.addDocument(doc);
            if (BaseCompoundFormatTestCase.random().nextInt(7) != 0) continue;
            riw.commit();
        }
        riw.close();
        SegmentInfos infos = SegmentInfos.readLatestCommit((Directory)dir);
        for (SegmentCommitInfo si : infos) {
            if (!si.info.getUseCompoundFile()) continue;
            CompoundDirectory cfsDir = si.info.getCodec().compoundFormat().getCompoundReader((Directory)dir, si.info, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
            try {
                for (String cfsFile : cfsDir.listAll()) {
                    try (IndexInput cfsIn = cfsDir.openInput(cfsFile, IOContext.DEFAULT);){
                        if ($assertionsDisabled || cfsIn != null) continue;
                        throw new AssertionError();
                    }
                }
            }
            finally {
                if (cfsDir == null) continue;
                cfsDir.close();
            }
        }
        dir.close();
    }

    public void testCreateOutputDisabled() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        si.setFiles(Collections.emptyList());
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        BaseCompoundFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> BaseCompoundFormatTestCase.lambda$testCreateOutputDisabled$0((Directory)cfs));
        cfs.close();
        dir.close();
    }

    public void testDeleteFileDisabled() throws IOException {
        String testfile = "_123.test";
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        IndexOutput out = dir.createOutput("_123.test", IOContext.DEFAULT);
        out.writeInt(3);
        out.close();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        si.setFiles(Collections.emptyList());
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        BaseCompoundFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> BaseCompoundFormatTestCase.lambda$testDeleteFileDisabled$1((Directory)cfs));
        cfs.close();
        dir.close();
    }

    public void testRenameFileDisabled() throws IOException {
        String testfile = "_123.test";
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        IndexOutput out = dir.createOutput("_123.test", IOContext.DEFAULT);
        out.writeInt(3);
        out.close();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        si.setFiles(Collections.emptyList());
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        BaseCompoundFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> BaseCompoundFormatTestCase.lambda$testRenameFileDisabled$2((Directory)cfs));
        cfs.close();
        dir.close();
    }

    public void testSyncDisabled() throws IOException {
        String testfile = "_123.test";
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        IndexOutput out = dir.createOutput("_123.test", IOContext.DEFAULT);
        out.writeInt(3);
        out.close();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        si.setFiles(Collections.emptyList());
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        BaseCompoundFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> BaseCompoundFormatTestCase.lambda$testSyncDisabled$3((Directory)cfs));
        cfs.close();
        dir.close();
    }

    public void testMakeLockDisabled() throws IOException {
        String testfile = "_123.test";
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        IndexOutput out = dir.createOutput("_123.test", IOContext.DEFAULT);
        out.writeInt(3);
        out.close();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        si.setFiles(Collections.emptyList());
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        BaseCompoundFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> BaseCompoundFormatTestCase.lambda$testMakeLockDisabled$4((Directory)cfs));
        cfs.close();
        dir.close();
    }

    public void testRandomFiles() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        String segment = "_123";
        int chunk = 1024;
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        byte[] segId = si.getId();
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".zero", 0, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".one", 1, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".ten", 10, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".hundred", 100, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".big1", chunk, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".big2", chunk - 1, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".big3", chunk + 1, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".big4", 3 * chunk, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".big5", 3 * chunk - 1, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".big6", 3 * chunk + 1, segId);
        BaseCompoundFormatTestCase.createRandomFile((Directory)dir, segment + ".big7", 1000 * chunk, segId);
        ArrayList<String> files = new ArrayList<String>();
        for (String file : dir.listAll()) {
            if (!file.startsWith(segment)) continue;
            files.add(file);
        }
        si.setFiles(files);
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        for (String file : files) {
            IndexInput check = dir.openInput(file, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
            IndexInput test = cfs.openInput(file, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
            BaseCompoundFormatTestCase.assertSameStreams(file, check, test);
            BaseCompoundFormatTestCase.assertSameSeekBehavior(file, check, test);
            test.close();
            check.close();
        }
        cfs.close();
        dir.close();
    }

    public void testManySubFiles() throws IOException {
        int fileIdx;
        MockDirectoryWrapper dir = BaseCompoundFormatTestCase.newMockFSDirectory(BaseCompoundFormatTestCase.createTempDir("CFSManySubFiles"));
        int FILE_COUNT = BaseCompoundFormatTestCase.atLeast(500);
        ArrayList<CallSite> files = new ArrayList<CallSite>();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        for (int fileIdx2 = 0; fileIdx2 < FILE_COUNT; ++fileIdx2) {
            String file = "_123." + fileIdx2;
            files.add((CallSite)((Object)file));
            try (IndexOutput out = dir.createOutput(file, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));){
                CodecUtil.writeIndexHeader((DataOutput)out, (String)"Foo", (int)0, (byte[])si.getId(), (String)"suffix");
                out.writeByte((byte)fileIdx2);
                CodecUtil.writeFooter((IndexOutput)out);
                continue;
            }
        }
        BaseCompoundFormatTestCase.assertEquals((long)0L, (long)dir.getFileHandleCount());
        si.setFiles(files);
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        IndexInput[] ins = new IndexInput[FILE_COUNT];
        for (fileIdx = 0; fileIdx < FILE_COUNT; ++fileIdx) {
            ins[fileIdx] = cfs.openInput("_123." + fileIdx, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
            CodecUtil.checkIndexHeader((DataInput)ins[fileIdx], (String)"Foo", (int)0, (int)0, (byte[])si.getId(), (String)"suffix");
        }
        BaseCompoundFormatTestCase.assertEquals((long)1L, (long)dir.getFileHandleCount());
        for (fileIdx = 0; fileIdx < FILE_COUNT; ++fileIdx) {
            BaseCompoundFormatTestCase.assertEquals((long)((byte)fileIdx), (long)ins[fileIdx].readByte());
        }
        BaseCompoundFormatTestCase.assertEquals((long)1L, (long)dir.getFileHandleCount());
        for (fileIdx = 0; fileIdx < FILE_COUNT; ++fileIdx) {
            ins[fileIdx].close();
        }
        cfs.close();
        dir.close();
    }

    public void testClonedStreamsClosing() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        Directory cr = BaseCompoundFormatTestCase.createLargeCFS((Directory)dir);
        IndexInput expected = dir.openInput("_123.f11", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        IndexInput one = cr.openInput("_123.f11", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        IndexInput two = one.clone();
        BaseCompoundFormatTestCase.assertSameStreams("basic clone one", expected, one);
        expected.seek(0L);
        BaseCompoundFormatTestCase.assertSameStreams("basic clone two", expected, two);
        cr.close();
        expected.close();
        dir.close();
    }

    public void testRandomAccess() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        Directory cr = BaseCompoundFormatTestCase.createLargeCFS((Directory)dir);
        IndexInput e1 = dir.openInput("_123.f11", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        IndexInput e2 = dir.openInput("_123.f3", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        IndexInput a1 = cr.openInput("_123.f11", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        IndexInput a2 = dir.openInput("_123.f3", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        e1.seek(100L);
        a1.seek(100L);
        BaseCompoundFormatTestCase.assertEquals((long)100L, (long)e1.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)100L, (long)a1.getFilePointer());
        byte be1 = e1.readByte();
        byte ba1 = a1.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be1, (long)ba1);
        e2.seek(1027L);
        a2.seek(1027L);
        BaseCompoundFormatTestCase.assertEquals((long)1027L, (long)e2.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)1027L, (long)a2.getFilePointer());
        byte be2 = e2.readByte();
        byte ba2 = a2.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be2, (long)ba2);
        BaseCompoundFormatTestCase.assertEquals((long)101L, (long)e1.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)101L, (long)a1.getFilePointer());
        be1 = e1.readByte();
        ba1 = a1.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be1, (long)ba1);
        e1.seek(1910L);
        a1.seek(1910L);
        BaseCompoundFormatTestCase.assertEquals((long)1910L, (long)e1.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)1910L, (long)a1.getFilePointer());
        be1 = e1.readByte();
        ba1 = a1.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be1, (long)ba1);
        BaseCompoundFormatTestCase.assertEquals((long)1028L, (long)e2.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)1028L, (long)a2.getFilePointer());
        be2 = e2.readByte();
        ba2 = a2.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be2, (long)ba2);
        e2.seek(17L);
        a2.seek(17L);
        BaseCompoundFormatTestCase.assertEquals((long)17L, (long)e2.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)17L, (long)a2.getFilePointer());
        be2 = e2.readByte();
        ba2 = a2.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be2, (long)ba2);
        BaseCompoundFormatTestCase.assertEquals((long)1911L, (long)e1.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)1911L, (long)a1.getFilePointer());
        be1 = e1.readByte();
        ba1 = a1.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be1, (long)ba1);
        e1.close();
        e2.close();
        a1.close();
        a2.close();
        cr.close();
        dir.close();
    }

    public void testRandomAccessClones() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        Directory cr = BaseCompoundFormatTestCase.createLargeCFS((Directory)dir);
        IndexInput e1 = cr.openInput("_123.f11", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        IndexInput e2 = cr.openInput("_123.f3", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        IndexInput a1 = e1.clone();
        IndexInput a2 = e2.clone();
        e1.seek(100L);
        a1.seek(100L);
        BaseCompoundFormatTestCase.assertEquals((long)100L, (long)e1.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)100L, (long)a1.getFilePointer());
        byte be1 = e1.readByte();
        byte ba1 = a1.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be1, (long)ba1);
        e2.seek(1027L);
        a2.seek(1027L);
        BaseCompoundFormatTestCase.assertEquals((long)1027L, (long)e2.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)1027L, (long)a2.getFilePointer());
        byte be2 = e2.readByte();
        byte ba2 = a2.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be2, (long)ba2);
        BaseCompoundFormatTestCase.assertEquals((long)101L, (long)e1.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)101L, (long)a1.getFilePointer());
        be1 = e1.readByte();
        ba1 = a1.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be1, (long)ba1);
        e1.seek(1910L);
        a1.seek(1910L);
        BaseCompoundFormatTestCase.assertEquals((long)1910L, (long)e1.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)1910L, (long)a1.getFilePointer());
        be1 = e1.readByte();
        ba1 = a1.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be1, (long)ba1);
        BaseCompoundFormatTestCase.assertEquals((long)1028L, (long)e2.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)1028L, (long)a2.getFilePointer());
        be2 = e2.readByte();
        ba2 = a2.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be2, (long)ba2);
        e2.seek(17L);
        a2.seek(17L);
        BaseCompoundFormatTestCase.assertEquals((long)17L, (long)e2.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)17L, (long)a2.getFilePointer());
        be2 = e2.readByte();
        ba2 = a2.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be2, (long)ba2);
        BaseCompoundFormatTestCase.assertEquals((long)1911L, (long)e1.getFilePointer());
        BaseCompoundFormatTestCase.assertEquals((long)1911L, (long)a1.getFilePointer());
        be1 = e1.readByte();
        ba1 = a1.readByte();
        BaseCompoundFormatTestCase.assertEquals((long)be1, (long)ba1);
        e1.close();
        e2.close();
        a1.close();
        a2.close();
        cr.close();
        dir.close();
    }

    public void testFileNotFound() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        Directory cr = BaseCompoundFormatTestCase.createLargeCFS((Directory)dir);
        BaseCompoundFormatTestCase.expectThrows(IOException.class, () -> cr.openInput("bogus", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random())));
        cr.close();
        dir.close();
    }

    public void testReadPastEOF() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        Directory cr = BaseCompoundFormatTestCase.createLargeCFS((Directory)dir);
        IndexInput is = cr.openInput("_123.f2", BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));
        is.seek(is.length() - 10L);
        byte[] b = new byte[100];
        is.readBytes(b, 0, 10);
        BaseCompoundFormatTestCase.expectThrows(IOException.class, () -> is.readByte());
        is.seek(is.length() - 10L);
        BaseCompoundFormatTestCase.expectThrows(IOException.class, () -> is.readBytes(b, 0, 50));
        is.close();
        cr.close();
        dir.close();
    }

    protected static SegmentInfo newSegmentInfo(Directory dir, String name) {
        Version minVersion = BaseCompoundFormatTestCase.random().nextBoolean() ? null : Version.LATEST;
        return new SegmentInfo(dir, Version.LATEST, minVersion, name, 10000, false, false, Codec.getDefault(), Collections.emptyMap(), StringHelper.randomId(), Collections.emptyMap(), null);
    }

    protected static void createRandomFile(Directory dir, String name, int size, byte[] segId) throws IOException {
        Random rnd = BaseCompoundFormatTestCase.random();
        try (IndexOutput os = dir.createOutput(name, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));){
            CodecUtil.writeIndexHeader((DataOutput)os, (String)"Foo", (int)0, (byte[])segId, (String)"suffix");
            for (int i = 0; i < size; ++i) {
                byte b = (byte)rnd.nextInt(256);
                os.writeByte(b);
            }
            CodecUtil.writeFooter((IndexOutput)os);
        }
    }

    protected static void createSequenceFile(Directory dir, String name, byte start, int size, byte[] segID, String segSuffix) throws IOException {
        try (IndexOutput os = dir.createOutput(name, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));){
            CodecUtil.writeIndexHeader((DataOutput)os, (String)"Foo", (int)0, (byte[])segID, (String)segSuffix);
            for (int i = 0; i < size; ++i) {
                os.writeByte(start);
                start = (byte)(start + 1);
            }
            CodecUtil.writeFooter((IndexOutput)os);
        }
    }

    protected static void assertSameStreams(String msg, IndexInput expected, IndexInput test) throws IOException {
        int readLen;
        BaseCompoundFormatTestCase.assertNotNull((String)(msg + " null expected"), (Object)expected);
        BaseCompoundFormatTestCase.assertNotNull((String)(msg + " null test"), (Object)test);
        BaseCompoundFormatTestCase.assertEquals((String)(msg + " length"), (long)expected.length(), (long)test.length());
        BaseCompoundFormatTestCase.assertEquals((String)(msg + " position"), (long)expected.getFilePointer(), (long)test.getFilePointer());
        byte[] expectedBuffer = new byte[512];
        byte[] testBuffer = new byte[expectedBuffer.length];
        for (long remainder = expected.length() - expected.getFilePointer(); remainder > 0L; remainder -= (long)readLen) {
            readLen = (int)Math.min(remainder, (long)expectedBuffer.length);
            expected.readBytes(expectedBuffer, 0, readLen);
            test.readBytes(testBuffer, 0, readLen);
            BaseCompoundFormatTestCase.assertEqualArrays(msg + ", remainder " + remainder, expectedBuffer, testBuffer, 0, readLen);
        }
    }

    protected static void assertSameStreams(String msg, IndexInput expected, IndexInput actual, long seekTo) throws IOException {
        if (seekTo >= 0L && seekTo < expected.length()) {
            expected.seek(seekTo);
            actual.seek(seekTo);
            BaseCompoundFormatTestCase.assertSameStreams(msg + ", seek(mid)", expected, actual);
        }
    }

    protected static void assertSameSeekBehavior(String msg, IndexInput expected, IndexInput actual) throws IOException {
        long point = 0L;
        BaseCompoundFormatTestCase.assertSameStreams(msg + ", seek(0)", expected, actual, point);
        point = expected.length() / 2L;
        BaseCompoundFormatTestCase.assertSameStreams(msg + ", seek(mid)", expected, actual, point);
        point = expected.length() - 2L;
        BaseCompoundFormatTestCase.assertSameStreams(msg + ", seek(end-2)", expected, actual, point);
        point = expected.length() - 1L;
        BaseCompoundFormatTestCase.assertSameStreams(msg + ", seek(end-1)", expected, actual, point);
        point = expected.length();
        BaseCompoundFormatTestCase.assertSameStreams(msg + ", seek(end)", expected, actual, point);
        point = expected.length() + 1L;
        BaseCompoundFormatTestCase.assertSameStreams(msg + ", seek(end+1)", expected, actual, point);
    }

    protected static void assertEqualArrays(String msg, byte[] expected, byte[] test, int start, int len) {
        BaseCompoundFormatTestCase.assertNotNull((String)(msg + " null expected"), (Object)expected);
        BaseCompoundFormatTestCase.assertNotNull((String)(msg + " null test"), (Object)test);
        for (int i = start; i < len; ++i) {
            BaseCompoundFormatTestCase.assertEquals((String)(msg + " " + i), (long)expected[i], (long)test[i]);
        }
    }

    protected static Directory createLargeCFS(Directory dir) throws IOException {
        ArrayList<CallSite> files = new ArrayList<CallSite>();
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo(dir, "_123");
        for (int i = 0; i < 20; ++i) {
            BaseCompoundFormatTestCase.createSequenceFile(dir, "_123.f" + i, (byte)0, 2000, si.getId(), "suffix");
            files.add((CallSite)((Object)("_123.f" + i)));
        }
        si.setFiles(files);
        si.getCodec().compoundFormat().write(dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader(dir, si, IOContext.DEFAULT);
        return cfs;
    }

    @Override
    protected void addRandomFields(Document doc) {
        doc.add((IndexableField)new StoredField("foobar", TestUtil.randomSimpleString(BaseCompoundFormatTestCase.random())));
    }

    @Override
    public void testMergeStability() throws Exception {
        BaseCompoundFormatTestCase.assumeTrue("test does not work with CFS", true);
    }

    public void testResourceNameInsideCompoundFile() throws Exception {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        String subFile = "_123.xyz";
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        BaseCompoundFormatTestCase.createSequenceFile((Directory)dir, subFile, (byte)0, 10, si.getId(), "suffix");
        si.setFiles(Collections.singletonList(subFile));
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        IndexInput in = cfs.openInput(subFile, IOContext.DEFAULT);
        String desc = in.toString();
        BaseCompoundFormatTestCase.assertTrue((String)("resource description hides that it's inside a compound file: " + desc), (boolean)desc.contains("[slice=" + subFile + "]"));
        cfs.close();
        dir.close();
    }

    public void testMissingCodecHeadersAreCaught() throws Exception {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        String subFile = "_123.xyz";
        try (IndexOutput os = dir.createOutput(subFile, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));){
            for (int i = 0; i < 1024; ++i) {
                os.writeByte((byte)i);
            }
        }
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        si.setFiles(Collections.singletonList(subFile));
        Exception e = (Exception)BaseCompoundFormatTestCase.expectThrows(CorruptIndexException.class, () -> BaseCompoundFormatTestCase.lambda$testMissingCodecHeadersAreCaught$8(si, (Directory)dir));
        BaseCompoundFormatTestCase.assertTrue((boolean)e.getMessage().contains("codec header mismatch"));
        dir.close();
    }

    public void testCorruptFilesAreCaught() throws Exception {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        String subFile = "_123.xyz";
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        try (IndexOutput os = dir.createOutput(subFile, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));){
            CodecUtil.writeIndexHeader((DataOutput)os, (String)"Foo", (int)0, (byte[])si.getId(), (String)"suffix");
            for (int i = 0; i < 1024; ++i) {
                os.writeByte((byte)i);
            }
            CodecUtil.writeBEInt((DataOutput)os, (int)-1071082520);
            CodecUtil.writeBEInt((DataOutput)os, (int)0);
            long checksum = os.getChecksum();
            CodecUtil.writeBELong((DataOutput)os, (long)(checksum + 1L));
        }
        si.setFiles(Collections.singletonList(subFile));
        Exception e = (Exception)BaseCompoundFormatTestCase.expectThrows(CorruptIndexException.class, () -> BaseCompoundFormatTestCase.lambda$testCorruptFilesAreCaught$9(si, (Directory)dir));
        BaseCompoundFormatTestCase.assertTrue((boolean)e.getMessage().contains("checksum failed (hardware problem?)"));
        dir.close();
    }

    public void testCheckIntegrity() throws IOException {
        BaseDirectoryWrapper dir = BaseCompoundFormatTestCase.newDirectory();
        String subFile = "_123.xyz";
        SegmentInfo si = BaseCompoundFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        try (IndexOutput os = dir.createOutput(subFile, BaseCompoundFormatTestCase.newIOContext(BaseCompoundFormatTestCase.random()));){
            CodecUtil.writeIndexHeader((DataOutput)os, (String)"Foo", (int)0, (byte[])si.getId(), (String)"suffix");
            for (int i = 0; i < 1024; ++i) {
                os.writeByte((byte)i);
            }
            CodecUtil.writeBEInt((DataOutput)os, (int)-1071082520);
            CodecUtil.writeBEInt((DataOutput)os, (int)0);
            long checksum = os.getChecksum();
            CodecUtil.writeBELong((DataOutput)os, (long)checksum);
        }
        si.setFiles(Collections.singletonList(subFile));
        BaseIndexFileFormatTestCase.FileTrackingDirectoryWrapper writeTrackingDir = new BaseIndexFileFormatTestCase.FileTrackingDirectoryWrapper((Directory)dir);
        si.getCodec().compoundFormat().write((Directory)writeTrackingDir, si, IOContext.DEFAULT);
        Set<String> createdFiles = writeTrackingDir.getFiles();
        BaseIndexFileFormatTestCase.ReadBytesDirectoryWrapper readTrackingDir = new BaseIndexFileFormatTestCase.ReadBytesDirectoryWrapper((Directory)dir);
        CompoundDirectory compoundDir = si.getCodec().compoundFormat().getCompoundReader((Directory)readTrackingDir, si, IOContext.DEFAULT);
        compoundDir.checkIntegrity();
        Map<String, FixedBitSet> readBytes = readTrackingDir.getReadBytes();
        BaseCompoundFormatTestCase.assertEquals(createdFiles, readBytes.keySet());
        for (Map.Entry<String, FixedBitSet> entry : readBytes.entrySet()) {
            String file = entry.getKey();
            FixedBitSet set = entry.getValue().clone();
            set.flip(0, set.length());
            int next = set.nextSetBit(0);
            BaseCompoundFormatTestCase.assertEquals((String)("Byte at offset " + next + " of " + file + " was not read"), (long)Integer.MAX_VALUE, (long)next);
        }
        compoundDir.close();
        dir.close();
    }

    private static /* synthetic */ void lambda$testCorruptFilesAreCaught$9(SegmentInfo si, Directory dir) throws Throwable {
        si.getCodec().compoundFormat().write(dir, si, IOContext.DEFAULT);
    }

    private static /* synthetic */ void lambda$testMissingCodecHeadersAreCaught$8(SegmentInfo si, Directory dir) throws Throwable {
        si.getCodec().compoundFormat().write(dir, si, IOContext.DEFAULT);
    }

    private static /* synthetic */ void lambda$testMakeLockDisabled$4(Directory cfs) throws Throwable {
        cfs.obtainLock("foobar");
    }

    private static /* synthetic */ void lambda$testSyncDisabled$3(Directory cfs) throws Throwable {
        cfs.sync(Collections.singleton("_123.test"));
    }

    private static /* synthetic */ void lambda$testRenameFileDisabled$2(Directory cfs) throws Throwable {
        cfs.rename("_123.test", "bogus");
    }

    private static /* synthetic */ void lambda$testDeleteFileDisabled$1(Directory cfs) throws Throwable {
        cfs.deleteFile("_123.test");
    }

    private static /* synthetic */ void lambda$testCreateOutputDisabled$0(Directory cfs) throws Throwable {
        cfs.createOutput("bogus", IOContext.DEFAULT);
    }
}

