/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.lucene.queryParser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryParser.surround.query.OrQuery;
import org.apache.lucene.queryParser.surround.query.SrndQuery;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldsQuery
extends SrndQuery {
    private SrndQuery q;
    private List<String> fieldNames;
    private final char fieldOp;
    private final String OrOperatorName = "OR";

    public FieldsQuery(SrndQuery q, List<String> fieldNames, char fieldOp) {
        this.q = q;
        this.fieldNames = fieldNames;
        this.fieldOp = fieldOp;
    }

    public FieldsQuery(SrndQuery q, String fieldName, char fieldOp) {
        this.q = q;
        this.fieldNames = new ArrayList<String>();
        this.fieldNames.add(fieldName);
        this.fieldOp = fieldOp;
    }

    @Override
    public boolean isFieldsSubQueryAcceptable() {
        return false;
    }

    public Query makeLuceneQueryNoBoost(BasicQueryFactory qf) {
        if (this.fieldNames.size() == 1) {
            return this.q.makeLuceneQueryFieldNoBoost(this.fieldNames.get(0), qf);
        }
        ArrayList<SrndQuery> queries = new ArrayList<SrndQuery>();
        ListIterator<String> fni = this.getFieldNames().listIterator();
        while (fni.hasNext()) {
            SrndQuery qc = (SrndQuery)this.q.clone();
            queries.add(new FieldsQuery(qc, (String)fni.next(), this.fieldOp));
        }
        boolean infix = true;
        OrQuery oq = new OrQuery(queries, true, "OR");
        System.out.println(this.getClass().toString() + ", fields expanded: " + oq.toString());
        return oq.makeLuceneQueryField(null, qf);
    }

    @Override
    public Query makeLuceneQueryFieldNoBoost(String fieldName, BasicQueryFactory qf) {
        return this.makeLuceneQueryNoBoost(qf);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public char getFieldOperator() {
        return this.fieldOp;
    }

    @Override
    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("(");
        this.fieldNamesToString(r);
        r.append(this.q.toString());
        r.append(")");
        return r.toString();
    }

    protected void fieldNamesToString(StringBuilder r) {
        ListIterator<String> fni = this.getFieldNames().listIterator();
        while (fni.hasNext()) {
            r.append((String)fni.next());
            r.append(this.getFieldOperator());
        }
    }
}

