/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.spell.TermFreqPayloadIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.Sort;
import org.apache.lucene.search.suggest.SortedTermFreqIteratorWrapper;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class WFSTCompletionLookup
extends Lookup {
    private FST<Long> fst = null;
    private final boolean exactFirst;
    static final Comparator<Long> weightComparator = new Comparator<Long>(){

        @Override
        public int compare(Long left, Long right) {
            return left.compareTo(right);
        }
    };

    public WFSTCompletionLookup() {
        this(true);
    }

    public WFSTCompletionLookup(boolean exactFirst) {
        this.exactFirst = exactFirst;
    }

    @Override
    public void build(TermFreqIterator iterator) throws IOException {
        if (iterator instanceof TermFreqPayloadIterator) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        BytesRef scratch = new BytesRef();
        WFSTTermFreqIteratorWrapper iter = new WFSTTermFreqIteratorWrapper(iterator);
        IntsRef scratchInts = new IntsRef();
        BytesRef previous = null;
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
        Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
        while ((scratch = iter.next()) != null) {
            long cost = iter.weight();
            if (previous == null) {
                previous = new BytesRef();
            } else if (scratch.equals(previous)) continue;
            Util.toIntsRef((BytesRef)scratch, (IntsRef)scratchInts);
            builder.add(scratchInts, (Object)cost);
            previous.copyBytes(scratch);
        }
        this.fst = builder.finish();
    }

    @Override
    public boolean store(OutputStream output) throws IOException {
        block3: {
            boolean bl;
            try {
                if (this.fst != null) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{output});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{output});
            return bl;
        }
        this.fst.save((DataOutput)new OutputStreamDataOutput(output));
        IOUtils.close((Closeable[])new Closeable[]{output});
        return true;
    }

    @Override
    public boolean load(InputStream input) throws IOException {
        try {
            this.fst = new FST((DataInput)new InputStreamDataInput(input), (Outputs)PositiveIntOutputs.getSingleton());
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{input});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{input});
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        assert (num > 0);
        if (onlyMorePopular) {
            throw new IllegalArgumentException("this suggester only works with onlyMorePopular=false");
        }
        if (this.fst == null) {
            return Collections.emptyList();
        }
        BytesRef scratch = new BytesRef(key);
        int prefixLength = scratch.length;
        FST.Arc arc = new FST.Arc();
        Long prefixOutput = null;
        try {
            prefixOutput = this.lookupPrefix(scratch, (FST.Arc<Long>)arc);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        if (prefixOutput == null) {
            return Collections.emptyList();
        }
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(num);
        CharsRef spare = new CharsRef();
        if (this.exactFirst && arc.isFinal()) {
            spare.grow(scratch.length);
            UnicodeUtil.UTF8toUTF16((BytesRef)scratch, (CharsRef)spare);
            results.add(new Lookup.LookupResult(spare.toString(), WFSTCompletionLookup.decodeWeight(prefixOutput + (Long)arc.nextFinalOutput)));
            if (--num == 0) {
                return results;
            }
        }
        Util.MinResult[] completions = null;
        try {
            completions = Util.shortestPaths(this.fst, (FST.Arc)arc, (Object)prefixOutput, weightComparator, (int)num, (!this.exactFirst ? 1 : 0) != 0);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        BytesRef suffix = new BytesRef(8);
        for (Util.MinResult completion : completions) {
            scratch.length = prefixLength;
            Util.toBytesRef((IntsRef)completion.input, (BytesRef)suffix);
            scratch.append(suffix);
            spare.grow(scratch.length);
            UnicodeUtil.UTF8toUTF16((BytesRef)scratch, (CharsRef)spare);
            results.add(new Lookup.LookupResult(spare.toString(), WFSTCompletionLookup.decodeWeight((Long)completion.output)));
        }
        return results;
    }

    private Long lookupPrefix(BytesRef scratch, FST.Arc<Long> arc) throws IOException {
        assert (0L == (Long)this.fst.outputs.getNoOutput());
        long output = 0L;
        FST.BytesReader bytesReader = this.fst.getBytesReader();
        this.fst.getFirstArc(arc);
        byte[] bytes = scratch.bytes;
        int pos = scratch.offset;
        int end = pos + scratch.length;
        while (pos < end) {
            if (this.fst.findTargetArc(bytes[pos++] & 0xFF, arc, arc, bytesReader) == null) {
                return null;
            }
            output += ((Long)arc.output).longValue();
        }
        return output;
    }

    public Object get(CharSequence key) {
        if (this.fst == null) {
            return null;
        }
        FST.Arc arc = new FST.Arc();
        Long result = null;
        try {
            result = this.lookupPrefix(new BytesRef(key), (FST.Arc<Long>)arc);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        if (result == null || !arc.isFinal()) {
            return null;
        }
        return WFSTCompletionLookup.decodeWeight(result + (Long)arc.nextFinalOutput);
    }

    private static int decodeWeight(long encoded) {
        return (int)(Integer.MAX_VALUE - encoded);
    }

    private static int encodeWeight(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return Integer.MAX_VALUE - (int)value;
    }

    private final class WFSTTermFreqIteratorWrapper
    extends SortedTermFreqIteratorWrapper {
        WFSTTermFreqIteratorWrapper(TermFreqIterator source) throws IOException {
            super(source);
        }

        @Override
        protected void encode(Sort.ByteSequencesWriter writer, ByteArrayDataOutput output, byte[] buffer, BytesRef spare, long weight) throws IOException {
            if (spare.length + 4 >= buffer.length) {
                buffer = ArrayUtil.grow((byte[])buffer, (int)(spare.length + 4));
            }
            output.reset(buffer);
            output.writeBytes(spare.bytes, spare.offset, spare.length);
            output.writeInt(WFSTCompletionLookup.encodeWeight(weight));
            writer.write(buffer, 0, output.getPosition());
        }

        @Override
        protected long decode(BytesRef scratch, ByteArrayDataInput tmpInput) {
            scratch.length -= 4;
            tmpInput.reset(scratch.bytes, scratch.offset + scratch.length, 4);
            return tmpInput.readInt();
        }
    }
}

