/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.jaspell;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.spell.TermFreqPayloadIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.UnsortedTermFreqIteratorWrapper;
import org.apache.lucene.search.suggest.jaspell.JaspellTernarySearchTrie;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.UnicodeUtil;

public class JaspellLookup
extends Lookup {
    JaspellTernarySearchTrie trie = new JaspellTernarySearchTrie();
    private boolean usePrefix = true;
    private int editDistance = 2;
    private static final byte LO_KID = 1;
    private static final byte EQ_KID = 2;
    private static final byte HI_KID = 4;
    private static final byte HAS_VALUE = 8;

    @Override
    public void build(TermFreqIterator tfit) throws IOException {
        BytesRef spare;
        if (tfit instanceof TermFreqPayloadIterator) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        if (tfit.getComparator() != null) {
            tfit = new UnsortedTermFreqIteratorWrapper(tfit);
        }
        this.trie = new JaspellTernarySearchTrie();
        this.trie.setMatchAlmostDiff(this.editDistance);
        CharsRef charsSpare = new CharsRef();
        while ((spare = tfit.next()) != null) {
            long weight = tfit.weight();
            if (spare.length == 0) continue;
            charsSpare.grow(spare.length);
            UnicodeUtil.UTF8toUTF16((byte[])spare.bytes, (int)spare.offset, (int)spare.length, (CharsRef)charsSpare);
            this.trie.put(charsSpare.toString(), weight);
        }
    }

    public boolean add(CharSequence key, Object value) {
        this.trie.put(key, value);
        return false;
    }

    public Object get(CharSequence key) {
        return this.trie.get(key);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        ArrayList<Lookup.LookupResult> res = new ArrayList<Lookup.LookupResult>();
        int count = onlyMorePopular ? num * 2 : num;
        List<String> list = this.usePrefix ? this.trie.matchPrefix(key, count) : this.trie.matchAlmost(key, count);
        if (list == null || list.size() == 0) {
            return res;
        }
        int maxCnt = Math.min(num, list.size());
        if (onlyMorePopular) {
            Lookup.LookupPriorityQueue queue = new Lookup.LookupPriorityQueue(num);
            for (String s : list) {
                long freq = ((Number)this.trie.get(s)).longValue();
                queue.insertWithOverflow(new Lookup.LookupResult((CharSequence)new CharsRef(s), freq));
            }
            for (Lookup.LookupResult lr : queue.getResults()) {
                res.add(lr);
            }
        } else {
            for (int i = 0; i < maxCnt; ++i) {
                String s = list.get(i);
                long freq = ((Number)this.trie.get(s)).longValue();
                res.add(new Lookup.LookupResult((CharSequence)new CharsRef(s), freq));
            }
        }
        return res;
    }

    private void readRecursively(DataInputStream in, JaspellTernarySearchTrie.TSTNode node) throws IOException {
        JaspellTernarySearchTrie.TSTNode kid;
        node.splitchar = in.readChar();
        byte mask = in.readByte();
        if ((mask & 8) != 0) {
            node.data = in.readLong();
        }
        if ((mask & 1) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[1] = kid = jaspellTernarySearchTrie.new JaspellTernarySearchTrie.TSTNode('\u0000', node);
            this.readRecursively(in, kid);
        }
        if ((mask & 2) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[2] = kid = jaspellTernarySearchTrie.new JaspellTernarySearchTrie.TSTNode('\u0000', node);
            this.readRecursively(in, kid);
        }
        if ((mask & 4) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[3] = kid = jaspellTernarySearchTrie.new JaspellTernarySearchTrie.TSTNode('\u0000', node);
            this.readRecursively(in, kid);
        }
    }

    private void writeRecursively(DataOutputStream out, JaspellTernarySearchTrie.TSTNode node) throws IOException {
        if (node == null) {
            return;
        }
        out.writeChar(node.splitchar);
        byte mask = 0;
        if (node.relatives[1] != null) {
            mask = (byte)(mask | 1);
        }
        if (node.relatives[2] != null) {
            mask = (byte)(mask | 2);
        }
        if (node.relatives[3] != null) {
            mask = (byte)(mask | 4);
        }
        if (node.data != null) {
            mask = (byte)(mask | 8);
        }
        out.writeByte(mask);
        if (node.data != null) {
            out.writeLong(((Number)node.data).longValue());
        }
        this.writeRecursively(out, node.relatives[1]);
        this.writeRecursively(out, node.relatives[2]);
        this.writeRecursively(out, node.relatives[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(OutputStream output) throws IOException {
        JaspellTernarySearchTrie.TSTNode root = this.trie.getRoot();
        if (root == null) {
            return false;
        }
        DataOutputStream out = new DataOutputStream(output);
        try {
            this.writeRecursively(out, root);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{out});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(InputStream input) throws IOException {
        DataInputStream in = new DataInputStream(input);
        JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
        jaspellTernarySearchTrie.getClass();
        JaspellTernarySearchTrie.TSTNode root = jaspellTernarySearchTrie.new JaspellTernarySearchTrie.TSTNode('\u0000', null);
        try {
            this.readRecursively(in, root);
            this.trie.setRoot(root);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{in});
        return true;
    }
}

