/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.apache.lucene.search.spell.Dictionary;

public class PlainTextDictionary
implements Dictionary {
    private BufferedReader in;
    private String line;
    private boolean has_next_called;

    public PlainTextDictionary(File file) throws FileNotFoundException {
        this.in = new BufferedReader(new FileReader(file));
    }

    public PlainTextDictionary(InputStream dictFile) {
        this.in = new BufferedReader(new InputStreamReader(dictFile));
    }

    public Iterator getWordsIterator() {
        return new fileIterator();
    }

    final class fileIterator
    implements Iterator {
        fileIterator() {
        }

        public Object next() {
            if (!PlainTextDictionary.this.has_next_called) {
                this.hasNext();
            }
            PlainTextDictionary.this.has_next_called = false;
            return PlainTextDictionary.this.line;
        }

        public boolean hasNext() {
            PlainTextDictionary.this.has_next_called = true;
            try {
                PlainTextDictionary.this.line = PlainTextDictionary.this.in.readLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                PlainTextDictionary.this.line = null;
                return false;
            }
            return PlainTextDictionary.this.line != null;
        }

        public void remove() {
        }
    }
}

