/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.spell.Dictionary;

public class LuceneDictionary
implements Dictionary {
    IndexReader reader;
    String field;

    public LuceneDictionary(IndexReader reader, String field) {
        this.reader = reader;
        this.field = field;
    }

    public final Iterator getWordsIterator() {
        return new LuceneIterator();
    }

    final class LuceneIterator
    implements Iterator {
        private TermEnum termEnum;
        private Term actualTerm;
        private boolean has_next_called;

        public LuceneIterator() {
            try {
                this.termEnum = LuceneDictionary.this.reader.terms(new Term(LuceneDictionary.this.field, ""));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public Object next() {
            if (!this.has_next_called) {
                this.hasNext();
            }
            this.has_next_called = false;
            return this.actualTerm != null ? this.actualTerm.text() : null;
        }

        public boolean hasNext() {
            this.has_next_called = true;
            try {
                if (!this.termEnum.next()) {
                    this.actualTerm = null;
                    return false;
                }
                this.actualTerm = this.termEnum.term();
                String fieldt = this.actualTerm.field();
                if (fieldt != LuceneDictionary.this.field) {
                    this.actualTerm = null;
                    return false;
                }
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }

        public void remove() {
        }
    }
}

