/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBasePolygon;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

public class GeoConvexPolygon
extends GeoBasePolygon {
    protected final List<GeoPoint> points;
    protected final BitSet isInternalEdges;
    protected SidedPlane[] edges = null;
    protected GeoPoint[][] notableEdgePoints = null;
    protected GeoPoint[] edgePoints = null;
    protected double fullDistance = 0.0;
    protected boolean isDone = false;

    public GeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        super(planetModel);
        this.points = pointList;
        this.isInternalEdges = new BitSet();
        this.done(false);
    }

    public GeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList, BitSet internalEdgeFlags, boolean returnEdgeInternal) {
        super(planetModel);
        this.points = pointList;
        this.isInternalEdges = internalEdgeFlags;
        this.done(returnEdgeInternal);
    }

    public GeoConvexPolygon(PlanetModel planetModel, double startLatitude, double startLongitude) {
        super(planetModel);
        this.points = new ArrayList<GeoPoint>();
        this.isInternalEdges = new BitSet();
        this.points.add(new GeoPoint(planetModel, startLatitude, startLongitude));
    }

    public void addPoint(double latitude, double longitude, boolean isInternalEdge) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call addPoint() if done() already called");
        }
        if (isInternalEdge) {
            this.isInternalEdges.set(this.points.size() - 1);
        }
        this.points.add(new GeoPoint(this.planetModel, latitude, longitude));
    }

    public void done(boolean isInternalReturnEdge) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call done() more than once");
        }
        if (this.points.size() < 3) {
            throw new IllegalArgumentException("Polygon needs at least three points.");
        }
        if (isInternalReturnEdge) {
            this.isInternalEdges.set(this.points.size() - 1);
        }
        this.isDone = true;
        this.edges = new SidedPlane[this.points.size()];
        this.notableEdgePoints = new GeoPoint[this.points.size()][];
        for (int i = 0; i < this.points.size(); ++i) {
            SidedPlane sp;
            GeoPoint end;
            GeoPoint start = this.points.get(i);
            double distance = start.arcDistance(end = this.points.get(this.legalIndex(i + 1)));
            if (distance > this.fullDistance) {
                this.fullDistance = distance;
            }
            GeoPoint check = this.points.get(this.legalIndex(i + 2));
            this.edges[i] = sp = new SidedPlane((Vector)check, (Vector)start, end);
            this.notableEdgePoints[i] = new GeoPoint[]{start, end};
        }
        this.createCenterPoint();
    }

    protected void createCenterPoint() {
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            for (int pointIndex = 0; pointIndex < this.points.size(); ++pointIndex) {
                if (pointIndex == edgeIndex || pointIndex == this.legalIndex(edgeIndex + 1) || edge.isWithin(this.points.get(pointIndex))) continue;
                throw new IllegalArgumentException("Polygon is not convex: Point " + this.points.get(pointIndex) + " Edge " + edge);
            }
        }
        this.edgePoints = new GeoPoint[]{this.points.get(0)};
    }

    protected int legalIndex(int index) {
        while (index >= this.points.size()) {
            index -= this.points.size();
        }
        return index;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (SidedPlane edge : this.edges) {
            if (edge.isWithin(x, y, z)) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            GeoPoint[] points = this.notableEdgePoints[edgeIndex];
            if (this.isInternalEdges.get(edgeIndex)) continue;
            Membership[] membershipBounds = new Membership[this.edges.length - 1];
            int count = 0;
            for (int otherIndex = 0; otherIndex < this.edges.length; ++otherIndex) {
                if (otherIndex == edgeIndex) continue;
                membershipBounds[count++] = this.edges[otherIndex];
            }
            if (!edge.intersects(this.planetModel, p, notablePoints, points, bounds, membershipBounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        for (GeoPoint point : this.points) {
            bounds.addPoint(point);
        }
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            Membership[] membershipBounds = new Membership[this.edges.length - 1];
            int count = 0;
            for (int otherIndex = 0; otherIndex < this.edges.length; ++otherIndex) {
                if (otherIndex == edgeIndex) continue;
                membershipBounds[count++] = this.edges[otherIndex];
            }
            bounds.addPlane(this.planetModel, edge, membershipBounds);
        }
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double minimumDistance = Double.MAX_VALUE;
        for (GeoPoint edgePoint : this.points) {
            double newDist = distanceStyle.computeDistance(edgePoint, x, y, z);
            if (!(newDist < minimumDistance)) continue;
            minimumDistance = newDist;
        }
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edgePlane = this.edges[edgeIndex];
            Membership[] membershipBounds = new Membership[this.edges.length - 1];
            int count = 0;
            for (int otherIndex = 0; otherIndex < this.edges.length; ++otherIndex) {
                if (otherIndex == edgeIndex) continue;
                membershipBounds[count++] = this.edges[otherIndex];
            }
            double newDist = distanceStyle.computeDistance(this.planetModel, (Plane)edgePlane, x, y, z, membershipBounds);
            if (!(newDist < minimumDistance)) continue;
            minimumDistance = newDist;
        }
        return minimumDistance;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoConvexPolygon)) {
            return false;
        }
        GeoConvexPolygon other = (GeoConvexPolygon)o;
        if (!super.equals(other)) {
            return false;
        }
        if (!other.isInternalEdges.equals(this.isInternalEdges)) {
            return false;
        }
        return other.points.equals(this.points);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.points.hashCode();
        return result;
    }

    public String toString() {
        return "GeoConvexPolygon: {planetmodel=" + this.planetModel + ", points=" + this.points + "}";
    }
}

